/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.widget.TablePanel;
import com.mathworks.webservices.mls.model.Entitlement;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class EntitlementSelectionDialog
extends MJDialog {
    private Entitlement[] fEntitlements;
    private TablePanel fTablePanel;
    private boolean fUserCancelled = false;
    private JButton fOkButton;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");

    public EntitlementSelectionDialog(Entitlement[] entitlementArray) {
        this.createUI(entitlementArray);
    }

    public EntitlementSelectionDialog(JFrame jFrame, Entitlement[] entitlementArray) {
        super((Frame)jFrame);
        this.createUI(entitlementArray);
    }

    public EntitlementSelectionDialog(JDialog jDialog, Entitlement[] entitlementArray) {
        super((Dialog)jDialog);
        this.createUI(entitlementArray);
    }

    private void createUI(Entitlement[] entitlementArray) {
        this.fEntitlements = entitlementArray;
        MJLabel mJLabel = new MJLabel(sRes.getString("EntitlementSelectionDialog.MultipleLicenseLabel"));
        MJLabel mJLabel2 = new MJLabel(sRes.getString("EntitlementSelectionDialog.SelectLicenseLabel"));
        MJLabel mJLabel3 = new MJLabel(sRes.getString("EntitlementSelectionDialog.NoteLabel"));
        this.fOkButton = new MJButton((Action)new MJAbstractAction(sRes.getString("EntitlementSelectionDialog.OkButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                EntitlementSelectionDialog.this.setVisible(false);
            }
        });
        this.fOkButton.setEnabled(false);
        MJButton mJButton = new MJButton((Action)new MJAbstractAction(sRes.getString("EntitlementSelectionDialog.CancelButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                EntitlementSelectionDialog.this.fUserCancelled = true;
                EntitlementSelectionDialog.this.setVisible(false);
            }
        });
        this.fTablePanel = new TablePanel(new EntitlementsTableModel(entitlementArray), "LicenseSelection");
        this.fTablePanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    return;
                }
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    EntitlementSelectionDialog.this.fOkButton.setEnabled(true);
                }
            }
        });
        this.fTablePanel.packColumn(0, 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                EntitlementSelectionDialog.this.fUserCancelled = true;
                super.windowClosing(windowEvent);
            }
        });
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.addLine((JComponent)mJLabel);
        styleGuidePanel.addLine((JComponent)mJLabel2);
        styleGuidePanel.addLine((JComponent)((Object)this.fTablePanel), 8);
        styleGuidePanel.addLine((JComponent)mJLabel3);
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{null, this.fOkButton, mJButton}}, 0, 0);
        this.setContentPane((Container)((Object)styleGuidePanel));
        this.setSize(375, 325);
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(sRes.getString("EntitlementSelectionDialog.Title"));
        this.fOkButton.setName("OKButton");
        this.fOkButton.setName("CancelButton");
    }

    public Entitlement getEntitlement() {
        if (this.fUserCancelled) {
            return null;
        }
        int n = this.fTablePanel.getSelectedRow();
        return n > -1 ? this.fEntitlements[n] : null;
    }

    private static final class EntitlementsTableModel
    extends AbstractTableModel {
        private final Entitlement[] fEntitlements;
        private static final int NUM_COLUMNS = 2;
        private static final int LICENSE_NUMBER_COL = 0;
        private static final int LABEL_COL = 1;

        private EntitlementsTableModel(Entitlement[] entitlementArray) {
            this.fEntitlements = entitlementArray;
        }

        @Override
        public int getRowCount() {
            return this.fEntitlements.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Entitlement entitlement = this.fEntitlements[n];
            if (n2 == 0) {
                return entitlement.getLicenseNumber();
            }
            if (n2 == 1) {
                return entitlement.getLabel();
            }
            assert (false) : "Unknown column index - " + n2;
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return sRes.getString("EntitlementSelectionDialog.LicenseColumn");
            }
            if (n == 1) {
                return sRes.getString("EntitlementSelectionDialog.LabelColumn");
            }
            assert (false) : "Unknown column index - " + n;
            return super.getColumnName(n);
        }
    }
}

