/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    private FileUtils() {
    }

    public static String convertToLocalSeparators(String string) {
        char c;
        char c2 = File.separatorChar;
        switch (c2) {
            case '\\': {
                c = '/';
                break;
            }
            case '/': {
                c = '\\';
                break;
            }
            default: {
                throw new IllegalStateException("Unknown path separator char");
            }
        }
        return string.replace(c, c2);
    }

    public static void createNewFileAndParent(File file) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new DirectoryCreationFailedException(file);
        }
        file.createNewFile();
    }

    public static boolean containsFile(File file, File file2) {
        if (!file2.exists() || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            for (File file3 = file2; file3 != null; file3 = file3.getParentFile()) {
                if (!file.equals(file3)) continue;
                return true;
            }
        }
        return false;
    }

    private static final class DirectoryCreationFailedException
    extends IOException
    implements I18nMatlabIdentifiedException {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fMessageID;

        private DirectoryCreationFailedException(File file) {
            this.fMessageID = new mjs.DirectoryCreationFailed(file.toString());
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.fMessageID);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.fMessageID);
        }

        public String getMessageID() {
            return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
        }
    }
}

