/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Version {
    private static final Map<Integer, VersionReleasePair> VERSION_NUMBER_AND_STRING_MAP = Version.createVersionNumberStringMap();
    public static final int VERSION_NUM = 20;
    public static final String VERSION_STRING = Version.getVersionStringFromNumber(20);

    public static void main(String[] stringArray) {
        System.out.print(VERSION_STRING);
    }

    public static String getVersionStringFromNumber(int n) {
        return VERSION_NUMBER_AND_STRING_MAP.containsKey(n) ? VERSION_NUMBER_AND_STRING_MAP.get(n).getVersion() : "";
    }

    public static String getReleaseStringFromNumber(int n) {
        return VERSION_NUMBER_AND_STRING_MAP.containsKey(n) ? VERSION_NUMBER_AND_STRING_MAP.get(n).getRelease() : "";
    }

    public static int getVersionNumberFromVersionString(String string) {
        int n = 0;
        for (Integer n2 : VERSION_NUMBER_AND_STRING_MAP.keySet()) {
            if (!VERSION_NUMBER_AND_STRING_MAP.get(n2).getVersion().equals(string)) continue;
            n = n2;
            break;
        }
        return n;
    }

    private static Map<Integer, VersionReleasePair> createVersionNumberStringMap() {
        HashMap<Integer, VersionReleasePair> hashMap = new HashMap<Integer, VersionReleasePair>();
        hashMap.put(2, new VersionReleasePair("2.0", "R14SP3"));
        hashMap.put(3, new VersionReleasePair("2.0.1", "R2006a"));
        hashMap.put(4, new VersionReleasePair("3.0", "R2006b"));
        hashMap.put(5, new VersionReleasePair("3.1", "R2007a"));
        hashMap.put(6, new VersionReleasePair("3.2", "R2007b"));
        hashMap.put(7, new VersionReleasePair("3.3", "R2008a"));
        hashMap.put(8, new VersionReleasePair("4.0", "R2008b"));
        hashMap.put(9, new VersionReleasePair("4.1", "R2009a"));
        hashMap.put(10, new VersionReleasePair("4.2", "R2009b"));
        hashMap.put(11, new VersionReleasePair("4.3", "R2010a"));
        hashMap.put(12, new VersionReleasePair("5.0", "R2010b"));
        hashMap.put(13, new VersionReleasePair("5.1", "R2011a"));
        hashMap.put(14, new VersionReleasePair("5.2", "R2011b"));
        hashMap.put(15, new VersionReleasePair("6.0", "R2012a"));
        hashMap.put(16, new VersionReleasePair("6.1", "R2012b"));
        hashMap.put(17, new VersionReleasePair("6.2", "R2013a"));
        hashMap.put(18, new VersionReleasePair("6.3", "R2013b"));
        hashMap.put(19, new VersionReleasePair("6.4", "R2014a"));
        hashMap.put(20, new VersionReleasePair("6.5", "R2014b"));
        return Collections.unmodifiableMap(hashMap);
    }

    private static final class VersionReleasePair {
        private final String fVersion;
        private final String fRelease;

        VersionReleasePair(String string, String string2) {
            this.fVersion = string;
            this.fRelease = string2;
        }

        public String getVersion() {
            return this.fVersion;
        }

        public String getRelease() {
            return this.fRelease;
        }
    }
}

