/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.worker.matlab.PackageInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;

final class MatlabDirectories {
    private final File fMatlabPrefDirectory;
    private final File fMatlabLogDirectory;
    private final File fMatlabHomeDirectory;
    private final File fBaseDirectory;
    private static final FilenameFilter CRASH_DUMP_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("matlab_crash_dump");
        }
    };

    MatlabDirectories(File file) throws IOException {
        this.fBaseDirectory = file;
        this.fMatlabLogDirectory = new File(this.fBaseDirectory, "logs");
        this.fMatlabPrefDirectory = new File(this.fBaseDirectory, "prefs");
        this.fMatlabHomeDirectory = new File(this.fBaseDirectory, "home");
    }

    void makeDirectories() throws IOException {
        FileUtils.forceMkdir((File)this.fMatlabLogDirectory);
        FileUtils.forceMkdir((File)this.fMatlabPrefDirectory);
        FileUtils.forceMkdir((File)this.fMatlabHomeDirectory);
    }

    void cleanPrefDirectory() throws IOException {
        if (this.fMatlabPrefDirectory.exists() && this.fMatlabPrefDirectory.isDirectory()) {
            FileUtils.cleanDirectory((File)this.fMatlabPrefDirectory);
        }
    }

    void cleanLogDirectory() throws IOException {
        if (this.fMatlabLogDirectory.exists() && this.fMatlabLogDirectory.isDirectory()) {
            FileUtils.cleanDirectory((File)this.fMatlabLogDirectory);
        }
    }

    void cleanHomeDirectory() throws IOException {
        if (this.fMatlabHomeDirectory.exists() && this.fMatlabHomeDirectory.isDirectory()) {
            FileUtils.cleanDirectory((File)this.fMatlabHomeDirectory);
        }
    }

    void deleteDirectories() throws IOException {
        FileUtils.deleteDirectory((File)this.fBaseDirectory);
    }

    File getLogDirectory() {
        return this.fMatlabLogDirectory;
    }

    File getPrefDirectory() {
        return this.fMatlabPrefDirectory;
    }

    File getHomeDirectory() {
        return this.fMatlabHomeDirectory;
    }

    Set<File> copyCrashDumpFilesTo(File file) {
        File[] fileArray = this.fMatlabLogDirectory.listFiles(CRASH_DUMP_FILENAME_FILTER);
        if (null == fileArray) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>(fileArray.length);
        for (File file2 : fileArray) {
            try {
                PackageInfo.LOGGER.info("Copying " + file2 + " to " + file);
                FileUtils.copyFileToDirectory((File)file2, (File)file);
                hashSet.add(new File(file, file2.getName()));
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.warning("Failed to copy " + file2 + " to " + file + "\n" + "Error was " + iOException.getMessage());
            }
        }
        return hashSet;
    }
}

