/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.process.CommandLine;
import com.mathworks.toolbox.distcomp.worker.PersistentWorkerConfiguration;
import com.mathworks.toolbox.distcomp.worker.matlab.CommandLineBuilder;
import com.mathworks.toolbox.distcomp.worker.matlab.CommandLineDecorator;
import com.mathworks.toolbox.distcomp.worker.matlab.PackageInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.util.PlatformInfo;
import java.util.Arrays;

public class MatlabRunAsUserCommandLineDecorator
implements CommandLineDecorator {
    private final CommandLineBuilder fCommandLineBuilder;
    private final PersistentWorkerConfiguration fWorkerConfig;
    private final PlainCredentials fCredentials;

    public MatlabRunAsUserCommandLineDecorator(CommandLineBuilder commandLineBuilder, PersistentWorkerConfiguration persistentWorkerConfiguration, PlainCredentials plainCredentials) {
        this.fCommandLineBuilder = commandLineBuilder;
        this.fWorkerConfig = persistentWorkerConfiguration;
        this.fCredentials = plainCredentials;
    }

    @Override
    public CommandLine getCommandLine() {
        CommandLine commandLine = this.fCommandLineBuilder.getCommandLine();
        String string = this.fWorkerConfig.getWindowsDomain();
        String string2 = this.fCredentials.getUserIdentity().getSimpleUsername();
        String string3 = this.makeFullUserName(string2, string);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Setting username to " + string3);
        Erasable erasable = this.fCredentials.getPassword();
        char[] cArray = erasable.toCharArray();
        String string4 = new String(cArray);
        Arrays.fill(cArray, ' ');
        erasable.erase();
        commandLine.user(string3, string4);
        return commandLine;
    }

    private String makeFullUserName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (PlatformInfo.isWindows() && this.isUserDomainSet(string2)) {
            stringBuilder.append(string2).append("\\");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private boolean isUserDomainSet(String string) {
        return string != null && string.length() > 1;
    }
}

