/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.worker.matlab.Pinger;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessStateListener;

public class ProcessWatcher {
    private final Thread fStartThread;
    private final Thread fEndThread;

    public ProcessWatcher(final Process process, final Pinger pinger, final ProcessStateListener processStateListener) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (!pinger.ping()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        process.destroy();
                        return;
                    }
                }
                processStateListener.processStarted();
            }
        };
        this.fStartThread = new Thread(runnable);
        this.fStartThread.setDaemon(true);
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                int n;
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    process.destroy();
                    n = process.exitValue();
                }
                ProcessWatcher.this.fStartThread.interrupt();
                processStateListener.processShutdown(n);
            }
        };
        this.fEndThread = new Thread(runnable2);
        this.fEndThread.setDaemon(true);
    }

    public void startWatching() {
        this.fStartThread.start();
        this.fEndThread.start();
    }

    public Thread getStartWatcherThread() {
        return this.fStartThread;
    }

    public Thread getEndWatcherThread() {
        return this.fEndThread;
    }
}

