/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.AuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.cwo.TaskCWOStreamIdentifier;
import com.mathworks.toolbox.distcomp.mjs.cwo.TaskInputStreamHandler;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreBackedDataSender;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.storage.CredentialStorageException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitStorage;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProperties;
import com.mathworks.toolbox.distcomp.workunit.DataAccessor;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccess;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessImpl;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessProxy;
import com.mathworks.toolbox.distcomp.workunit.FailedTaskInfo;
import com.mathworks.toolbox.distcomp.workunit.Task;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessProxy;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessRemote;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnit;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitAccessImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import net.jini.id.Uuid;

public class TaskAccessImpl
extends WorkUnitAccessImpl
implements TaskAccessRemote {
    private Semaphore fMaxConcurrentSubmissions;
    private TaskInputStreamHandler fCWOInputStreamHandler = null;

    public TaskAccessImpl(long l, WorkUnitStorage workUnitStorage, String string, JobManagerProxy jobManagerProxy, AuthorisationModule authorisationModule, int n, ExporterFactory exporterFactory) throws ExportException, DistcompProxy.SerializeProxyException {
        super(l, workUnitStorage, string, jobManagerProxy, authorisationModule, exporterFactory);
        this.fMaxConcurrentSubmissions = new Semaphore(n, true);
    }

    public void setCWOInputStreamHandler(TaskInputStreamHandler taskInputStreamHandler) {
        assert (taskInputStreamHandler != null) : "The input stream handler must not be null";
        this.fCWOInputStreamHandler = taskInputStreamHandler;
    }

    private TaskInputStreamHandler getCWOInputStreamHandler() {
        assert (this.fCWOInputStreamHandler != null) : "The task access has not been correctly initialized, its CWOInputStreamHandler is null";
        return this.fCWOInputStreamHandler;
    }

    @Override
    protected DistcompAccessProxy createProxy(DistcompAccess distcompAccess, JobManagerProxy jobManagerProxy) throws DistcompProxy.SerializeProxyException {
        return new TaskAccessProxy((TaskAccessRemote)distcompAccess, this.fMinTransferUsingDataStore, jobManagerProxy);
    }

    @Override
    public String[][] getAutoAttachedFileList(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (String[][])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            private String[][] iGetAutoAttachedFileList;
            {
                super(uuidArray3);
                this.iGetAutoAttachedFileList = new String[uuidArray.length][];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetAutoAttachedFileList[n] = ((Task)workUnit).getAutoAttachedFileList();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetAutoAttachedFileList;
            }
        });
    }

    @Override
    public boolean[] getCaptureCommandWindowOutput(final Uuid[] uuidArray) throws MJSException {
        return (boolean[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            boolean[] iCaptureCommandWindowOutputs;
            {
                super(uuidArray3);
                this.iCaptureCommandWindowOutputs = new boolean[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iCaptureCommandWindowOutputs[n] = ((Task)workUnit).isCaptureCommandWindowOutput();
            }

            @Override
            protected Object getReturnValue() {
                return this.iCaptureCommandWindowOutputs;
            }
        });
    }

    @Override
    public int[] getNumOutArgs(final Uuid[] uuidArray) throws MJSException {
        return (int[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            int[] iGetNumOutArgs;
            {
                super(uuidArray3);
                this.iGetNumOutArgs = new int[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetNumOutArgs[n] = ((Task)workUnit).getNumOutArgs();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetNumOutArgs;
            }
        });
    }

    @Override
    public byte[][] getErrorStruct(final Uuid[] uuidArray) throws MJSException {
        return (byte[][])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            byte[][] iGetErrorStruct;
            {
                super(uuidArray3);
                this.iGetErrorStruct = new byte[uuidArray.length][];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetErrorStruct[n] = ((Task)workUnit).getErrorStruct();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetErrorStruct;
            }
        });
    }

    @Override
    public String[] getErrorMessage(final Uuid[] uuidArray) throws MJSException {
        return (String[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[] iGetErrorMessage;
            {
                super(uuidArray3);
                this.iGetErrorMessage = new String[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetErrorMessage[n] = ((Task)workUnit).getErrorMessage();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetErrorMessage;
            }
        });
    }

    @Override
    public String[] getErrorIdentifier(final Uuid[] uuidArray) throws MJSException {
        return (String[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[] iGetErrorIdentifier;
            {
                super(uuidArray3);
                this.iGetErrorIdentifier = new String[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetErrorIdentifier[n] = ((Task)workUnit).getErrorIdentifier();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetErrorIdentifier;
            }
        });
    }

    @Override
    public Worker[] getWorker(final Uuid[] uuidArray) throws MJSException {
        return (Worker[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            Worker[] iWorker;
            {
                super(uuidArray3);
                this.iWorker = new Worker[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iWorker[n] = ((Task)workUnit).getWorker();
            }

            @Override
            protected Object getReturnValue() {
                return this.iWorker;
            }
        });
    }

    @Override
    public WorkerProperties[] getWorkerProperties(final Uuid[] uuidArray) throws RemoteException, MJSException {
        return (WorkerProperties[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            WorkerProperties[] iWorkerProperties;
            {
                super(uuidArray3);
                this.iWorkerProperties = new WorkerProperties[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                Task task = (Task)workUnit;
                Worker worker = task.getWorker();
                if (worker != null) {
                    try {
                        this.iWorkerProperties[n] = worker.getWorkerProperties();
                    }
                    catch (RemoteException remoteException) {
                        throw new LocalCallThrewRemoteException(remoteException);
                    }
                }
            }

            @Override
            protected Object getReturnValue() {
                return this.iWorkerProperties;
            }
        });
    }

    @Override
    public Uuid[] getJob(final Uuid[] uuidArray) throws MJSException {
        return (Uuid[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            Uuid[] iJob;
            {
                super(uuidArray3);
                this.iJob = new Uuid[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iJob[n] = ((Task)workUnit).getJob();
            }

            @Override
            protected Object getReturnValue() {
                return this.iJob;
            }
        });
    }

    @Override
    public int[] getLogLevel(final Uuid[] uuidArray) throws MJSException {
        return (int[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            int[] iLogLevels;
            {
                super(uuidArray3);
                this.iLogLevels = new int[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iLogLevels[n] = ((Task)workUnit).getLogLevel();
            }

            @Override
            protected Object getReturnValue() {
                return this.iLogLevels;
            }
        });
    }

    @Override
    public int[] getMaximumNumberOfRetries(final Uuid[] uuidArray) throws MJSException {
        return (int[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            int[] iGetMaximumNumberOfRetries;
            {
                super(uuidArray3);
                this.iGetMaximumNumberOfRetries = new int[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetMaximumNumberOfRetries[n] = ((Task)workUnit).getMaximumNumberOfRetries();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetMaximumNumberOfRetries;
            }
        });
    }

    @Override
    public int[] getAttemptedNumberOfRetries(final Uuid[] uuidArray) throws MJSException {
        return (int[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            int[] iGetAttemptedNumberOfRetries;
            {
                super(uuidArray3);
                this.iGetAttemptedNumberOfRetries = new int[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetAttemptedNumberOfRetries[n] = ((Task)workUnit).getAttemptedNumberOfRetries();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetAttemptedNumberOfRetries;
            }
        });
    }

    @Override
    public TaskInfo[][] getFailedAttemptInformation(DataStore dataStore, final Uuid[] uuidArray, CredentialProviderLocal credentialProviderLocal) throws MJSException {
        List list = (List)this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            private List<FailedTaskInfo[]> iGetFailedAttemptInformation;
            {
                super(uuidArray3);
                this.iGetFailedAttemptInformation = new ArrayList<FailedTaskInfo[]>(uuidArray.length);
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                FailedTaskInfo[] failedTaskInfoArray = ((Task)workUnit).getFailedAttemptInformation();
                if (failedTaskInfoArray != null) {
                    this.iGetFailedAttemptInformation.add(failedTaskInfoArray);
                }
            }

            @Override
            protected List<FailedTaskInfo[]> getReturnValue() {
                return this.iGetFailedAttemptInformation;
            }
        });
        DataStoreBackedDataSender<FailedTaskInfo> dataStoreBackedDataSender = new DataStoreBackedDataSender<FailedTaskInfo>(dataStore, this.fMinTransferUsingDataStore);
        TaskInfo[][] taskInfoArray = new TaskInfo[uuidArray.length][];
        for (int i = 0; i < list.size(); ++i) {
            FailedTaskInfo[] failedTaskInfoArray = (FailedTaskInfo[])list.get(i);
            TransferableData[] transferableDataArray = dataStoreBackedDataSender.transferData(Arrays.asList(failedTaskInfoArray), this.createFailedAttemptInformationAccessor(credentialProviderLocal, uuidArray[i]));
            taskInfoArray[i] = this.convertToTaskInfoWithLargeData(failedTaskInfoArray, transferableDataArray);
        }
        return taskInfoArray;
    }

    private TaskInfo[] convertToTaskInfoWithLargeData(FailedTaskInfo[] failedTaskInfoArray, TransferableData[] transferableDataArray) {
        TaskInfo[] taskInfoArray = new TaskInfo[failedTaskInfoArray.length];
        for (int i = 0; i < failedTaskInfoArray.length; ++i) {
            taskInfoArray[i] = failedTaskInfoArray[i].toTaskInfo();
            taskInfoArray[i].setCommandWindowOutput(transferableDataArray[i]);
        }
        return taskInfoArray;
    }

    private DataAccessor<FailedTaskInfo> createFailedAttemptInformationAccessor(final CredentialProviderLocal credentialProviderLocal, final Uuid uuid) {
        return new DataAccessor<FailedTaskInfo>(){

            @Override
            public void doCredentialCheck(FailedTaskInfo failedTaskInfo) throws MJSException {
                TaskAccessImpl.this.checkCredentials(uuid, credentialProviderLocal);
            }

            @Override
            public int getDataSize(FailedTaskInfo failedTaskInfo) {
                return failedTaskInfo.getCommandWindowOutputSize();
            }

            @Override
            public byte[] getDataDirect(FailedTaskInfo failedTaskInfo) throws MJSException {
                return failedTaskInfo.getCommandWindowOutput();
            }

            @Override
            public void getDataViaStream(FailedTaskInfo failedTaskInfo, OutputStream outputStream, int n) throws MJSException {
                failedTaskInfo.getCommandWindowOutput(outputStream, n);
            }
        };
    }

    @Override
    public LargeData[] getLogOutput(DataStore dataStore, Uuid[] uuidArray) throws RemoteException, MJSException {
        DataStoreBackedDataSender<TaskImpl> dataStoreBackedDataSender = new DataStoreBackedDataSender<TaskImpl>(dataStore, this.fMinTransferUsingDataStore);
        List<TaskImpl> list = this.readTasks(uuidArray);
        return dataStoreBackedDataSender.transferData(list, this.createLogOutputAccessor());
    }

    private DataAccessor<TaskImpl> createLogOutputAccessor() {
        return new DataAccessor<TaskImpl>(){

            @Override
            public void doCredentialCheck(TaskImpl taskImpl) throws AuthorisationFailedException {
            }

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getLogOutputSize();
            }

            @Override
            public byte[] getDataDirect(TaskImpl taskImpl) throws MJSException {
                return taskImpl.getLogOutput();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getLogOutput(outputStream, n);
            }
        };
    }

    @Override
    public void addToLogOutput(Uuid[] uuidArray, final String[] stringArray) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                ((Task)workUnit).addToLogOutput(stringArray[n]);
            }
        });
    }

    @Override
    public void addCommandWindowOutputStreamToTask(TaskCWOStreamIdentifier[] taskCWOStreamIdentifierArray, InputStream[] inputStreamArray) {
        for (int i = 0; i < inputStreamArray.length; ++i) {
            this.getCWOInputStreamHandler().registerStreamForTask(taskCWOStreamIdentifierArray[i], inputStreamArray[i]);
        }
    }

    @Override
    public void removeCommandWindowOutputStreamFromTask(TaskCWOStreamIdentifier[] taskCWOStreamIdentifierArray) throws MJSException, RemoteException {
        for (int i = 0; i < taskCWOStreamIdentifierArray.length; ++i) {
            this.getCWOInputStreamHandler().unregisterStreamForTask(taskCWOStreamIdentifierArray[i]);
        }
    }

    @Override
    public void notifyBytesAvailable(TaskCWOStreamIdentifier taskCWOStreamIdentifier) throws MJSException, RemoteException {
        this.getCWOInputStreamHandler().notifyBytesAvailable(taskCWOStreamIdentifier);
    }

    @Override
    public void writeCommandWindowOutput(Uuid[] uuidArray, final byte[][] byArray) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                ((Task)workUnit).writeCommandWindowOutput(byArray[n]);
            }
        });
    }

    @Override
    public String[] getMLFunctionName(final Uuid[] uuidArray) throws MJSException {
        return (String[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            String[] iGetFunctionName;
            {
                super(uuidArray3);
                this.iGetFunctionName = new String[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetFunctionName[n] = ((Task)workUnit).getMLFunctionName();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetFunctionName;
            }
        });
    }

    @Override
    public LargeData[] getCommandWindowOutput(DataStore dataStore, Uuid[] uuidArray, CredentialProviderLocal credentialProviderLocal) throws RemoteException, MJSException {
        DataStoreBackedDataSender<TaskImpl> dataStoreBackedDataSender = new DataStoreBackedDataSender<TaskImpl>(dataStore, this.fMinTransferUsingDataStore);
        List<TaskImpl> list = this.readTasks(uuidArray);
        return dataStoreBackedDataSender.transferData(list, this.createCommandWindowOutputAccessor(credentialProviderLocal));
    }

    private DataAccessor<TaskImpl> createCommandWindowOutputAccessor(final CredentialProviderLocal credentialProviderLocal) {
        return new DataAccessor<TaskImpl>(){

            @Override
            public void doCredentialCheck(TaskImpl taskImpl) throws AuthorisationFailedException, CredentialStorageException {
                TaskAccessImpl.this.checkCredentials(taskImpl, credentialProviderLocal);
            }

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getCommandWindowOutputSize();
            }

            @Override
            public byte[] getDataDirect(TaskImpl taskImpl) throws MJSException {
                return taskImpl.getCommandWindowOutput();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getCommandWindowOutput(outputStream, n);
            }
        };
    }

    @Override
    public LargeData[] getInputData(DataStore dataStore, Uuid[] uuidArray, CredentialProviderLocal credentialProviderLocal) throws RemoteException, MJSException {
        DataStoreBackedDataSender<TaskImpl> dataStoreBackedDataSender = new DataStoreBackedDataSender<TaskImpl>(dataStore, this.fMinTransferUsingDataStore);
        List<TaskImpl> list = this.readTasks(uuidArray);
        return dataStoreBackedDataSender.transferData(list, this.createInputDataAccessor(credentialProviderLocal));
    }

    private DataAccessor<TaskImpl> createInputDataAccessor(final CredentialProviderLocal credentialProviderLocal) {
        return new DataAccessor<TaskImpl>(){

            @Override
            public void doCredentialCheck(TaskImpl taskImpl) throws AuthorisationFailedException, CredentialStorageException {
                TaskAccessImpl.this.checkCredentials(taskImpl, credentialProviderLocal);
            }

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getInputDataSize();
            }

            @Override
            public byte[] getDataDirect(TaskImpl taskImpl) throws MJSException {
                return taskImpl.getInputData();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getInputData(outputStream, n);
            }
        };
    }

    @Override
    public LargeData[] getMLFunction(DataStore dataStore, Uuid[] uuidArray, CredentialProviderLocal credentialProviderLocal) throws RemoteException, MJSException {
        DataStoreBackedDataSender<TaskImpl> dataStoreBackedDataSender = new DataStoreBackedDataSender<TaskImpl>(dataStore, this.fMinTransferUsingDataStore);
        List<TaskImpl> list = this.readTasks(uuidArray);
        return dataStoreBackedDataSender.transferData(list, this.createMLFunctionAccessor(credentialProviderLocal));
    }

    private DataAccessor<TaskImpl> createMLFunctionAccessor(final CredentialProviderLocal credentialProviderLocal) {
        return new DataAccessor<TaskImpl>(){

            @Override
            public void doCredentialCheck(TaskImpl taskImpl) throws AuthorisationFailedException, CredentialStorageException {
                TaskAccessImpl.this.checkCredentials(taskImpl, credentialProviderLocal);
            }

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getMLFunctionSize();
            }

            @Override
            public byte[] getDataDirect(TaskImpl taskImpl) throws MJSException {
                return taskImpl.getMLFunction();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getMLFunction(outputStream, n);
            }
        };
    }

    @Override
    public LargeData[] getOutputData(DataStore dataStore, Uuid[] uuidArray, CredentialProviderLocal credentialProviderLocal) throws RemoteException, MJSException {
        DataStoreBackedDataSender<TaskImpl> dataStoreBackedDataSender = new DataStoreBackedDataSender<TaskImpl>(dataStore, this.fMinTransferUsingDataStore);
        List<TaskImpl> list = this.readTasks(uuidArray);
        return dataStoreBackedDataSender.transferData(list, this.createOutputDataAccessor(credentialProviderLocal));
    }

    private DataAccessor<TaskImpl> createOutputDataAccessor(final CredentialProviderLocal credentialProviderLocal) {
        return new DataAccessor<TaskImpl>(){

            @Override
            public void doCredentialCheck(TaskImpl taskImpl) throws AuthorisationFailedException, CredentialStorageException {
                TaskAccessImpl.this.checkCredentials(taskImpl, credentialProviderLocal);
            }

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getOutputDataSize();
            }

            @Override
            public byte[] getDataDirect(TaskImpl taskImpl) throws MJSException {
                return taskImpl.getOutputData();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getOutputData(outputStream, n);
            }
        };
    }

    @Override
    public void setAutoAttachedFileList(Uuid[] uuidArray, final String[][] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Task)workUnit).setAutoAttachedFileList(stringArray[n]);
            }
        });
    }

    @Override
    public void setCaptureCommandWindowOutput(Uuid[] uuidArray, final boolean[] blArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Task)workUnit).setCaptureCommandWindowOutput(blArray[n]);
            }
        });
    }

    @Override
    public void setInputData(Uuid[] uuidArray, final TransferableData[] transferableDataArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((TaskImpl)workUnit).setInputData(transferableDataArray[n]);
            }
        });
    }

    @Override
    public void setLogLevel(Uuid[] uuidArray, final int[] nArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Task)workUnit).setLogLevel(nArray[n]);
            }
        });
    }

    @Override
    public void setMLFunctionName(Uuid[] uuidArray, final String[] stringArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Task)workUnit).setMLFunctionName(stringArray[n]);
            }
        });
    }

    @Override
    public void setMLFunction(Uuid[] uuidArray, final TransferableData[] transferableDataArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((TaskImpl)workUnit).setMLFunction(transferableDataArray[n]);
            }
        });
    }

    @Override
    public void setMaximumNumberOfRetries(Uuid[] uuidArray, final int[] nArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Task)workUnit).setMaximumNumberOfRetries(nArray[n]);
            }
        });
    }

    @Override
    public void setNumOutArgs(Uuid[] uuidArray, final int[] nArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                ((Task)workUnit).setNumOutArgs(nArray[n]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitResult(Uuid[] uuidArray, final TransferableData[] transferableDataArray, final byte[][] byArray, final String[] stringArray, final String[] stringArray2, final TransferableData[] transferableDataArray2, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        this.fMaxConcurrentSubmissions.acquireUninterruptibly();
        try {
            this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

                @Override
                public void invoke(WorkUnit workUnit, int n) throws MJSException {
                    TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                    ((Task)workUnit).submitResult(transferableDataArray[n], byArray[n], stringArray[n], stringArray2[n], transferableDataArray2[n]);
                }
            });
        }
        finally {
            this.fMaxConcurrentSubmissions.release();
        }
    }

    @Override
    public WorkUnitInfo[] getWorkUnitInfoSmallItems(final Uuid[] uuidArray) throws MJSException {
        return (WorkUnitInfo[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            WorkUnitInfo[] iGetWorkUnitInfo;
            {
                super(uuidArray3);
                this.iGetWorkUnitInfo = new TaskInfo[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.iGetWorkUnitInfo[n] = workUnit.getWorkUnitInfo();
            }

            @Override
            protected Object getReturnValue() {
                return this.iGetWorkUnitInfo;
            }
        });
    }

    @Override
    public WorkUnitInfo[] getWorkUnitInfo(DataStore dataStore, final Uuid[] uuidArray, CredentialProviderLocal credentialProviderLocal) throws RemoteException, MJSException {
        WorkUnitInfo[] workUnitInfoArray = (TaskInfo[])this.accessInvocation(new DistcompAccessImpl.AccessInvocationSmallReturn(uuidArray){
            WorkUnitInfo[] itaskInfos;
            {
                super(uuidArray3);
                this.itaskInfos = new TaskInfo[uuidArray.length];
            }

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                this.itaskInfos[n] = workUnit.getWorkUnitInfo();
            }

            @Override
            protected Object getReturnValue() {
                return this.itaskInfos;
            }
        });
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.createOutputDataAccessor(credentialProviderLocal));
        arrayList.add(this.createInputDataAccessor(credentialProviderLocal));
        arrayList.add(this.createCommandWindowOutputAccessor(credentialProviderLocal));
        arrayList.add(this.createMLFunctionAccessor(credentialProviderLocal));
        arrayList.add(this.createLogOutputAccessor());
        DataStoreBackedDataSender<TaskImpl> dataStoreBackedDataSender = new DataStoreBackedDataSender<TaskImpl>(dataStore, this.fMinTransferUsingDataStore);
        List<TaskImpl> list = this.readTasks(uuidArray);
        TransferableData[][] transferableDataArray = dataStoreBackedDataSender.transferData(list, arrayList);
        for (int i = 0; i < uuidArray.length; ++i) {
            ((TaskInfo)workUnitInfoArray[i]).setOutputData(transferableDataArray[i][0]);
            ((TaskInfo)workUnitInfoArray[i]).setInputData(transferableDataArray[i][1]);
            ((TaskInfo)workUnitInfoArray[i]).setCommandWindowOutput(transferableDataArray[i][2]);
            ((TaskInfo)workUnitInfoArray[i]).setMLFunction(transferableDataArray[i][3]);
            ((TaskInfo)workUnitInfoArray[i]).setLogOutput(transferableDataArray[i][4]);
        }
        return workUnitInfoArray;
    }

    @Override
    public void setWorkUnitInfoSmallItems(Uuid[] uuidArray, WorkUnitInfo[] workUnitInfoArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        final TaskInfo[] taskInfoArray = (TaskInfo[])workUnitInfoArray;
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                workUnit.setWorkUnitInfoSmallItems(taskInfoArray[n]);
            }
        });
    }

    @Override
    public void setWorkUnitInfo(Uuid[] uuidArray, WorkUnitInfo[] workUnitInfoArray, final CredentialProviderLocal credentialProviderLocal) throws MJSException {
        final TaskInfo[] taskInfoArray = (TaskInfo[])workUnitInfoArray;
        this.accessInvocation(new DistcompAccessImpl.AccessInvocationWithoutReturn(uuidArray){

            @Override
            public void invoke(WorkUnit workUnit, int n) throws MJSException {
                TaskAccessImpl.this.checkCredentials(workUnit, credentialProviderLocal);
                workUnit.setWorkUnitInfo(taskInfoArray[n]);
            }
        });
    }

    private List<TaskImpl> readTasks(Uuid[] uuidArray) throws MJSException {
        ArrayList<TaskImpl> arrayList = new ArrayList<TaskImpl>(uuidArray.length);
        for (Uuid uuid : uuidArray) {
            arrayList.add((TaskImpl)this.fStorage.readWorkUnit(uuid));
        }
        return arrayList;
    }

    private static class LocalCallThrewRemoteException
    extends RuntimeException {
        LocalCallThrewRemoteException(RemoteException remoteException) {
            super("Unexpected RemoteException from call to getWorkerProperties.", remoteException);
        }
    }
}

