/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.wsclients.cloudconsole;

import com.mathworks.toolbox.distcomp.wsclients.cloudconsole.CloudConsoleClusterDetails;
import com.mathworks.toolbox.distcomp.wsclients.cloudconsole.MatlabVersionInformation;
import java.util.Date;

public class CloudConsoleClusterInfo {
    private final String fId;
    private final String fSSLCertificate;
    private final String fClusterName;
    private final String fHeadNodeDNSName;
    private final String fPeerLookupUri;
    private final String fClusterState;
    private final MatlabVersionInformation fMatlabReleaseVersion;
    private final int fNumberOfWorkers;
    private final String fJobManagerName;
    private final String fTerminationPolicy;
    private final long fTerminationDuration;
    private final Date fExpiresOn;
    private final boolean fHasGPU;

    public CloudConsoleClusterInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, long l, int n, Date date, boolean bl) {
        this.fId = string;
        this.fSSLCertificate = string2;
        this.fClusterName = string3;
        this.fHeadNodeDNSName = string4;
        this.fPeerLookupUri = string5;
        this.fClusterState = string6;
        this.fExpiresOn = null == date ? null : new Date(date.getTime());
        this.fMatlabReleaseVersion = new MatlabVersionInformation(string7);
        this.fNumberOfWorkers = n;
        this.fJobManagerName = string3;
        this.fTerminationPolicy = string8;
        this.fTerminationDuration = l;
        this.fHasGPU = bl;
    }

    public String getTerminationPolicy() {
        return this.fTerminationPolicy;
    }

    public String getClusterID() {
        return this.fId;
    }

    public String getSSLCertificate() {
        return this.fSSLCertificate;
    }

    public String getClusterName() {
        return this.fClusterName;
    }

    public String getPeerLookupUri() {
        return this.fPeerLookupUri;
    }

    public String getClusterHeadNodeDNSName() {
        return this.fHeadNodeDNSName;
    }

    public String getClusterState() {
        return this.fClusterState;
    }

    public MatlabVersionInformation getMatlabReleaseVersion() {
        return this.fMatlabReleaseVersion;
    }

    public int getNumberOfWorkers() {
        return this.fNumberOfWorkers;
    }

    public String getJobManagerName() {
        return this.fJobManagerName;
    }

    public Date getExpiresOn() {
        Date date = null == this.fExpiresOn ? null : new Date(this.fExpiresOn.getTime());
        return date;
    }

    public long getTerminationDuration() {
        return this.fTerminationDuration;
    }

    public boolean hasGPU() {
        return this.fHasGPU;
    }

    public CloudConsoleClusterDetails getClusterDetails() {
        return new CloudConsoleClusterDetails(this.fClusterName, this.fHeadNodeDNSName, this.fPeerLookupUri, this.fClusterState, this.fMatlabReleaseVersion.getMatlabVersion(), this.fTerminationPolicy, this.fTerminationDuration, this.fNumberOfWorkers, this.fExpiresOn, this.fHasGPU);
    }

    public String toString() {
        return "CloudConsoleClusterInfo{fId='" + this.fId + '\'' + ", fSSLCertificate='" + this.fSSLCertificate + '\'' + ", fClusterName='" + this.fClusterName + '\'' + ", fHeadNodeDNSName='" + this.fHeadNodeDNSName + '\'' + ", fPeerLookupUri='" + this.fPeerLookupUri + '\'' + ", fClusterState='" + this.fClusterState + '\'' + ", fMatlabReleaseVersion=" + this.fMatlabReleaseVersion + ", fNumberOfWorkers=" + this.fNumberOfWorkers + ", fJobManagerName='" + this.fJobManagerName + '\'' + ", fTerminationPolicy='" + this.fTerminationPolicy + '\'' + ", fTerminationDuration=" + this.fTerminationDuration + ", fExpiresOn=" + this.fExpiresOn + ", fHasGPU=" + this.fHasGPU + '}';
    }
}

