/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.wsclients.cloudconsole;

import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.mlwebservices.ws_client_core.DefaultMathWorksWebServiceClientConfigurator;
import com.mathworks.toolbox.distcomp.wsclients.Log;
import com.mathworks.toolbox.distcomp.wsclients.WebServiceException;
import com.mathworks.toolbox.distcomp.wsclients.WebServiceInvoker;
import com.mathworks.toolbox.distcomp.wsclients.cloudconsole.CloudConsoleClusterDetails;
import com.mathworks.toolbox.distcomp.wsclients.cloudconsole.CloudConsoleClusterInfo;
import com.mathworks.toolbox.distcomp.wsclients.cloudconsole.MJSCloudConsoleClient;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.clients.cloudcenter.CloudCenter;
import com.mathworks.webservices.clients.cloudcenter.CloudCenterClient;
import com.mathworks.webservices.clients.cloudcenter.ClusterDetailsRequest;
import com.mathworks.webservices.clients.cloudcenter.ClusterDetailsResponse;
import com.mathworks.webservices.clients.cloudcenter.ClusterInfo;
import com.mathworks.webservices.clients.cloudcenter.ClusterInfoResponse;
import com.mathworks.webservices.clients.cloudcenter.DeleteClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.DeleteClusterResponse;
import com.mathworks.webservices.clients.cloudcenter.DiscoverClustersRequest;
import com.mathworks.webservices.clients.cloudcenter.DiscoverClustersResponse;
import com.mathworks.webservices.clients.cloudcenter.GetMWHostedClusterInfoRequest;
import com.mathworks.webservices.clients.cloudcenter.HeartbeatClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.StartClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.StartClusterResponse;
import com.mathworks.webservices.clients.cloudcenter.StopClusterRequest;
import com.mathworks.webservices.clients.cloudcenter.StopClusterResponse;
import com.mathworks.webservices.clients.cloudcenter.TerminationPolicy;
import com.mathworks.webservices.clients.cloudcenter.UpdateClusterRequest;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.logging.Level;

public class MJSCloudConsoleClientImpl
implements MJSCloudConsoleClient {
    private final CloudCenter fCloudCenterClient;
    private static final String LOCALE = Locale.getDefault().toString();
    private static final String SERVICE_ENDPOINT = WSEndPoints.getCloudConsoleEndPoint();
    private static final String PCT_CLIENT_PREFIX = "MDPCT";
    private static final String PCT_CLIENT_STRING = "MDPCT-" + InstutilResourceKeys.RELEASE.getString(new Object[0]);
    private final String fRelease;
    private static final String MWHC_NAME = "cloud";
    private static final CloudConsoleClusterInfo[] EMPTY_INFO = new CloudConsoleClusterInfo[0];

    public MJSCloudConsoleClientImpl() {
        this(InstutilResourceKeys.RELEASE.getString(new Object[0]));
    }

    public MJSCloudConsoleClientImpl(String string) {
        DefaultMathWorksWebServiceClientConfigurator defaultMathWorksWebServiceClientConfigurator = new DefaultMathWorksWebServiceClientConfigurator(SERVICE_ENDPOINT);
        CloudCenterClient cloudCenterClient = new CloudCenterClient(SERVICE_ENDPOINT);
        defaultMathWorksWebServiceClientConfigurator.configureClient((MathWorksWebServiceClient)cloudCenterClient);
        this.fCloudCenterClient = cloudCenterClient;
        this.fRelease = string;
    }

    public MJSCloudConsoleClientImpl(String string, CloudCenter cloudCenter) {
        this.fCloudCenterClient = cloudCenter;
        this.fRelease = string;
    }

    @Override
    public CloudConsoleClusterInfo[] discoverMyClusters(String string) throws WebServiceException {
        DiscoverClustersRequest discoverClustersRequest = new DiscoverClustersRequest();
        discoverClustersRequest.setToken(string);
        discoverClustersRequest.setClientString(PCT_CLIENT_STRING);
        discoverClustersRequest.setLocale(LOCALE);
        MJSCloudConsoleClientImpl.logDiscoverClustersRequest(discoverClustersRequest);
        DiscoverClustersResponse discoverClustersResponse = this.makeDiscoverClustersCallToCloudConsole(discoverClustersRequest);
        Log.LOGGER.log(DistcompLevel.FOUR, "discoverClusters request succeeded.");
        if (discoverClustersResponse != null) {
            CloudConsoleClusterInfo[] cloudConsoleClusterInfoArray = new CloudConsoleClusterInfo[discoverClustersResponse.getClusterList().size()];
            int n = 0;
            for (ClusterInfo clusterInfo : discoverClustersResponse.getClusterList()) {
                cloudConsoleClusterInfoArray[n++] = new CloudConsoleClusterInfo(clusterInfo.getId(), clusterInfo.getSSLCertificate(), clusterInfo.getName(), clusterInfo.getHeadNodeDNSName(), clusterInfo.getPeerLookupUri(), clusterInfo.getState(), clusterInfo.getRelease(), MJSCloudConsoleClientImpl.getTerminationPolicyName(clusterInfo.getTerminationPolicy()), MJSCloudConsoleClientImpl.unboxLongWithNull(clusterInfo.getDurationInSeconds(), -1L), MJSCloudConsoleClientImpl.unboxIntegerWithNull(clusterInfo.getWorkerCount(), 0), clusterInfo.getExpiresOn(), MJSCloudConsoleClientImpl.unboxBooleanWithNull(clusterInfo.isUseGPU(), false));
            }
            return cloudConsoleClusterInfoArray;
        }
        return EMPTY_INFO;
    }

    @Override
    public CloudConsoleClusterDetails getClusterDetails(String string, String string2) throws WebServiceException {
        ClusterDetailsRequest clusterDetailsRequest = new ClusterDetailsRequest();
        clusterDetailsRequest.setClusterId(string);
        clusterDetailsRequest.setToken(string2);
        clusterDetailsRequest.setLocale(LOCALE);
        clusterDetailsRequest.setClientString(PCT_CLIENT_STRING);
        MJSCloudConsoleClientImpl.logClusterDetailsRequest(clusterDetailsRequest);
        ClusterDetailsResponse clusterDetailsResponse = this.makeGetClusterDetailsCallToCloudConsole(clusterDetailsRequest);
        CloudConsoleClusterDetails cloudConsoleClusterDetails = new CloudConsoleClusterDetails(clusterDetailsResponse.getName(), clusterDetailsResponse.getHeadNodeDNSName(), clusterDetailsResponse.getPeerLookupUri(), clusterDetailsResponse.getState(), clusterDetailsResponse.getRelease(), MJSCloudConsoleClientImpl.getTerminationPolicyName(clusterDetailsResponse.getTerminationPolicy()), MJSCloudConsoleClientImpl.unboxLongWithNull(clusterDetailsResponse.getDurationInSeconds(), -1L), MJSCloudConsoleClientImpl.unboxIntegerWithNull(clusterDetailsResponse.getWorkerCount(), 0), clusterDetailsResponse.getExpiresOn(), MJSCloudConsoleClientImpl.unboxBooleanWithNull(clusterDetailsResponse.isUseGPU(), false));
        Log.LOGGER.log(DistcompLevel.FOUR, "clusterDetails request succeeded received following info: " + cloudConsoleClusterDetails);
        return cloudConsoleClusterDetails;
    }

    @Override
    public CloudConsoleClusterInfo getMWHostedDetails(String string, boolean bl, String string2, String string3) throws WebServiceException {
        Log.LOGGER.log(Level.FINE, "Getting details of MathWorks hosted cloud.");
        GetMWHostedClusterInfoRequest getMWHostedClusterInfoRequest = new GetMWHostedClusterInfoRequest();
        getMWHostedClusterInfoRequest.setToken(string);
        getMWHostedClusterInfoRequest.setShouldProvision(bl);
        getMWHostedClusterInfoRequest.setQname(string2);
        getMWHostedClusterInfoRequest.setEntitlementId(string3);
        getMWHostedClusterInfoRequest.setRelease(this.fRelease);
        getMWHostedClusterInfoRequest.setClientString(PCT_CLIENT_STRING);
        getMWHostedClusterInfoRequest.setLocale(LOCALE);
        getMWHostedClusterInfoRequest.setName(MWHC_NAME);
        ClusterInfoResponse clusterInfoResponse = this.makeGetMWHostedClusterInfoCallToCloudCenter(getMWHostedClusterInfoRequest);
        ClusterInfo clusterInfo = clusterInfoResponse.getInfo();
        if (clusterInfo.getName() == null) {
            return null;
        }
        CloudConsoleClusterInfo cloudConsoleClusterInfo = new CloudConsoleClusterInfo(clusterInfo.getId(), clusterInfo.getSSLCertificate(), clusterInfo.getName(), clusterInfo.getHeadNodeDNSName(), clusterInfo.getPeerLookupUri(), clusterInfo.getState(), clusterInfo.getRelease(), MJSCloudConsoleClientImpl.getTerminationPolicyName(clusterInfo.getTerminationPolicy()), MJSCloudConsoleClientImpl.unboxLongWithNull(clusterInfo.getDurationInSeconds(), -1L), MJSCloudConsoleClientImpl.unboxIntegerWithNull(clusterInfo.getWorkerCount(), 0), clusterInfo.getExpiresOn(), MJSCloudConsoleClientImpl.unboxBooleanWithNull(clusterInfo.isUseGPU(), false));
        Log.LOGGER.log(Level.FINER, "MathWorks hosted cloud info: " + cloudConsoleClusterInfo);
        return cloudConsoleClusterInfo;
    }

    @Override
    @Deprecated
    public CloudConsoleClusterInfo defineMWHostedCluster(String string, boolean bl, int n, TerminationPolicy terminationPolicy, long l) throws WebServiceException {
        throw new UnsupportedOperationException("defineMWHostedCluster is no longer supported.");
    }

    @Override
    @Deprecated
    public CloudConsoleClusterInfo updateMWHostedCluster(String string, String string2, boolean bl, int n, TerminationPolicy terminationPolicy, long l) throws WebServiceException {
        return this.updateMWHostedCluster(string, string2, n, terminationPolicy, l);
    }

    @Override
    public CloudConsoleClusterInfo updateMWHostedCluster(String string, String string2, int n, TerminationPolicy terminationPolicy, long l) throws WebServiceException {
        Log.LOGGER.log(Level.FINE, "Redefining MWHosted cluster: cloud; Release='" + this.fRelease + "; NumWorkers=" + n + "; client string:" + PCT_CLIENT_STRING + "; TerminationPolicy:" + terminationPolicy + "; Duration:" + l + "; locale:" + LOCALE);
        UpdateClusterRequest updateClusterRequest = new UpdateClusterRequest();
        updateClusterRequest.setClusterId(string);
        updateClusterRequest.setToken(string2);
        updateClusterRequest.setTerminationPolicy(terminationPolicy);
        updateClusterRequest.setTotalNumWorkers(Integer.valueOf(n));
        if (terminationPolicy.equals((Object)TerminationPolicy.FIXED_DURATION)) {
            updateClusterRequest.setDurationInSeconds(Long.valueOf(l));
        }
        updateClusterRequest.setClientString(PCT_CLIENT_STRING);
        updateClusterRequest.setLocale(LOCALE);
        ClusterInfoResponse clusterInfoResponse = this.makeUpdateClusterCallToCloudConsole(updateClusterRequest);
        ClusterInfo clusterInfo = clusterInfoResponse.getInfo();
        CloudConsoleClusterInfo cloudConsoleClusterInfo = new CloudConsoleClusterInfo(clusterInfo.getId(), clusterInfo.getSSLCertificate(), clusterInfo.getName(), clusterInfo.getHeadNodeDNSName(), clusterInfo.getPeerLookupUri(), clusterInfo.getState(), clusterInfo.getRelease(), MJSCloudConsoleClientImpl.getTerminationPolicyName(clusterInfo.getTerminationPolicy()), MJSCloudConsoleClientImpl.unboxLongWithNull(clusterInfo.getDurationInSeconds(), -1L), MJSCloudConsoleClientImpl.unboxIntegerWithNull(clusterInfo.getWorkerCount(), 0), clusterInfo.getExpiresOn(), MJSCloudConsoleClientImpl.unboxBooleanWithNull(clusterInfo.isUseGPU(), false));
        Log.LOGGER.log(Level.FINER, "Update cluster request succeeded, return the following cluster info: " + cloudConsoleClusterInfo);
        return cloudConsoleClusterInfo;
    }

    private static long unboxLongWithNull(Long l, long l2) {
        return null == l ? l2 : l;
    }

    private static int unboxIntegerWithNull(Integer n, int n2) {
        return null == n ? n2 : n;
    }

    private static boolean unboxBooleanWithNull(Boolean bl, boolean bl2) {
        return null == bl ? bl2 : bl;
    }

    private static String getTerminationPolicyName(TerminationPolicy terminationPolicy) {
        return null == terminationPolicy ? "" : terminationPolicy.name();
    }

    @Override
    public void startCluster(String string, String string2, String string3) throws WebServiceException {
        Log.LOGGER.log(Level.FINE, "Starting cluster: " + string + " with entitlement: " + string3 + "; Client string: " + PCT_CLIENT_STRING + "; Locale: " + LOCALE);
        StartClusterRequest startClusterRequest = new StartClusterRequest(string2, string);
        startClusterRequest.setEntitlementId(string3);
        startClusterRequest.setClientString(PCT_CLIENT_STRING);
        startClusterRequest.setLocale(LOCALE);
        this.makeStartClusterCallToCloudCenter(startClusterRequest);
        Log.LOGGER.log(Level.FINER, "Start cluster request succeeded.");
    }

    @Override
    public void stopCluster(String string, String string2) throws WebServiceException {
        Log.LOGGER.log(Level.FINE, "Stopping cluster: " + string + "; Client string: " + PCT_CLIENT_STRING + "; Locale: " + LOCALE);
        StopClusterRequest stopClusterRequest = new StopClusterRequest(string2, string);
        stopClusterRequest.setClientString(PCT_CLIENT_STRING);
        stopClusterRequest.setLocale(LOCALE);
        this.makeStopClusterCallToCloudCenter(stopClusterRequest);
        Log.LOGGER.log(Level.FINER, "Stop cluster request succeeded.");
    }

    @Override
    public CloudConsoleClusterInfo shutdownOnEvent(String string, String string2, TerminationPolicy terminationPolicy) throws WebServiceException {
        assert (terminationPolicy.equals((Object)TerminationPolicy.MATLAB_SESSION_END) || terminationPolicy.equals((Object)TerminationPolicy.NEVER) || terminationPolicy.equals((Object)TerminationPolicy.ON_QUEUE_IDLE));
        Log.LOGGER.log(Level.FINE, "Updating cluster: " + string + "; TerminationPolicy: " + terminationPolicy + "; Client string: " + PCT_CLIENT_STRING + "; Locale: " + LOCALE);
        return this.updateClusterShutdown(string, string2, terminationPolicy, -1L);
    }

    @Override
    public CloudConsoleClusterInfo shutdownAfter(String string, String string2, long l) throws WebServiceException {
        TerminationPolicy terminationPolicy = TerminationPolicy.FIXED_DURATION;
        Log.LOGGER.log(Level.FINE, "Updating cluster: " + string + "; TerminationPolicy: " + terminationPolicy + "; TerminationDuration: " + l + "; Client string: " + PCT_CLIENT_STRING + "; Locale: " + LOCALE);
        return this.updateClusterShutdown(string, string2, terminationPolicy, l);
    }

    private CloudConsoleClusterInfo updateClusterShutdown(String string, String string2, TerminationPolicy terminationPolicy, long l) throws WebServiceException {
        UpdateClusterRequest updateClusterRequest = new UpdateClusterRequest();
        updateClusterRequest.setClusterId(string);
        updateClusterRequest.setToken(string2);
        updateClusterRequest.setTerminationPolicy(terminationPolicy);
        if (terminationPolicy == TerminationPolicy.FIXED_DURATION) {
            updateClusterRequest.setDurationInSeconds(Long.valueOf(l));
        }
        updateClusterRequest.setClientString(PCT_CLIENT_STRING);
        updateClusterRequest.setLocale(LOCALE);
        ClusterInfoResponse clusterInfoResponse = this.makeUpdateClusterCallToCloudConsole(updateClusterRequest);
        ClusterInfo clusterInfo = clusterInfoResponse.getInfo();
        CloudConsoleClusterInfo cloudConsoleClusterInfo = new CloudConsoleClusterInfo(clusterInfo.getId(), clusterInfo.getSSLCertificate(), clusterInfo.getName(), clusterInfo.getHeadNodeDNSName(), clusterInfo.getPeerLookupUri(), clusterInfo.getState(), clusterInfo.getRelease(), MJSCloudConsoleClientImpl.getTerminationPolicyName(clusterInfo.getTerminationPolicy()), MJSCloudConsoleClientImpl.unboxLongWithNull(clusterInfo.getDurationInSeconds(), -1L), MJSCloudConsoleClientImpl.unboxIntegerWithNull(clusterInfo.getWorkerCount(), 0), clusterInfo.getExpiresOn(), MJSCloudConsoleClientImpl.unboxBooleanWithNull(clusterInfo.isUseGPU(), false));
        Log.LOGGER.log(Level.FINER, "Update cluster request succeeded, with the following cluster info: " + cloudConsoleClusterInfo);
        return cloudConsoleClusterInfo;
    }

    @Override
    public void deleteCluster(String string, String string2) throws WebServiceException {
        Log.LOGGER.log(Level.FINE, "Deleting cluster: " + string + "; Client string: " + PCT_CLIENT_STRING + "; Locale: " + LOCALE);
        DeleteClusterRequest deleteClusterRequest = new DeleteClusterRequest(string2, string);
        deleteClusterRequest.setClientString(PCT_CLIENT_STRING);
        deleteClusterRequest.setLocale(LOCALE);
        this.makeDeleteClusterCallToCloudConsole(deleteClusterRequest);
        Log.LOGGER.log(Level.FINER, "Delete cluster request succeeded.");
    }

    @Override
    public void heartbeatCluster(String string, String string2) throws WebServiceException {
        Log.LOGGER.log(Level.FINE, "Heartbeating cluster: " + string + "; Client string: " + PCT_CLIENT_STRING + "; Locale: " + LOCALE);
        HeartbeatClusterRequest heartbeatClusterRequest = new HeartbeatClusterRequest();
        heartbeatClusterRequest.setClientString(PCT_CLIENT_STRING);
        heartbeatClusterRequest.setLocale(LOCALE);
        heartbeatClusterRequest.setClusterId(string);
        heartbeatClusterRequest.setToken(string2);
        this.makeHeartbeatClusterCallToCloudConsole(heartbeatClusterRequest);
    }

    private void makeHeartbeatClusterCallToCloudConsole(final HeartbeatClusterRequest heartbeatClusterRequest) throws WebServiceException {
        WebServiceInvoker<Object> webServiceInvoker = new WebServiceInvoker<Object>();
        webServiceInvoker.invokeAndHandleException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MJSCloudConsoleClientImpl.this.fCloudCenterClient.heartbeatCluster(heartbeatClusterRequest);
                return null;
            }
        });
    }

    private ClusterInfoResponse makeUpdateClusterCallToCloudConsole(final UpdateClusterRequest updateClusterRequest) throws WebServiceException {
        WebServiceInvoker<ClusterInfoResponse> webServiceInvoker = new WebServiceInvoker<ClusterInfoResponse>();
        return webServiceInvoker.invokeAndHandleException(new Callable<ClusterInfoResponse>(){

            @Override
            public ClusterInfoResponse call() throws Exception {
                return MJSCloudConsoleClientImpl.this.fCloudCenterClient.updateCluster(updateClusterRequest);
            }
        });
    }

    private DeleteClusterResponse makeDeleteClusterCallToCloudConsole(final DeleteClusterRequest deleteClusterRequest) throws WebServiceException {
        WebServiceInvoker<DeleteClusterResponse> webServiceInvoker = new WebServiceInvoker<DeleteClusterResponse>();
        return webServiceInvoker.invokeAndHandleException(new Callable<DeleteClusterResponse>(){

            @Override
            public DeleteClusterResponse call() throws Exception {
                return MJSCloudConsoleClientImpl.this.fCloudCenterClient.deleteCluster(deleteClusterRequest);
            }
        });
    }

    private DiscoverClustersResponse makeDiscoverClustersCallToCloudConsole(final DiscoverClustersRequest discoverClustersRequest) throws WebServiceException {
        WebServiceInvoker<DiscoverClustersResponse> webServiceInvoker = new WebServiceInvoker<DiscoverClustersResponse>();
        return webServiceInvoker.invokeAndHandleException(new Callable<DiscoverClustersResponse>(){

            @Override
            public DiscoverClustersResponse call() throws Exception {
                return MJSCloudConsoleClientImpl.this.fCloudCenterClient.discoverMyCloudClusters(discoverClustersRequest);
            }
        });
    }

    private ClusterDetailsResponse makeGetClusterDetailsCallToCloudConsole(final ClusterDetailsRequest clusterDetailsRequest) throws WebServiceException {
        WebServiceInvoker<ClusterDetailsResponse> webServiceInvoker = new WebServiceInvoker<ClusterDetailsResponse>();
        return webServiceInvoker.invokeAndHandleException(new Callable<ClusterDetailsResponse>(){

            @Override
            public ClusterDetailsResponse call() throws Exception {
                return MJSCloudConsoleClientImpl.this.fCloudCenterClient.getClusterDetails(clusterDetailsRequest);
            }
        });
    }

    private ClusterInfoResponse makeGetMWHostedClusterInfoCallToCloudCenter(final GetMWHostedClusterInfoRequest getMWHostedClusterInfoRequest) throws WebServiceException {
        WebServiceInvoker<ClusterInfoResponse> webServiceInvoker = new WebServiceInvoker<ClusterInfoResponse>();
        return webServiceInvoker.invokeAndHandleException(new Callable<ClusterInfoResponse>(){

            @Override
            public ClusterInfoResponse call() throws Exception {
                return MJSCloudConsoleClientImpl.this.fCloudCenterClient.getMWHostedClusterInfo(getMWHostedClusterInfoRequest);
            }
        });
    }

    private StartClusterResponse makeStartClusterCallToCloudCenter(final StartClusterRequest startClusterRequest) throws WebServiceException {
        WebServiceInvoker<StartClusterResponse> webServiceInvoker = new WebServiceInvoker<StartClusterResponse>();
        return webServiceInvoker.invokeAndHandleException(new Callable<StartClusterResponse>(){

            @Override
            public StartClusterResponse call() throws Exception {
                return MJSCloudConsoleClientImpl.this.fCloudCenterClient.startCluster(startClusterRequest);
            }
        });
    }

    private StopClusterResponse makeStopClusterCallToCloudCenter(final StopClusterRequest stopClusterRequest) throws WebServiceException {
        WebServiceInvoker<StopClusterResponse> webServiceInvoker = new WebServiceInvoker<StopClusterResponse>();
        return webServiceInvoker.invokeAndHandleException(new Callable<StopClusterResponse>(){

            @Override
            public StopClusterResponse call() throws Exception {
                return MJSCloudConsoleClientImpl.this.fCloudCenterClient.stopCluster(stopClusterRequest);
            }
        });
    }

    private static void logClusterDetailsRequest(ClusterDetailsRequest clusterDetailsRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Making a clusterDetails call to the CloudConsoleClient with: \n");
        stringBuilder.append("clusterID = ").append(clusterDetailsRequest.getClusterId()).append(", ");
        stringBuilder.append("token = ").append(clusterDetailsRequest.getToken()).append(", ");
        stringBuilder.append("locale = ").append(clusterDetailsRequest.getLocale()).append(", ");
        stringBuilder.append("clientString = ").append(clusterDetailsRequest.getClientString()).append(".");
        Log.LOGGER.log(DistcompLevel.FOUR, stringBuilder.toString());
    }

    private static void logDiscoverClustersRequest(DiscoverClustersRequest discoverClustersRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Making a discoverClusters call to the CloudConsoleClient with: \n");
        stringBuilder.append("token = ").append(discoverClustersRequest.getToken()).append(", ");
        stringBuilder.append("locale = ").append(discoverClustersRequest.getLocale()).append(", ");
        stringBuilder.append("clientString = ").append(discoverClustersRequest.getClientString()).append(".");
        Log.LOGGER.log(DistcompLevel.FOUR, stringBuilder.toString());
    }
}

