/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefsComponent;
import com.mathworks.services.OldFontPrefs;
import com.mathworks.services.Prefs;
import com.mathworks.services.PrefsAWT;
import com.mathworks.util.PlatformInfo;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.lang.Validate;

public final class FontPrefs {
    private static final ResourceBundle BUNDLE;
    private static final String FONT_PREF_KEY_PREFIX = "Desktop.Font.";
    public static final String HTML_FONT_COMPONENT_NAME;
    public static final Font DEFAULT_CODE_FONT;
    public static final Font DEFAULT_TEXT_FONT;
    public static final Font DEFAULT_CUSTOM_FONT;
    private static final String USE_SYSTEM_FONT_PREF_KEY = "GeneralTextUseSystemFont";
    private static final List<FontItem> sComponents;
    private static final Map<FontType, List<FontListener>> sFontListeners;

    private FontPrefs() {
    }

    public static void registerComponents() {
        sComponents.clear();
        FontPrefs.registerComponent(new HtmlFontPrefs());
        FontPrefs.registerComponent("com.mathworks.mde.cmdwin.CmdWinPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.cmdhist.CmdHistoryPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.editor.EditorFontPrefs");
        FontPrefs.registerComponent("com.mathworks.mlwidgets.explorer.model.ExplorerPrefs$ExplorerFontPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.workspace.WorkspaceFontPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.array.ArrayEditorFontPrefs");
        FontPrefs.registerComponent("com.mathworks.mde.functionbrowser.FunctionBrowserFontPrefs");
    }

    public static void addFontListener(String string, FontListener fontListener) {
        boolean bl = false;
        for (FontItem fontItem : sComponents) {
            if (!fontItem.getComponentName().equals(string)) continue;
            fontItem.addFontListener(fontListener);
            bl = true;
            break;
        }
        if (!bl) {
            System.out.println("FontPrefs: unable to find font for component " + string);
        }
    }

    public static void removeFontListener(String string, FontListener fontListener) {
        for (FontItem fontItem : sComponents) {
            if (!fontItem.getComponentName().equals(string)) continue;
            fontItem.removeFontListener(fontListener);
            break;
        }
    }

    public static Font getFontForComponent(String string) {
        Font font = DEFAULT_TEXT_FONT;
        for (FontItem fontItem : sComponents) {
            if (!fontItem.getComponentName().equals(string)) continue;
            if (fontItem.getFontType() == FontType.TEXT) {
                font = FontPrefs.getTextFont();
                break;
            }
            if (fontItem.getFontType() == FontType.CODE) {
                font = FontPrefs.getCodeFont();
                break;
            }
            font = fontItem.getCustomFont();
            break;
        }
        assert (font != null) : "Should not return null";
        return font;
    }

    public static String getComponentsUsingDesktopFont(FontType fontType) {
        StringBuilder stringBuilder = new StringBuilder();
        for (FontItem fontItem : sComponents) {
            if (fontItem.getFontType() != fontType) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(fontItem.getComponentName());
        }
        return stringBuilder.toString();
    }

    private static void registerComponent(String string) {
        try {
            Object obj = Class.forName(string).newInstance();
            FontPrefsComponent fontPrefsComponent = (FontPrefsComponent)obj;
            FontPrefs.registerComponent(fontPrefsComponent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void registerComponent(FontPrefsComponent fontPrefsComponent) {
        String string = FONT_PREF_KEY_PREFIX + fontPrefsComponent.getFontPrefsTagName();
        FontType fontType = FontType.lookup(Prefs.getStringPref(string, fontPrefsComponent.getDefaultFont().getName()));
        Font font = PrefsAWT.getFontPref(string + ".Custom", DEFAULT_CUSTOM_FONT);
        sComponents.add(new FontItem(fontPrefsComponent.getDisplayName(), string, fontType, font));
    }

    public static List<FontItem> getRegisteredComponents() {
        return Collections.unmodifiableList(sComponents);
    }

    public static void saveCustomFonts(Vector<FontItem> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Font font;
            Font font2;
            FontType fontType;
            FontItem fontItem = vector.elementAt(i);
            FontItem fontItem2 = sComponents.get(i);
            FontType fontType2 = fontItem2.getFontType();
            if (!fontType2.equals((Object)(fontType = fontItem.getFontType()))) {
                fontItem2.setFontType(fontType);
                if (fontType == FontType.CODE) {
                    FontPrefs.notifyComponentListeners(fontItem2, FontPrefs.getCodeFont());
                } else if (fontType == FontType.TEXT) {
                    FontPrefs.notifyComponentListeners(fontItem2, FontPrefs.getTextFont());
                } else {
                    FontPrefs.notifyComponentListeners(fontItem2, fontItem.getCustomFont());
                }
                Prefs.setStringPref(fontItem2.getPrefsTag(), fontType.getName());
            }
            if (fontType != FontType.CUSTOM || (font2 = fontItem2.getCustomFont()).equals(font = fontItem.getCustomFont())) continue;
            fontItem2.setCustomFont(fontItem.getCustomFont());
            FontPrefs.notifyComponentListeners(fontItem2, fontItem.getCustomFont());
            PrefsAWT.setFontPref(fontItem.getPrefsTag() + ".Custom", fontItem.getCustomFont());
        }
    }

    private static void notifyComponentListeners(FontItem fontItem, Font font) {
        for (FontListener fontListener : fontItem.getFontListeners()) {
            FontPrefs.notifyListener(fontListener, font);
        }
    }

    public static Font getCodeFont() {
        String string = FontType.CODE.getKey();
        Font font = PrefsAWT.getFontPref(string, DEFAULT_CODE_FONT);
        if (!FontUtils.validateFont((Font)font)) {
            font = DEFAULT_CODE_FONT;
        }
        return font;
    }

    public static Font getTextFont() {
        String string = FontType.TEXT.getKey();
        Font font = PrefsAWT.getFontPref(string, DEFAULT_TEXT_FONT);
        if (!FontUtils.validateFont((Font)font)) {
            font = DEFAULT_TEXT_FONT;
        }
        return FontPrefs.isTextFontSystemFont() ? FontUtils.getSystemUIFont() : font;
    }

    public static Font getHtmlProportionalFont() {
        return FontPrefs.getFontForComponent(HTML_FONT_COMPONENT_NAME);
    }

    public static boolean isTextFontSystemFont() {
        return Prefs.getBooleanPref(USE_SYSTEM_FONT_PREF_KEY, true);
    }

    public static void setTextUseSystemFont(boolean bl) {
        Prefs.setBooleanPref(USE_SYSTEM_FONT_PREF_KEY, bl);
    }

    public static void setCodeFont(Font font) {
        FontType.CODE.setCurrentFont(font);
    }

    public static void setTextFont(Font font) {
        FontType.TEXT.setCurrentFont(font);
    }

    public static void addTextFontListener(FontListener fontListener) {
        FontPrefs.addFontListener(FontType.TEXT, fontListener);
    }

    public static void addCodeFontListener(FontListener fontListener) {
        FontPrefs.addFontListener(FontType.CODE, fontListener);
    }

    public static void removeTextFontListener(FontListener fontListener) {
        FontPrefs.removeFontListener(FontType.TEXT, fontListener);
    }

    public static void removeCodeFontListener(FontListener fontListener) {
        FontPrefs.removeFontListener(FontType.CODE, fontListener);
    }

    private static void addFontListener(FontType fontType, FontListener fontListener) {
        Validate.notNull((Object)fontListener, (String)"'listener' cannot be null");
        FontPrefs.getListeners(fontType).add(fontListener);
    }

    private static void removeFontListener(FontType fontType, FontListener fontListener) {
        Validate.notNull((Object)fontListener, (String)"'listener' cannot be null");
        FontPrefs.getListeners(fontType).remove(fontListener);
    }

    private static List<FontListener> getListeners(FontType fontType) {
        List<FontListener> list = sFontListeners.get((Object)fontType);
        if (list == null) {
            list = new Vector<FontListener>();
            sFontListeners.put(fontType, list);
        }
        return list;
    }

    private static void notifyListeners(final FontType fontType, final Font font) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Object object : sComponents) {
                    if (((FontItem)object).getFontType() != fontType) continue;
                    for (FontListener fontListener : ((FontItem)object).getFontListeners()) {
                        fontListener.fontChanged(font);
                    }
                }
                for (Object object : FontPrefs.getListeners(fontType)) {
                    object.fontChanged(font);
                }
            }
        });
    }

    private static void notifyListener(final FontListener fontListener, final Font font) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                fontListener.fontChanged(font);
            }
        });
    }

    static {
        OldFontPrefs.transferOldKeysToNewKeys();
        BUNDLE = ResourceBundle.getBundle("com.mathworks.services.resources.RES_Services");
        HTML_FONT_COMPONENT_NAME = BUNDLE.getString("Fonts.HtmlProportionalTextName");
        DEFAULT_CODE_FONT = PlatformInfo.isWindows() ? (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.ansiFixed.font") : new Font("Monospaced", 0, 13);
        DEFAULT_TEXT_FONT = FontUtils.getSystemUIFont();
        DEFAULT_CUSTOM_FONT = FontUtils.getDefaultReadingFont();
        sComponents = new Vector<FontItem>();
        sFontListeners = new EnumMap<FontType, List<FontListener>>(FontType.class);
        FontPrefs.registerComponents();
    }

    private static class HtmlFontPrefs
    implements FontPrefsComponent {
        private HtmlFontPrefs() {
        }

        @Override
        public String getDisplayName() {
            return HTML_FONT_COMPONENT_NAME;
        }

        @Override
        public String getFontPrefsTagName() {
            return "HTML";
        }

        @Override
        public FontType getDefaultFont() {
            return FontType.CUSTOM;
        }
    }

    public static class FontItem {
        private final String fComponentName;
        private final String fPrefsTag;
        private FontType fFontType;
        private Font fCustomFont;
        private final List<FontListener> fListener = new Vector<FontListener>();

        public FontItem(String string, String string2, FontType fontType, Font font) {
            Validate.notNull((Object)string, (String)"'componentName' cannot be null");
            Validate.notNull((Object)string2, (String)"'prefsTag' cannot be null");
            Validate.notNull((Object)((Object)fontType), (String)"'fontType' cannot be null");
            Validate.notNull((Object)font, (String)"'customFont' cannot be null");
            this.fComponentName = string;
            this.fPrefsTag = string2;
            this.fFontType = fontType;
            this.fCustomFont = font;
        }

        public String getComponentName() {
            return this.fComponentName;
        }

        public String getPrefsTag() {
            return this.fPrefsTag;
        }

        public FontType getFontType() {
            return this.fFontType;
        }

        public Font getCustomFont() {
            return this.fCustomFont;
        }

        public void setFontType(FontType fontType) {
            this.fFontType = fontType;
        }

        public void setCustomFont(Font font) {
            this.fCustomFont = font;
        }

        public List<FontListener> getFontListeners() {
            return Collections.unmodifiableList(this.fListener);
        }

        public void addFontListener(FontListener fontListener) {
            this.fListener.add(fontListener);
        }

        public void removeFontListener(FontListener fontListener) {
            this.fListener.remove(fontListener);
        }

        public String toString() {
            return this.fComponentName;
        }
    }

    public static final class FontType
    extends Enum<FontType> {
        public static final /* enum */ FontType CODE = new FontType("CodeFont", "Code");
        public static final /* enum */ FontType TEXT = new FontType("TextFont", "Text");
        public static final /* enum */ FontType CUSTOM = new FontType("CustomFont", null);
        private String fPrefValue;
        private String fPrefKey;
        private static final /* synthetic */ FontType[] $VALUES;

        public static FontType[] values() {
            return (FontType[])$VALUES.clone();
        }

        public static FontType valueOf(String string) {
            return Enum.valueOf(FontType.class, string);
        }

        private FontType(String string2, String string3) {
            this.fPrefValue = string2;
            this.fPrefKey = string3 == null ? null : FontPrefs.FONT_PREF_KEY_PREFIX + string3;
        }

        private String getName() {
            return this.fPrefValue;
        }

        private String getKey() {
            return this.fPrefKey;
        }

        private static FontType lookup(String string) {
            for (FontType fontType : FontType.values()) {
                if (!fontType.getName().equals(string)) continue;
                return fontType;
            }
            assert (false) : "No font type named " + string + "; returning TEXT";
            return TEXT;
        }

        private void setCurrentFont(Font font) {
            Validate.notNull((Object)font, (String)"'newFont' cannot be null");
            assert (this != CUSTOM) : "CUSTOM does not have a single font preference";
            Prefs.setFontPref(this.fPrefKey, font);
            FontPrefs.notifyListeners(this, font);
        }

        static {
            $VALUES = new FontType[]{CODE, TEXT, CUSTOM};
        }
    }
}

