/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.util.resourcemanagement;

import com.mathworks.toolbox.parallel.util.resourcemanagement.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DisposableObjectWrapper<T extends Disposable>
implements Disposable {
    private final T fResource;
    private final AtomicInteger fSharedReferenceCounter;
    private final AtomicBoolean fThisWrapperDisposed = new AtomicBoolean(false);

    public DisposableObjectWrapper(T t) {
        this.fResource = t;
        this.fSharedReferenceCounter = new AtomicInteger(1);
    }

    private DisposableObjectWrapper(T t, AtomicInteger atomicInteger) {
        this.fResource = t;
        this.fSharedReferenceCounter = atomicInteger;
    }

    public DisposableObjectWrapper<T> duplicate() {
        int n = this.fSharedReferenceCounter.incrementAndGet();
        assert (n > 1);
        if (n <= 1) {
            throw new IllegalStateException();
        }
        return new DisposableObjectWrapper<T>(this.fResource, this.fSharedReferenceCounter);
    }

    public T getResource() {
        if (this.fThisWrapperDisposed.get()) {
            throw new IllegalStateException();
        }
        assert (this.fSharedReferenceCounter.get() >= 0);
        return this.fResource;
    }

    @Override
    public boolean isDisposed() {
        return this.fThisWrapperDisposed.get();
    }

    @Override
    public void dispose() {
        int n;
        boolean bl = this.fThisWrapperDisposed.compareAndSet(false, true);
        assert (bl);
        if (bl && (n = this.fSharedReferenceCounter.decrementAndGet()) == 0) {
            this.fResource.dispose();
        }
    }

    public String toString() {
        return "DisposableObjectWrapper{fResource=" + this.fResource + ", fSharedReferenceCounter=" + this.fSharedReferenceCounter + '}';
    }
}

