/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQDataSource;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.xqj.SaxonXQConnection;

public class SaxonXQDataSource
implements XQDataSource {
    private Configuration config;
    private PrintWriter logger;

    public SaxonXQDataSource() {
        try {
            this.config = Configuration.makeSchemaAwareConfiguration(null, null);
        }
        catch (RuntimeException err) {
            this.config = new Configuration();
        }
    }

    public SaxonXQDataSource(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XQConnection getConnection() throws XQException {
        return new SaxonXQConnection(this);
    }

    public XQConnection getConnection(Connection con) throws XQException {
        throw new XQException("Saxon cannot connect to a SQL data source");
    }

    public XQConnection getConnection(String username, String password) throws XQException {
        return this.getConnection();
    }

    public int getLoginTimeout() {
        return 0;
    }

    public PrintWriter getLogWriter() {
        return this.logger;
    }

    public String getProperty(String name) throws XQException {
        throw new XQException("Property " + name + " is not recognized");
    }

    public String[] getSupportedPropertyNames() {
        return new String[0];
    }

    public void setLoginTimeout(int seconds) throws XQException {
    }

    public void setLogWriter(PrintWriter out) throws XQException {
        this.logger = out;
    }

    public void setProperties(Properties props) throws XQException {
        if (!props.isEmpty()) {
            throw new XQException("Property " + props.keys().nextElement() + " is not recognized");
        }
    }

    public void setProperty(String name, String value) throws XQException {
        throw new XQException("Property " + name + " is not recognized");
    }
}

