/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.publishparser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.StringWriter;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class PublishParserUtils {
    private static final Pattern COPYRIGHT_PATTERN = Pattern.compile("%[\\s\\t]*(Copyright\\s*[\\d-]+[^\\n]*The MathWorks, Inc\\.)");
    private static final String DISPLAY_END_OF_DEMO_REGEX = "[\\s\\t]*displayEndOfDemoMessage\\(mfilename\\)";

    private PublishParserUtils() {
    }

    static String readFile(File file) throws FileNotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        Scanner scanner = new Scanner(file).useDelimiter("\\Z");
        while (scanner.hasNext()) {
            stringBuilder.append(scanner.next());
        }
        return stringBuilder.toString();
    }

    public static String preProcessForRichScriptConversion(String string) {
        string = string.replaceAll("\\r\\n", "\n");
        string = string.replaceAll("\\r", "\n");
        string = string.replaceAll(DISPLAY_END_OF_DEMO_REGEX, "");
        Matcher matcher = COPYRIGHT_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
            matcher.appendTail(stringBuffer);
            stringBuffer.append("\n%% \n% _").append(matcher.group(1)).append("_\n");
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String getDocumentAsString(Document document) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new StringWriter());
        transformer.transform(dOMSource, streamResult);
        return streamResult.getWriter().toString();
    }

    static String findUrl(String string) {
        String string2 = "(?<=^|\\s|\\()((http|file|ftp|mailto):[^\\s\\<\\>\\|\\<\\{\\}\\|\\\\\\^\\[\\]\\`]+)";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            int n = 0;
            int n2 = matcher.end() - 1;
            while (string.charAt(n2) == '.' || string.charAt(n2) == ',' || string.charAt(n2) == '?' || string.charAt(n2) == ':' || string.charAt(n2) == ';' || string.charAt(n2) == '!' || string.charAt(n2) == '\"' || string.charAt(n2) == ')' || string.charAt(n2) == '\'') {
                --n2;
                ++n;
            }
            matcher.appendReplacement(stringBuffer, "<" + string.substring(matcher.start(), matcher.end() - n) + ">" + string.substring(matcher.end() - n, matcher.end()));
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        string2 = "(?<=^|\\s|\\()([a-zA-Z0-9\\_\\-\\.]+\\@[a-zA-Z0-9\\_\\-\\.]+\\.[a-zA-Z]+)";
        pattern = Pattern.compile(string2);
        matcher = pattern.matcher(string);
        stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "<mailto:" + matcher.group() + " " + matcher.group() + ">");
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        string2 = "(?<=(?:\\w|\\+\\+))(\\(TM\\))(?=\\W|$)";
        pattern = Pattern.compile(string2);
        matcher = pattern.matcher(string);
        stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "\u2122");
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        string2 = "(?<=(?:\\w|\\+\\+))(\\(R\\))(?=$|\\W)";
        pattern = Pattern.compile(string2);
        matcher = pattern.matcher(string);
        stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "\u00ae");
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        string = string.replace("\n", " ");
        return string;
    }
}

