/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.mapreduce;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public final class KeyValueMessage {
    private final Type fType;
    private final ByteBuffer fContent;
    private final ByteBuffer fRawKeyValueMessage;
    private static final int SIZE_OF_HEADER = 4;

    public static KeyValueMessage createCloseMessage() {
        return new KeyValueMessage(Type.CLOSE, ByteBuffer.allocate(0));
    }

    public static KeyValueMessage createKeyMessage(ByteBuffer byteBuffer) {
        return new KeyValueMessage(Type.KEY, byteBuffer);
    }

    public static KeyValueMessage createValueMessage(ByteBuffer byteBuffer) {
        return new KeyValueMessage(Type.VALUE, byteBuffer);
    }

    public boolean isCloseMessage() {
        return this.fType == Type.CLOSE;
    }

    public boolean isKeyMessage() {
        return this.fType == Type.KEY;
    }

    public boolean isValueMessage() {
        return this.fType == Type.VALUE;
    }

    public Type getType() {
        return this.fType;
    }

    public ByteBuffer getContent() {
        return this.fContent.duplicate();
    }

    ByteBuffer toByteBuffer() {
        return this.fRawKeyValueMessage.duplicate();
    }

    public static KeyValueMessage readByteBuffer(ByteBuffer byteBuffer) {
        return new KeyValueMessage(byteBuffer);
    }

    public KeyValueMessage(ByteBuffer byteBuffer) {
        assert (byteBuffer != null);
        this.fRawKeyValueMessage = byteBuffer.slice();
        this.fType = Type.forValue(this.fRawKeyValueMessage.getInt());
        this.fContent = this.fRawKeyValueMessage.slice();
        this.fRawKeyValueMessage.rewind();
    }

    public KeyValueMessage(Type type, ByteBuffer byteBuffer) {
        assert (type != null);
        assert (byteBuffer != null);
        this.fType = type;
        byteBuffer = byteBuffer.duplicate();
        this.fRawKeyValueMessage = ByteBuffer.allocate(byteBuffer.remaining() + 4);
        this.fRawKeyValueMessage.putInt(type.getValue()).put(byteBuffer);
        this.fRawKeyValueMessage.position(4);
        this.fContent = this.fRawKeyValueMessage.slice();
        this.fRawKeyValueMessage.rewind();
    }

    private static byte[] convertToByteArray(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static enum Type {
        CLOSE(0),
        KEY(1),
        VALUE(2);

        private final int fValue;
        private static final Map<Integer, Type> lookup;

        private Type(int n2) {
            this.fValue = n2;
        }

        private int getValue() {
            return this.fValue;
        }

        private static Type forValue(int n) {
            if (!lookup.containsKey(n)) {
                throw new IllegalArgumentException();
            }
            return lookup.get(n);
        }

        static {
            lookup = new HashMap<Integer, Type>();
            for (Type type : Type.values()) {
                lookup.put(type.getValue(), type);
            }
        }
    }
}

