/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.inference;

import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.DistributionFactory;
import org.apache.commons.math.distribution.TDistribution;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.inference.TTest;

public class TTestImpl
implements TTest {
    private DistributionFactory distributionFactory = null;

    public double pairedT(double[] sample1, double[] sample2) throws IllegalArgumentException, MathException {
        if (sample1 == null || sample2 == null || Math.min(sample1.length, sample2.length) < 2) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        double meanDifference = StatUtils.meanDifference(sample1, sample2);
        return this.t(meanDifference, 0.0, StatUtils.varianceDifference(sample1, sample2, meanDifference), sample1.length);
    }

    public double pairedTTest(double[] sample1, double[] sample2) throws IllegalArgumentException, MathException {
        double meanDifference = StatUtils.meanDifference(sample1, sample2);
        return this.tTest(meanDifference, 0.0, StatUtils.varianceDifference(sample1, sample2, meanDifference), sample1.length);
    }

    public boolean pairedTTest(double[] sample1, double[] sample2, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.pairedTTest(sample1, sample2) < alpha;
    }

    public double t(double mu, double[] observed) throws IllegalArgumentException {
        if (observed == null || observed.length < 2) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.t(StatUtils.mean(observed), mu, StatUtils.variance(observed), observed.length);
    }

    public double t(double mu, StatisticalSummary sampleStats) throws IllegalArgumentException {
        if (sampleStats == null || sampleStats.getN() < 2L) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.t(sampleStats.getMean(), mu, sampleStats.getVariance(), sampleStats.getN());
    }

    public double homoscedasticT(double[] sample1, double[] sample2) throws IllegalArgumentException {
        if (sample1 == null || sample2 == null || Math.min(sample1.length, sample2.length) < 2) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.homoscedasticT(StatUtils.mean(sample1), StatUtils.mean(sample2), StatUtils.variance(sample1), StatUtils.variance(sample2), sample1.length, sample2.length);
    }

    public double t(double[] sample1, double[] sample2) throws IllegalArgumentException {
        if (sample1 == null || sample2 == null || Math.min(sample1.length, sample2.length) < 2) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.t(StatUtils.mean(sample1), StatUtils.mean(sample2), StatUtils.variance(sample1), StatUtils.variance(sample2), sample1.length, sample2.length);
    }

    public double t(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws IllegalArgumentException {
        if (sampleStats1 == null || sampleStats2 == null || Math.min(sampleStats1.getN(), sampleStats2.getN()) < 2L) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.t(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), sampleStats1.getN(), sampleStats2.getN());
    }

    public double homoscedasticT(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws IllegalArgumentException {
        if (sampleStats1 == null || sampleStats2 == null || Math.min(sampleStats1.getN(), sampleStats2.getN()) < 2L) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.homoscedasticT(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), sampleStats1.getN(), sampleStats2.getN());
    }

    public double tTest(double mu, double[] sample) throws IllegalArgumentException, MathException {
        if (sample == null || sample.length < 2) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.tTest(StatUtils.mean(sample), mu, StatUtils.variance(sample), sample.length);
    }

    public boolean tTest(double mu, double[] sample, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.tTest(mu, sample) < alpha;
    }

    public double tTest(double mu, StatisticalSummary sampleStats) throws IllegalArgumentException, MathException {
        if (sampleStats == null || sampleStats.getN() < 2L) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.tTest(sampleStats.getMean(), mu, sampleStats.getVariance(), sampleStats.getN());
    }

    public boolean tTest(double mu, StatisticalSummary sampleStats, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.tTest(mu, sampleStats) < alpha;
    }

    public double tTest(double[] sample1, double[] sample2) throws IllegalArgumentException, MathException {
        if (sample1 == null || sample2 == null || Math.min(sample1.length, sample2.length) < 2) {
            throw new IllegalArgumentException("insufficient data");
        }
        return this.tTest(StatUtils.mean(sample1), StatUtils.mean(sample2), StatUtils.variance(sample1), StatUtils.variance(sample2), sample1.length, sample2.length);
    }

    public double homoscedasticTTest(double[] sample1, double[] sample2) throws IllegalArgumentException, MathException {
        if (sample1 == null || sample2 == null || Math.min(sample1.length, sample2.length) < 2) {
            throw new IllegalArgumentException("insufficient data");
        }
        return this.homoscedasticTTest(StatUtils.mean(sample1), StatUtils.mean(sample2), StatUtils.variance(sample1), StatUtils.variance(sample2), sample1.length, sample2.length);
    }

    public boolean tTest(double[] sample1, double[] sample2, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.tTest(sample1, sample2) < alpha;
    }

    public boolean homoscedasticTTest(double[] sample1, double[] sample2, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.homoscedasticTTest(sample1, sample2) < alpha;
    }

    public double tTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws IllegalArgumentException, MathException {
        if (sampleStats1 == null || sampleStats2 == null || Math.min(sampleStats1.getN(), sampleStats2.getN()) < 2L) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.tTest(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), sampleStats1.getN(), sampleStats2.getN());
    }

    public double homoscedasticTTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws IllegalArgumentException, MathException {
        if (sampleStats1 == null || sampleStats2 == null || Math.min(sampleStats1.getN(), sampleStats2.getN()) < 2L) {
            throw new IllegalArgumentException("insufficient data for t statistic");
        }
        return this.homoscedasticTTest(sampleStats1.getMean(), sampleStats2.getMean(), sampleStats1.getVariance(), sampleStats2.getVariance(), sampleStats1.getN(), sampleStats2.getN());
    }

    public boolean tTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.tTest(sampleStats1, sampleStats2) < alpha;
    }

    protected DistributionFactory getDistributionFactory() {
        if (this.distributionFactory == null) {
            this.distributionFactory = DistributionFactory.newInstance();
        }
        return this.distributionFactory;
    }

    protected double df(double v1, double v2, double n1, double n2) {
        return (v1 / n1 + v2 / n2) * (v1 / n1 + v2 / n2) / (v1 * v1 / (n1 * n1 * (n1 - 1.0)) + v2 * v2 / (n2 * n2 * (n2 - 1.0)));
    }

    protected double t(double m, double mu, double v, double n) {
        return (m - mu) / Math.sqrt(v / n);
    }

    protected double t(double m1, double m2, double v1, double v2, double n1, double n2) {
        return (m1 - m2) / Math.sqrt(v1 / n1 + v2 / n2);
    }

    protected double homoscedasticT(double m1, double m2, double v1, double v2, double n1, double n2) {
        double pooledVariance = ((n1 - 1.0) * v1 + (n2 - 1.0) * v2) / (n1 + n2 - 2.0);
        return (m1 - m2) / Math.sqrt(pooledVariance * (1.0 / n1 + 1.0 / n2));
    }

    protected double tTest(double m, double mu, double v, double n) throws MathException {
        double t = Math.abs(this.t(m, mu, v, n));
        TDistribution tDistribution = this.getDistributionFactory().createTDistribution(n - 1.0);
        return 1.0 - tDistribution.cumulativeProbability(-t, t);
    }

    protected double tTest(double m1, double m2, double v1, double v2, double n1, double n2) throws MathException {
        double t = Math.abs(this.t(m1, m2, v1, v2, n1, n2));
        double degreesOfFreedom = 0.0;
        degreesOfFreedom = this.df(v1, v2, n1, n2);
        TDistribution tDistribution = this.getDistributionFactory().createTDistribution(degreesOfFreedom);
        return 1.0 - tDistribution.cumulativeProbability(-t, t);
    }

    protected double homoscedasticTTest(double m1, double m2, double v1, double v2, double n1, double n2) throws MathException {
        double t = Math.abs(this.homoscedasticT(m1, m2, v1, v2, n1, n2));
        double degreesOfFreedom = 0.0;
        degreesOfFreedom = n1 + n2 - 2.0;
        TDistribution tDistribution = this.getDistributionFactory().createTDistribution(degreesOfFreedom);
        return 1.0 - tDistribution.cumulativeProbability(-t, t);
    }
}

