/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.accessories;

import com.google.common.collect.Lists;
import com.mathworks.desktop.overlay.impl.DefaultOverlayManager;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.WindowUtils;
import com.sun.awt.AWTUtilities;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class CalloutToolTip {
    public static final List<Direction> EAST_WEST_PLACEMENT = Lists.newArrayList((Object[])new Direction[]{Direction.EAST, Direction.WEST});
    public static final List<Direction> WEST_EAST_PLACEMENT = Lists.newArrayList((Object[])new Direction[]{Direction.WEST, Direction.EAST});
    public static final List<Direction> NORTH_SOUTH_PLACEMENT = Lists.newArrayList((Object[])new Direction[]{Direction.NORTH, Direction.SOUTH});
    public static final List<Direction> SOUTH_NORTH_PLACEMENT = Lists.newArrayList((Object[])new Direction[]{Direction.SOUTH, Direction.NORTH});
    private final Component fInvoker;
    private final Component fContent;
    private final Rectangle fReferenceRect;
    private final List<Direction> fPlacementOptions;
    private final Dimension fMaxContentSize;
    private Window fTipWindow;
    private static final int ARROW_SIZE = 10;
    private static final int BORDER_THICKNESS = 1;
    private static final int SCREEN_MARGIN = 8;

    public CalloutToolTip(Component component, Component component2, List<Direction> list) {
        this(component, null, component2, null, list);
    }

    public CalloutToolTip(Component component, Rectangle rectangle, Component component2, Dimension dimension, List<Direction> list) {
        this.fInvoker = component;
        this.fContent = component2;
        this.fReferenceRect = rectangle;
        this.fPlacementOptions = list;
        this.fMaxContentSize = dimension;
    }

    public void show() {
        Object object2;
        Rectangle rectangle;
        Dimension dimension = this.fContent.getPreferredSize();
        if (this.fMaxContentSize != null) {
            if (dimension.width > this.fMaxContentSize.width) {
                dimension.width = this.fMaxContentSize.width;
                if (this.fContent instanceof JTextComponent) {
                    this.fContent.setSize(dimension.width, this.fMaxContentSize.height);
                    this.fContent.doLayout();
                    try {
                        rectangle = ((JTextComponent)this.fContent).modelToView(((JTextComponent)this.fContent).getDocument().getLength() - 1);
                        int n = rectangle.y + rectangle.height;
                        if (n > dimension.height) {
                            dimension.height = n;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            if (dimension.height > this.fMaxContentSize.height) {
                dimension.height = this.fMaxContentSize.height;
            }
        }
        dimension.width += 2;
        dimension.height += 2;
        rectangle = this.fReferenceRect;
        if (this.fReferenceRect == null) {
            Point point = new Point();
            SwingUtilities.convertPointToScreen(point, this.fInvoker);
            rectangle = new Rectangle(point.x, point.y, this.fInvoker.getWidth(), this.fInvoker.getHeight());
        }
        Window window = SwingUtilities.windowForComponent(this.fInvoker);
        Rectangle rectangle2 = WindowUtils.getInsetScreenBounds((GraphicsConfiguration)window.getGraphicsConfiguration());
        rectangle2.grow(-8, -8);
        Direction direction = null;
        for (Object object2 : this.fPlacementOptions) {
            switch (object2) {
                case NORTH: {
                    if (rectangle2.y + dimension.height + 10 > rectangle.y) break;
                    direction = object2;
                    break;
                }
                case SOUTH: {
                    if (rectangle.y + rectangle.height + dimension.height + 10 > rectangle2.y + rectangle2.height) break;
                    direction = object2;
                    break;
                }
                case EAST: {
                    if (rectangle.x + rectangle.width + dimension.width + 10 > rectangle2.x + rectangle2.width) break;
                    direction = object2;
                    break;
                }
                case WEST: {
                    if (rectangle2.x + dimension.width + 10 >= rectangle.x) break;
                    direction = object2;
                }
            }
            if (direction == null) continue;
            break;
        }
        if (direction == null) {
            Direction direction2 = direction = this.fPlacementOptions != null ? this.fPlacementOptions.get(0) : Direction.EAST;
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            dimension.height += 10;
        } else {
            dimension.width += 10;
        }
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        object2 = new Rectangle(0, 0, dimension.width, dimension.height);
        int n = 0;
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            ((Rectangle)object2).x = point.x - dimension.width / 2;
            int n2 = rectangle2.x + rectangle2.width - ((Rectangle)object2).width;
            if (((Rectangle)object2).x > n2) {
                n = ((Rectangle)object2).x - n2;
                ((Rectangle)object2).x = n2;
            } else if (((Rectangle)object2).x < rectangle2.x) {
                n = ((Rectangle)object2).x - rectangle2.x;
                ((Rectangle)object2).x = rectangle2.x;
            }
            ((Rectangle)object2).y = direction == Direction.NORTH ? rectangle.y - ((Rectangle)object2).height : rectangle.y + rectangle.height;
        } else {
            ((Rectangle)object2).y = point.y - dimension.height / 2;
            int n3 = rectangle2.y + rectangle2.height - ((Rectangle)object2).height;
            if (((Rectangle)object2).y > n3) {
                n = ((Rectangle)object2).y - n3;
                ((Rectangle)object2).y = n3;
            } else if (((Rectangle)object2).y < rectangle2.y) {
                n = ((Rectangle)object2).y - rectangle2.y;
                ((Rectangle)object2).y = rectangle2.y;
            }
            ((Rectangle)object2).x = direction == Direction.WEST ? rectangle.x - ((Rectangle)object2).width : rectangle.x + rectangle.width;
        }
        this.fTipWindow = new TipWindow(window, this.fContent, dimension, CalloutToolTip.getOpposite(direction), n);
        this.fTipWindow.setBounds((Rectangle)object2);
        this.fTipWindow.setVisible(true);
    }

    public void hide() {
        if (this.fTipWindow != null) {
            this.fTipWindow.dispose();
            this.fTipWindow = null;
        }
    }

    public boolean isShowing() {
        return this.fTipWindow != null;
    }

    public Rectangle getBounds() {
        return this.fTipWindow == null ? new Rectangle() : this.fTipWindow.getBounds();
    }

    private static boolean isTranslucencySupported() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return AWTUtilities.isTranslucencyCapable((GraphicsConfiguration)graphicsConfiguration);
    }

    private static boolean isTransparencySupported() {
        return AWTUtilities.isTranslucencySupported((AWTUtilities.Translucency)AWTUtilities.Translucency.PERPIXEL_TRANSPARENT);
    }

    private static Shape createOutline(Rectangle rectangle, Direction direction, int n) {
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            int n2 = rectangle.x + rectangle.width / 2 + CalloutToolTip.limitAbsolute(n, rectangle.width / 2 - 10);
            nArray[0] = rectangle.x;
            nArray[1] = n2 - 10;
            nArray[2] = n2;
            nArray[3] = n2 + 10;
            nArray[4] = rectangle.x + rectangle.width - 1;
            nArray[5] = nArray[4];
            nArray[6] = nArray[0];
            if (direction == Direction.NORTH) {
                nArray2[0] = rectangle.y + 10;
                nArray2[1] = nArray2[0];
                nArray2[2] = rectangle.y;
                nArray2[3] = nArray2[0];
                nArray2[4] = nArray2[0];
                nArray2[5] = rectangle.y + rectangle.height - 1;
                nArray2[6] = nArray2[5];
            } else {
                nArray2[0] = rectangle.y + rectangle.height - 10 - 1;
                nArray2[1] = nArray2[0];
                nArray2[2] = rectangle.y + rectangle.height - 1;
                nArray2[3] = nArray2[0];
                nArray2[4] = nArray2[0];
                nArray2[5] = rectangle.y;
                nArray2[6] = nArray2[5];
            }
        } else {
            int n3 = rectangle.y + rectangle.height / 2 + CalloutToolTip.limitAbsolute(n, rectangle.height / 2 - 10);
            nArray2[0] = rectangle.y;
            nArray2[1] = n3 - 10;
            nArray2[2] = n3;
            nArray2[3] = n3 + 10;
            nArray2[4] = rectangle.y + rectangle.height - 1;
            nArray2[5] = nArray2[4];
            nArray2[6] = nArray2[0];
            if (direction == Direction.EAST) {
                nArray[0] = rectangle.x + rectangle.width - 10 - 1;
                nArray[1] = nArray[0];
                nArray[2] = rectangle.x + rectangle.width - 1;
                nArray[3] = nArray[0];
                nArray[4] = nArray[0];
                nArray[5] = rectangle.x;
                nArray[6] = nArray[5];
            } else {
                nArray[0] = rectangle.x + 10;
                nArray[1] = nArray[0];
                nArray[2] = rectangle.x;
                nArray[3] = nArray[0];
                nArray[4] = nArray[0];
                nArray[5] = rectangle.x + rectangle.width - 1;
                nArray[6] = nArray[5];
            }
        }
        return new Polygon(nArray, nArray2, 7);
    }

    private static void adjustRect(Rectangle rectangle, Direction direction) {
        rectangle.grow(-1, -1);
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            rectangle.height -= 10;
            if (direction == Direction.NORTH) {
                rectangle.y += 10;
            }
        } else {
            rectangle.width -= 10;
            if (direction == Direction.WEST) {
                rectangle.x += 10;
            }
        }
    }

    private static int limitAbsolute(int n, int n2) {
        if (n > n2) {
            return n2;
        }
        if (n < -n2) {
            return -n2;
        }
        return n;
    }

    private static Direction getOpposite(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.NORTH;
            }
            case EAST: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.EAST;
            }
        }
        return null;
    }

    private static class ArrowPanel
    extends MJPanel {
        private final Direction fArrowSide;
        private final int fArrowOffset;

        private ArrowPanel(Component component, Direction direction, int n) {
            this.fArrowSide = direction;
            this.fArrowOffset = n;
            this.add(component);
            this.setOpaque(false);
        }

        public void doLayout() {
            Component component = this.getComponent(0);
            Rectangle rectangle = this.getBounds();
            CalloutToolTip.adjustRect(rectangle, this.fArrowSide);
            component.setBounds(rectangle);
        }

        public void paintComponent(Graphics graphics) {
            Shape shape = CalloutToolTip.createOutline(this.getBounds(), this.fArrowSide, this.fArrowOffset);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(UIManager.getColor("ToolTip.background"));
            graphics2D.fill(shape);
            graphics2D.setColor(UIManager.getColor("ToolTip.foreground"));
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(shape);
        }
    }

    private static class TipWindow
    extends DefaultOverlayManager.ForeignOverlayWindow {
        private TipWindow(Window window, Component component, Dimension dimension, Direction direction, int n) {
            super(window);
            this.setName("TipWindow");
            if (CalloutToolTip.isTranslucencySupported()) {
                AWTUtilities.setWindowOpaque((Window)((Object)this), (boolean)false);
            } else if (CalloutToolTip.isTransparencySupported()) {
                AWTUtilities.setWindowShape((Window)((Object)this), (Shape)CalloutToolTip.createOutline(new Rectangle(0, 0, dimension.width + 1, dimension.height + 1), direction, n));
            }
            this.setFocusableWindowState(false);
            this.add((Component)((Object)new ArrowPanel(component, direction, n)));
        }

        public void doLayout() {
            Component component = this.getComponent(0);
            component.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

