/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.view;

import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.attr.AttributeChangeListener;
import com.mathworks.desktop.mnemonics.HasMnemonic;
import com.mathworks.desktop.mnemonics.Mnemonic;
import com.mathworks.desktop.mnemonics.MnemonicsManagers;
import com.mathworks.desktop.mnemonics.MnemonicsProvider;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayConstraints;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolstrip.accessories.IsOnToolstripPredicate;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.components.gallery.GalleryButton;
import com.mathworks.toolstrip.components.gallery.GalleryOptions;
import com.mathworks.toolstrip.components.gallery.GalleryResources;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.model.SearchableGalleryModel;
import com.mathworks.toolstrip.components.gallery.popupview.FavoriteAction;
import com.mathworks.toolstrip.components.gallery.popupview.GalleryPopupView;
import com.mathworks.toolstrip.components.gallery.view.BusyAffordanceProxy;
import com.mathworks.toolstrip.components.gallery.view.HintButton;
import com.mathworks.toolstrip.components.gallery.view.ItemPopupMenuCustomizer;
import com.mathworks.toolstrip.components.gallery.view.MoreButton;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.NegationPredicate;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;

public class GalleryView
extends TSPanel
implements HasMnemonic,
TSContextMenuContributor {
    private GalleryModel fModel;
    private PropertyChangeListener fModelListener;
    private ItemPopupMenuCustomizer fPopupMenuCustomizer;
    private TSButton fMoreButton;
    private int fNumberOfColumnsCurrentlyShowing;
    private final GalleryOptions fOptions;
    private GalleryOptions.PopupViewType fPopupType;
    private JComponent fPopupExtension;
    private List<PopupListener> fPopupListeners = new ArrayList<PopupListener>();
    private MJLayeredPane fInnerPanel;
    private List<JButton> fButtons = new ArrayList<JButton>();
    private BusyAffordanceProxy fBusyAffordance;
    private JButton fOverlayButton;
    private GalleryPopupView fPopupView;
    private int fPopupWidth;
    private int fPopupHeight;
    private static final int MORE_BUTTON_WIDTH = 20;
    private static final int MINIMUM_POPUP_WIDTH = 360;
    private static final String POPUP_OVERLAY_KEY = "GALLERY_VIEW_POPUP_OVERLAY_KEY";
    private static final int BOTTOM_MARGIN = 3;

    public GalleryView(@NotNull GalleryModel galleryModel, GalleryOptions galleryOptions) {
        this.fModel = galleryModel;
        this.fOptions = galleryOptions;
        this.fPopupType = galleryOptions.getInitialPopupView();
        this.setLayout(null);
        final ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
        this.fInnerPanel = new MJLayeredPane(){

            public void paintComponent(Graphics graphics) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, toolstripTheme.getGalleryViewTopColor(), 0.0f, n2, toolstripTheme.getGalleryViewBottomColor()));
                graphics2D.fillRect(0, 0, n, n2);
                super.paintComponent(graphics);
            }
        };
        this.fInnerPanel.setLayout(null);
        this.fInnerPanel.setFocusable(true);
        this.fInnerPanel.setBorder(BorderFactory.createLineBorder(toolstripTheme.getGalleryViewOutlineColor()));
        this.fInnerPanel.setOpaque(true);
        this.fInnerPanel.setFocusable(false);
        this.add((Component)this.fInnerPanel);
        this.fOverlayButton = new HintButton();
        this.fOverlayButton.setVisible(false);
        this.fInnerPanel.add((Component)this.fOverlayButton, (Object)JLayeredPane.PALETTE_LAYER);
        this.fBusyAffordance = new BusyAffordanceProxy();
        this.fInnerPanel.add((Component)this.fBusyAffordance.getComponent(), (Object)JLayeredPane.POPUP_LAYER);
        this.fBusyAffordance.getComponent().setVisible(false);
        this.fModelListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GalleryView.this.refresh();
            }
        };
        this.fModel.addPropertyChangeListener(this.fModelListener);
        this.refresh();
        if (this.fPopupType != GalleryOptions.PopupViewType.NONE) {
            this.fMoreButton = new MoreButton();
            this.fMoreButton.setAction((Action)((Object)new PopupAction()));
            this.fMoreButton.setToolTipText(GalleryResources.getString("showmore.tooltip"));
            this.add((Component)((Object)this.fMoreButton));
        }
    }

    public GalleryModel getModel() {
        return this.fModel;
    }

    public void setModel(@NotNull GalleryModel galleryModel) {
        if (galleryModel != this.fModel) {
            this.fModel.removePropertyChangeListener(this.fModelListener);
            galleryModel.addPropertyChangeListener(this.fModelListener);
            this.fModel = galleryModel;
            this.refresh();
        }
    }

    public GalleryOptions getOptions() {
        return this.fOptions;
    }

    public void setMoreButtonMnemonic(String string) {
        if (this.fMoreButton != null) {
            this.fMoreButton.setButtonMnemonic(string);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            if (this.fMoreButton != null) {
                this.fMoreButton.setEnabled(bl);
            }
            for (JButton jButton : this.fButtons) {
                if (bl) {
                    jButton.setEnabled(jButton.getAction().isEnabled());
                    continue;
                }
                jButton.setEnabled(false);
            }
        }
    }

    public JButton getMoreButton() {
        return this.fMoreButton;
    }

    public GalleryPopupView getPopupView() {
        return this.fPopupView;
    }

    public void addPopupListener(PopupListener popupListener) {
        this.fPopupListeners.add(popupListener);
    }

    public void removePopupListener(PopupListener popupListener) {
        this.fPopupListeners.remove(popupListener);
    }

    public void setPopupExtension(JComponent jComponent) {
        this.fPopupExtension = jComponent;
    }

    public int getMinimumCols() {
        return this.fOptions.getMinColumnCount();
    }

    public void setPopupMenuCustomizer(ItemPopupMenuCustomizer itemPopupMenuCustomizer) {
        this.fPopupMenuCustomizer = itemPopupMenuCustomizer;
    }

    public void setBusy(boolean bl) {
        if (bl) {
            this.fBusyAffordance.getComponent().setVisible(true);
            this.fBusyAffordance.start();
        } else {
            this.fBusyAffordance.getComponent().setVisible(false);
            this.fBusyAffordance.stop();
        }
    }

    public void setOverlayAction(Action action) {
        if (action == null) {
            this.fOverlayButton.setVisible(false);
        } else {
            this.fOverlayButton.setAction(action);
            this.fOverlayButton.setVisible(true);
        }
        this.revalidate();
        this.repaint();
    }

    public void setOverlayText(String string) {
        if (string == null) {
            this.fOverlayButton.setVisible(false);
            this.revalidate();
            this.repaint();
        } else {
            MJAbstractAction mJAbstractAction = new MJAbstractAction(string){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            mJAbstractAction.setEnabled(false);
            this.setOverlayAction((Action)mJAbstractAction);
        }
    }

    private void refresh() {
        for (JButton serializable2 : this.fButtons) {
            this.fInnerPanel.remove((Component)serializable2);
            MJUtilities.dispose((AbstractButton)serializable2);
        }
        this.fButtons.clear();
        int n = Integer.MAX_VALUE;
        if (this.fOptions.getMaxColumnCount() != Integer.MAX_VALUE) {
            n = this.fOptions.getRowCount() * this.fOptions.getMaxColumnCount();
        }
        ArrayList<Item> arrayList = new ArrayList<Item>();
        List<Category> list = this.fOptions.showOnlyFavoritesOnToolstrip() ? Collections.singletonList(Category.FAVORITES) : this.fModel.getCategories();
        block1: for (Category category : list) {
            for (Item item : this.fModel.getItems(category)) {
                if (this.fButtons.size() >= n) continue block1;
                if (arrayList.contains(item)) continue;
                arrayList.add(item);
                GalleryButton galleryButton = new GalleryButton(item.getAction());
                galleryButton.setLabelLineCount(this.fOptions.getLabelLineCount());
                galleryButton.setShowSelection(this.fOptions.showSelection());
                galleryButton.putClientProperty("item", item);
                galleryButton.setName(item.getName());
                if (!this.isEnabled()) {
                    galleryButton.setEnabled(false);
                }
                this.fButtons.add((JButton)((Object)galleryButton));
                this.fInnerPanel.add((Component)((Object)galleryButton), (Object)JLayeredPane.DEFAULT_LAYER);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public Mnemonic getComponentMnemonic() {
        return this.fMoreButton == null ? null : this.fMoreButton.getComponentMnemonic();
    }

    public MnemonicsProvider getMnemonicsProvider() {
        return this.fMoreButton == null ? null : this.fMoreButton.getMnemonicsProvider();
    }

    private static int getNumberOfItemsInModel(GalleryModel galleryModel) {
        int n = 0;
        for (Category category : galleryModel.getCategories()) {
            if (category.equals(Category.FAVORITES)) continue;
            n += galleryModel.getItems(category).size();
        }
        return n;
    }

    public int getNumberOfColumnsInGalleryView() {
        if (this.fOptions.getMaxColumnCount() != Integer.MAX_VALUE) {
            return this.fOptions.getMaxColumnCount();
        }
        int n = GalleryView.getNumberOfItemsInModel(this.fModel);
        if (this.fOptions.getRowCount() > 1) {
            n = (n + this.fOptions.getRowCount() - 1) / this.fOptions.getRowCount();
        }
        return n;
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.fInnerPanel.getInsets();
        int n3 = n2 - 3;
        int n4 = n - (this.fMoreButton != null ? 20 : 0);
        int n5 = n3 - insets.top - insets.bottom;
        int n6 = n4 - insets.left - insets.right - 16;
        this.fInnerPanel.setBounds(0, 0, n4, n3);
        int n7 = n5 - 4;
        int n8 = this.fOptions.getRowCount();
        if (n8 > 1) {
            n7 = (n7 - 1) / 2;
        }
        int n9 = (int)((float)n7 * this.fOptions.getColumnWidth());
        int n10 = (n6 + 5) / (n9 + 5);
        int n11 = insets.left + 8;
        int n12 = insets.top + 2;
        int n13 = this.getNumberOfColumnsInGalleryView();
        int n14 = 0;
        while (n14 < n13) {
            if (n14 < this.fButtons.size()) {
                JButton jButton = this.fButtons.get(n14);
                if (n14 < n10) {
                    jButton.setBounds(n11, n12, n9, n7);
                } else {
                    jButton.setBounds(0, 0, 0, 0);
                }
                if (n8 > 1 && n13 + n14 < this.fButtons.size()) {
                    JButton jButton2 = this.fButtons.get(n13 + n14);
                    if (n14 < n10) {
                        jButton2.setBounds(n11, n12 + n7 + 1, n9, n7);
                    } else {
                        jButton2.setBounds(0, 0, 0, 0);
                    }
                }
            }
            ++n14;
            n11 += n9 + 5;
        }
        this.fNumberOfColumnsCurrentlyShowing = n10;
        if (this.fMoreButton != null) {
            this.fMoreButton.setBounds(n - 20, 0, 20, n3);
        }
        if (this.fBusyAffordance.getComponent().isVisible()) {
            Dimension dimension = this.fBusyAffordance.getComponent().getPreferredSize();
            this.fBusyAffordance.getComponent().setBounds((n4 - dimension.width) / 2, (n3 - dimension.height) / 2, dimension.width, dimension.height);
            this.fOverlayButton.setBounds(n, n2, 0, 0);
        } else if (this.fOverlayButton.isVisible()) {
            Dimension dimension = this.fOverlayButton.getPreferredSize();
            this.fOverlayButton.setBounds((n4 - dimension.width) / 2, (n3 - dimension.height) / 2, dimension.width, dimension.height);
        }
    }

    public void customizeContextMenu(JPopupMenu jPopupMenu, Item item) {
        this.fPopupMenuCustomizer.customize(jPopupMenu, item);
    }

    @Override
    public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        Item item;
        if (mouseEvent.getComponent() instanceof GalleryButton && (item = (Item)((JComponent)mouseEvent.getComponent()).getClientProperty("item")) != null) {
            TSContextMenuContributor tSContextMenuContributor;
            Object object;
            if (this.fOptions.supportFavorites()) {
                object = new FavoriteAction(item, this.fModel);
                object.putValue("SmallIcon", null);
                jPopupMenu.insert((Action)object, 0);
            }
            if ((object = item.getAction()) != null && (tSContextMenuContributor = (TSContextMenuContributor)object.getValue("toolstrip-context-menu-contributor")) != null) {
                int n = jPopupMenu.getComponentCount();
                Component component = null;
                Component component2 = null;
                if (n > 2) {
                    component = jPopupMenu.getComponent(n - 2);
                    component2 = jPopupMenu.getComponent(n - 1);
                    jPopupMenu.remove(n - 1);
                    jPopupMenu.remove(n - 2);
                }
                tSContextMenuContributor.contributeToToolsripContextMenu(jPopupMenu, mouseEvent);
                if (component != null && component2 != null) {
                    jPopupMenu.add(component);
                    jPopupMenu.add(component2);
                }
            }
            if (this.fPopupMenuCustomizer != null) {
                this.fPopupMenuCustomizer.customize(jPopupMenu, item);
            }
        }
        jPopupMenu.putClientProperty("retain-overlays", true);
    }

    @Override
    public int getPreferredWidth(@NotNull LayoutMode layoutMode, int n) {
        return this.getPreferredWidth(n);
    }

    private int getPreferredWidth(int n) {
        return this.getPreferredWidth(this.getNumberOfColumnsInGalleryView(), n);
    }

    public int getPreferredWidth(int n, int n2) {
        Insets insets = this.fInnerPanel.getInsets();
        int n3 = n * (this.computeButtonSize((int)n2).width + 5) - 5 + 16 + insets.left + insets.right;
        if (this.fMoreButton != null) {
            n3 += 20;
        }
        return n3;
    }

    private Dimension computeButtonSize(int n) {
        Insets insets = this.fInnerPanel.getInsets();
        int n2 = n - insets.top - insets.bottom - 3 - 4;
        if (this.fOptions.getRowCount() > 1) {
            n2 = (n2 - 1) / 2;
        }
        return new Dimension((int)((float)n2 * this.fOptions.getColumnWidth()), n2);
    }

    private class PopupAction
    extends MJAbstractAction {
        private PopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MnemonicsManagers.get().clear();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PopupAction.this.showPopup();
                }
            });
        }

        private void showPopup() {
            final SearchableGalleryModel searchableGalleryModel = new SearchableGalleryModel(GalleryView.this.fModel);
            GalleryView.this.fPopupWidth = this.getPopupWidth();
            Dimension dimension = GalleryView.this.computeButtonSize(GalleryView.this.getHeight());
            GalleryView.this.fPopupView = new GalleryPopupView(searchableGalleryModel, GalleryView.this.fOptions, GalleryView.this.fPopupType, GalleryView.this.fPopupWidth, dimension);
            Window window = WindowUtils.getTopmostWindow((Component)((Object)GalleryView.this));
            final Rectangle rectangle = WindowUtils.getInsetScreenBounds((GraphicsConfiguration)window.getGraphicsConfiguration());
            GalleryView.this.fPopupView.addAttributeChangeListener(new AttributeChangeListener(){

                public void attributeChange(AttributeChangeEvent attributeChangeEvent) {
                    if (searchableGalleryModel.isSearchInProgress()) {
                        return;
                    }
                    if (attributeChangeEvent.getAttribute() == GalleryPopupView.VIEW_TYPE) {
                        Object object;
                        GalleryView.this.fPopupType = (GalleryOptions.PopupViewType)((Object)attributeChangeEvent.getNewValue());
                        OverlayManager overlayManager = OverlayManagers.get((Component)((Object)GalleryView.this));
                        if (overlayManager != null && (object = GalleryView.this.fPopupView.getComponent().getClientProperty(GalleryView.POPUP_OVERLAY_KEY)) instanceof Overlay) {
                            ((Overlay)object).getComponent().setPreferredSize(new Dimension(GalleryView.this.fPopupWidth, PopupAction.this.getPopupHeight(new Point(), rectangle)));
                            overlayManager.packOverlay((Overlay)object);
                        }
                    }
                }
            });
            GalleryView.this.fPopupWidth += new JScrollBar((int)1).getPreferredSize().width + 2;
            JComponent jComponent = GalleryView.this.fPopupView.getComponent();
            if (GalleryView.this.fPopupExtension != null) {
                jComponent = new MJPanel((LayoutManager)new BorderLayout());
                jComponent.add((Component)GalleryView.this.fPopupView.getComponent(), "Center");
                GalleryView.this.fPopupExtension.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ToolstripTheme.getInstance().getGallerySeparatorColor()));
                jComponent.add((Component)GalleryView.this.fPopupExtension, "South");
            }
            jComponent.setBorder(new LineBorder(ToolstripTheme.getInstance().getGalleryPopupBorderColor(), 1));
            Point point = new Point();
            GalleryView.this.fPopupHeight = this.getPopupHeight(point, rectangle);
            jComponent.setPreferredSize(new Dimension(GalleryView.this.fPopupWidth, GalleryView.this.fPopupHeight));
            Rectangle rectangle2 = LAFUtil.convertRectangleFromScreen(new Rectangle(point.x, point.y, GalleryView.this.fPopupWidth, GalleryView.this.fPopupHeight), window);
            final OverlayManager overlayManager = OverlayManagers.get((Component)((Object)GalleryView.this));
            final Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (overlayManager != null) {
                OverlayConstraints overlayConstraints = OverlayConstraints.popup((Component)((Object)GalleryView.this), (Component)jComponent);
                overlayConstraints.setBounds(rectangle2);
                overlayConstraints.setAllowMultiSelect(GalleryView.this.fOptions.getMultiSelectPopup());
                overlayConstraints.setShouldConsumeDismissEvent((Predicate)new NegationPredicate((Predicate)new IsOnToolstripPredicate()));
                final Overlay overlay = overlayManager.addOverlay((Component)jComponent, overlayConstraints);
                Disposer.register((Disposable)new Disposable(){

                    public void dispose() {
                        if (GalleryView.this.fPopupView != null) {
                            GalleryView.this.fPopupView.dispose();
                            GalleryView.this.fPopupView = null;
                            for (PopupListener popupListener : GalleryView.this.fPopupListeners) {
                                popupListener.galleryPopupHidden(GalleryView.this);
                            }
                        }
                        if (component != null) {
                            if (PlatformInfo.isLinux()) {
                                component.requestFocus();
                            } else {
                                component.requestFocusInWindow();
                            }
                        }
                    }
                }, (Disposable)overlay);
                AbstractAction abstractAction = new AbstractAction("escape"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        overlayManager.removeOverlay(overlay);
                    }
                };
                GalleryView.this.fPopupView.getComponent().putClientProperty(GalleryView.POPUP_OVERLAY_KEY, overlay);
                GalleryView.this.fPopupView.getComponent().getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
                GalleryView.this.fPopupView.getComponent().getActionMap().put("escape", abstractAction);
                GalleryView.this.fPopupView.setCloseActionListener(abstractAction);
                GalleryView.this.fPopupView.getComponent().putClientProperty("temporary-focus-owner", true);
                if (PlatformInfo.isLinux()) {
                    GalleryView.this.fPopupView.requestFocus();
                } else {
                    GalleryView.this.fPopupView.requestFocusInWindow();
                }
                for (PopupListener popupListener : GalleryView.this.fPopupListeners) {
                    popupListener.galleryPopupShown(GalleryView.this);
                }
            }
        }

        private int getPopupWidth() {
            int n = GalleryView.this.getHeight();
            Dimension dimension = GalleryView.this.computeButtonSize(n);
            int n2 = GalleryView.this.getPreferredWidth(GalleryView.this.fNumberOfColumnsCurrentlyShowing, n);
            if (n2 < 360) {
                Insets insets = GalleryView.this.fInnerPanel.getInsets();
                int n3 = 344 - insets.left - insets.right + 5;
                int n4 = dimension.width;
                int n5 = (n3 + n4 - 1) / n4;
                n2 = GalleryView.this.getPreferredWidth(n5, n);
            } else if (GalleryView.this.fMoreButton != null) {
                n2 -= 20;
            }
            return n2;
        }

        private int getPopupHeight(Point point, Rectangle rectangle) {
            SwingUtilities.convertPointToScreen(point, (Component)((Object)GalleryView.this));
            int n = rectangle.y + rectangle.height - point.y - 100;
            int n2 = GalleryView.this.fPopupView.getPreferredHeight();
            if (GalleryView.this.fPopupExtension != null) {
                n2 += ((GalleryView)GalleryView.this).fPopupExtension.getPreferredSize().height;
            }
            if (n > n2) {
                n = n2;
            }
            if (n < 200) {
                n = 200;
            }
            return n;
        }
    }

    public static interface PopupListener {
        public void galleryPopupShown(GalleryView var1);

        public void galleryPopupHidden(GalleryView var1);
    }
}

