/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.impl;

import com.google.common.base.Preconditions;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.attr.AttributeChangeListener;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.accessories.Resources;
import com.mathworks.toolstrip.plaf.ToolstripHeaderUI;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ToolstripHeaderPanel
extends JPanel
implements AttributeChangeListener {
    private DefaultToolstrip fToolstrip;
    private JButton fCollapseButton;

    public ToolstripHeaderPanel(DefaultToolstrip defaultToolstrip) {
        super(null);
        this.fToolstrip = defaultToolstrip;
        this.setName("toolstrip.header");
        this.putClientProperty("temporary-focus-owner", true);
        this.fCollapseButton = this.getCollapseButton();
        this.fToolstrip.addTabNeighbor(this.fCollapseButton, 4);
        this.updateCollapseButton((Toolstrip.State)((Object)this.fToolstrip.getAttribute((Attribute)Toolstrip.STATE)));
        this.fToolstrip.addAttributeChangeListener(this);
    }

    public JComponent addTab(int n, ToolstripTab toolstripTab) {
        ToolstripHeaderUI.HeaderTab headerTab = ((ToolstripHeaderUI)this.getUI()).createTab(toolstripTab);
        return (JComponent)this.add((Component)headerTab, n);
    }

    public void removeTab(int n, ToolstripTab toolstripTab) {
        ToolstripHeaderUI.HeaderTab headerTab = (ToolstripHeaderUI.HeaderTab)this.getComponent(n);
        Preconditions.checkArgument((headerTab != null && headerTab.getClient() == toolstripTab ? 1 : 0) != 0, (String)"Invalid index %s when removing %s", (Object[])new Object[]{n, toolstripTab});
        this.remove(n);
    }

    public DefaultToolstrip getToolstrip() {
        return this.fToolstrip;
    }

    public void relinquishFocus() {
        ((ToolstripHeaderUI)this.getUI()).relinquishFocus();
    }

    @Override
    public String getUIClassID() {
        return "Toolstrip.ToolstripHeaderUI";
    }

    private JButton getCollapseButton() {
        AbstractAction abstractAction = new AbstractAction("Collapse", ToolstripIcons.COLLAPSE_UP.getIcon()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolstrip.State state = (Toolstrip.State)((Object)ToolstripHeaderPanel.this.fToolstrip.getAttribute((Attribute)Toolstrip.STATE));
                if (state == Toolstrip.State.EXPANDED) {
                    ToolstripHeaderPanel.this.fToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.COLLAPSED);
                } else if (state == Toolstrip.State.COLLAPSED || state == Toolstrip.State.EXPANDED_AS_POPUP) {
                    ToolstripHeaderPanel.this.fToolstrip.setAttribute((Attribute)Toolstrip.STATE, (Object)Toolstrip.State.EXPANDED);
                }
            }
        };
        MJButton mJButton = new MJButton((Action)abstractAction);
        MJToolBar.configureButton((MJButton)mJButton);
        mJButton.setAlignmentX(0.5f);
        mJButton.setAlignmentY(0.5f);
        mJButton.setPreferredSize(new Dimension(ToolstripIcons.COLLAPSE_UP.getIcon().getIconWidth() + 8, ToolstripIcons.COLLAPSE_UP.getIcon().getIconHeight() + 8));
        mJButton.setMaximumSize(mJButton.getPreferredSize());
        mJButton.setMinimumSize(mJButton.getPreferredSize());
        mJButton.setOpaque(false);
        mJButton.setName("toolstrip.header.collapseButton");
        return mJButton;
    }

    public void attributeChange(AttributeChangeEvent attributeChangeEvent) {
        if (attributeChangeEvent.getAttribute() == Toolstrip.STATE) {
            Toolstrip.State state = (Toolstrip.State)((Object)attributeChangeEvent.getNewValue());
            this.updateCollapseButton(state);
        } else if (attributeChangeEvent.getAttribute() == DefaultToolstrip.COLLAPSABLE) {
            if (((Boolean)attributeChangeEvent.getNewValue()).booleanValue()) {
                this.fToolstrip.addTabNeighbor(this.fCollapseButton, 4);
                this.updateCollapseButton((Toolstrip.State)((Object)this.fToolstrip.getAttribute((Attribute)Toolstrip.STATE)));
            } else {
                this.fToolstrip.removeTabNeighbor(this.fCollapseButton);
            }
        }
    }

    private void updateCollapseButton(Toolstrip.State state) {
        if (state == Toolstrip.State.EXPANDED) {
            this.fCollapseButton.setIcon(ToolstripIcons.COLLAPSE_UP.getIcon());
            this.fCollapseButton.setToolTipText(Resources.getString("menuitem.CollapseToolstrip"));
        } else if (state == Toolstrip.State.COLLAPSED || state == Toolstrip.State.EXPANDED_AS_POPUP) {
            this.fCollapseButton.setIcon(ToolstripIcons.COLLAPSE_DOWN.getIcon());
            this.fCollapseButton.setToolTipText(Resources.getString("menuitem.ExpandToolstrip"));
        }
    }
}

