/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayConstraints;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.ResizableIcon;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.event.EventListenerList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class TSListCellRenderer
extends JComponent
implements ListCellRenderer,
MouseListener,
MouseMotionListener {
    private final PopupList fList;
    private final EventListenerList<ListActionListener> fListeners = EventListenerList.newEventListenerList(ListActionListener.class);
    private ListItem fHoverItem;
    private Overlay fOverlay;
    private ListItem fItem;
    private boolean fSelected;
    private boolean fHasFocus;
    private static final int LEFT_HEADER_GAP = 10;
    private static final int RIGHT_HEADER_GAP = 10;
    private static final int VERTICAL_HEADER_GAP = 7;
    public static final int LEFT_TEXT_GAP = 6;
    public static final int RIGHT_TEXT_GAP = 6;
    public static final int VERTICAL_TEXT_GAP = 8;
    private static final int VERTICAL_TEXT_GAP_SIMPLE_MENU = 5;
    private static final int LEFT_ICON_GAP = 8;
    private static final int RIGHT_ICON_GAP = 4;
    private static final int VERTICAL_ICON_GAP = 5;
    private static final int SHORTCUT_RIGHT_GAP = 3;
    private static final int SHORTCUT_LEFT_GAP = 20;
    private static final int SUB_LIST_LEFT_GAP = 6;
    private static final int SUB_LIST_RIGHT_GAP = 3;
    private static final Icon DISABLED_SUB_LIST_ICON = LAFUtil.getDisabledIcon(new JPanel(), ToolstripIcons.SHOW_SUB_LIST.getIcon());

    public TSListCellRenderer(PopupList popupList) {
        this.fList = popupList;
        popupList.addMouseListener(this);
        popupList.addMouseMotionListener(this);
        popupList.getActionMap().put("up", new AbstractAction("up"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TSListCellRenderer.this.fList.getSelectedIndex();
                int n2 = TSListCellRenderer.this.fList.getModel().getSize();
                if (n == -1) {
                    n = n2;
                }
                int n3 = n2;
                do {
                    n = (n - 1 + n2) % n2;
                } while (((ListItem)TSListCellRenderer.this.fList.getModel().getElementAt(n)).isHeader() && --n3 >= 0);
                TSListCellRenderer.this.fHoverItem = null;
                TSListCellRenderer.this.fList.setSelectedIndex(n);
                TSListCellRenderer.this.fList.ensureIndexIsVisible(n);
                TSListCellRenderer.this.fList.repaint();
            }
        });
        popupList.getActionMap().put("down", new AbstractAction("down"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = TSListCellRenderer.this.fList.getSelectedIndex();
                int n3 = n = TSListCellRenderer.this.fList.getModel().getSize();
                do {
                    n2 = (n2 + 1) % n;
                } while (((ListItem)TSListCellRenderer.this.fList.getModel().getElementAt(n2)).isHeader() && --n3 >= 0);
                TSListCellRenderer.this.fHoverItem = null;
                TSListCellRenderer.this.fList.setSelectedIndex(n2);
                TSListCellRenderer.this.fList.ensureIndexIsVisible(n2);
                TSListCellRenderer.this.fList.repaint();
            }
        });
        popupList.getActionMap().put("enter", new AbstractAction("enter"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TSListCellRenderer.this.fList.getSelectedIndex();
                if (n >= 0) {
                    ListItem listItem = (ListItem)TSListCellRenderer.this.fList.getModel().getElementAt(n);
                    if (((Boolean)listItem.getAttributes().getAttribute((Attribute)ListItem.ENABLED_STATE)).booleanValue()) {
                        ((ListActionListener)TSListCellRenderer.this.fListeners.fire()).listItemSelected(new ListActionEvent((Object)TSListCellRenderer.this.fList, actionEvent.getID(), actionEvent.getActionCommand(), listItem));
                    }
                    TSUtil.toolstripActionProcessed(TSListCellRenderer.this.fList);
                }
            }
        });
        popupList.getActionMap().put("right", new AbstractAction("right"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListItem listItem;
                int n = TSListCellRenderer.this.fList.getSelectedIndex();
                if (n >= 0 && (listItem = (ListItem)TSListCellRenderer.this.fList.getModel().getElementAt(n)) != null && listItem.isSubList()) {
                    TSListCellRenderer.this.handleSubListSelection(listItem, n, true);
                }
            }
        });
        InputMap inputMap = popupList.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("UP"), "up");
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "down");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "enter");
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "right");
    }

    public void addListActionListener(ListActionListener listActionListener) {
        this.fListeners.addListener((Object)listActionListener);
    }

    public void removeListActionListener(ListActionListener listActionListener) {
        this.fListeners.removeListener((Object)listActionListener);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof ListItem) {
            this.fItem = (ListItem)object;
            this.fSelected = bl;
            this.fHasFocus = bl2;
        }
        return this;
    }

    private ListStyle getStyle() {
        ListStyle listStyle = (ListStyle)((Object)this.fItem.getAttributes().getAttribute(ListItem.STYLE));
        if (listStyle == null) {
            ListModel listModel = this.fList.getModel();
            ListItem listItem = null;
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object e = listModel.getElementAt(i);
                if (e == null || !(e instanceof ListItem)) continue;
                ListItem listItem2 = (ListItem)e;
                if (listItem2 == this.fItem) break;
                if (!listItem2.isHeader()) continue;
                listItem = listItem2;
            }
            if (listItem != null) {
                listStyle = (ListStyle)((Object)listItem.getAttributes().getAttribute(ListItem.STYLE));
            }
            if (listStyle == null) {
                listStyle = this.fList.getListStyle();
            }
        }
        return listStyle;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        String string = (String)this.fItem.getAttributes().getAttribute((Attribute)ListItem.TITLE);
        boolean bl = (Boolean)this.fItem.getAttributes().getAttribute((Attribute)ListItem.ENABLED_STATE);
        if (this.fItem.isHeader()) {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, ToolstripTheme.getInstance().getPopupHeaderFromColor(), 0.0f, n2, ToolstripTheme.getInstance().getPopupHeaderToColor()));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setColor(ToolstripTheme.getInstance().getPopupHeaderBorderColor());
            graphics2D.drawLine(0, n2 - 1, n, n2 - 1);
            graphics2D.setFont(ToolstripTheme.getInstance().getPopupHeaderFont());
            graphics2D.setColor(ToolstripTheme.getInstance().getPopupHeaderColor());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            LAFUtil.drawString(graphics2D, string.toUpperCase(Locale.getDefault()), 10, (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        } else {
            Serializable serializable;
            boolean bl2;
            ListStyle listStyle = this.getStyle();
            graphics2D.setColor(ToolstripTheme.getInstance().getPopupNonSelectedBackgroundColor());
            graphics2D.fillRect(0, 0, n, n2);
            if ((this.fItem == this.fHoverItem || this.fHasFocus || this.fSelected) && bl) {
                graphics2D.setColor(ToolstripTheme.getInstance().getPopupItemHoverFocusColor());
                graphics2D.fillRect(0, 1, n, n2);
            }
            if (bl2 = ((Boolean)this.fItem.getAttributes().getAttribute((Attribute)ListItem.HAS_SEPARATOR)).booleanValue()) {
                graphics2D.setColor(ToolstripTheme.getInstance().getPopupSeparatorColor());
                graphics2D.drawLine(0, n2 - 1, n, n2 - 1);
            }
            String string2 = (String)this.fItem.getAttributes().getAttribute((Attribute)ListItem.DESCRIPTION);
            Icon icon = (Icon)this.fItem.getAttributes().getAttribute((Attribute)ListItem.ICON);
            if (!this.showDescription(listStyle)) {
                graphics2D.setFont(ToolstripTheme.getInstance().getPopupSimpleMenuItemFont());
            } else {
                graphics2D.setFont(ToolstripTheme.getInstance().getPopupTitleFont());
            }
            if (bl) {
                graphics2D.setColor(ToolstripTheme.getInstance().getPopupTitleColor());
            } else {
                graphics2D.setColor(ToolstripTheme.getInstance().getPopupDisabledColor());
                if (icon != null) {
                    if (icon instanceof ResizableIcon) {
                        serializable = TSListCellRenderer.getIconSize(icon, listStyle);
                        ((ResizableIcon)icon).setDimension(((Dimension)serializable).width, ((Dimension)serializable).height);
                    }
                    icon = LAFUtil.getDisabledIcon(new JPanel(), icon);
                }
            }
            serializable = graphics2D.getFontMetrics();
            Dimension dimension = TSListCellRenderer.getIconSize(icon, listStyle);
            String string3 = (String)this.fItem.getAttributes().getAttribute((Attribute)ListItem.SHORTCUT_KEY);
            int n3 = 6;
            if (this.drawIcon(graphics2D, icon, n2, dimension, listStyle)) {
                n3 = 8 + dimension.width + 4 + 6;
            }
            int n4 = 8;
            if (!this.showDescription(listStyle)) {
                Object object;
                if (bl) {
                    graphics2D.setColor(ToolstripTheme.getInstance().getPopupSimpleMenuItemColor());
                } else {
                    graphics2D.setColor(ToolstripTheme.getInstance().getPopupDisabledColor());
                }
                LAFUtil.drawString(graphics2D, string, n3, (n2 - ((FontMetrics)serializable).getHeight()) / 2 + ((FontMetrics)serializable).getAscent());
                int n5 = n;
                if (this.fItem.isSubList()) {
                    object = bl ? ToolstripIcons.SHOW_SUB_LIST.getIcon() : DISABLED_SUB_LIST_ICON;
                    object.paintIcon(this.fList, graphics2D, n5 -= object.getIconWidth() + 3, (n2 - object.getIconHeight()) / 2);
                    n5 -= 6;
                }
                if (string3 != null) {
                    graphics2D.setFont(ToolstripTheme.getInstance().getShortcutKeyFont());
                    object = graphics2D.getFontMetrics();
                    graphics2D.setColor(bl ? ToolstripTheme.getInstance().getPopupShortcutColor() : ToolstripTheme.getInstance().getPopupDisabledColor());
                    LAFUtil.drawString(graphics2D, string3, n5 - ((FontMetrics)object).stringWidth(string3) - 3, (n2 - ((FontMetrics)object).getHeight()) / 2 + ((FontMetrics)object).getAscent());
                }
            } else {
                Serializable serializable2;
                LAFUtil.drawString(graphics2D, string, n3, n4 + ((FontMetrics)serializable).getAscent());
                int n6 = n;
                if (this.fItem.isSubList()) {
                    serializable2 = ToolstripIcons.SHOW_SUB_LIST.getIcon();
                    serializable2.paintIcon(this.fList, graphics2D, n6 -= serializable2.getIconWidth() + 3, n4);
                    n6 -= 6;
                }
                if (string3 != null) {
                    graphics2D.setFont(ToolstripTheme.getInstance().getShortcutKeyFont());
                    serializable2 = graphics2D.getFontMetrics();
                    graphics2D.setColor(bl ? ToolstripTheme.getInstance().getPopupShortcutColor() : ToolstripTheme.getInstance().getPopupDisabledColor());
                    LAFUtil.drawString(graphics2D, string3, n6 - ((FontMetrics)serializable2).stringWidth(string3) - 3, n4 + ((FontMetrics)serializable2).getAscent());
                }
                if (string2 != null) {
                    graphics2D.setFont(ToolstripTheme.getInstance().getPopupDescriptionFont());
                    if (bl) {
                        graphics2D.setColor(ToolstripTheme.getInstance().getPopupDescriptionColor());
                    } else {
                        graphics2D.setColor(ToolstripTheme.getInstance().getPopupDisabledColor());
                    }
                    serializable2 = graphics2D.getFontMetrics();
                    if (listStyle == ListStyle.SINGLE_LINE_DESCRIPTION) {
                        LAFUtil.drawString(graphics2D, string2, n3, n4 + ((FontMetrics)serializable).getHeight() + ((FontMetrics)serializable2).getAscent());
                    } else {
                        String[] stringArray = LAFUtil.breakText(string2);
                        LAFUtil.drawString(graphics2D, stringArray[0], n3, n4 + ((FontMetrics)serializable).getHeight() + ((FontMetrics)serializable2).getAscent());
                        LAFUtil.drawString(graphics2D, stringArray[1], n3, n4 + ((FontMetrics)serializable).getHeight() + ((FontMetrics)serializable2).getHeight() + ((FontMetrics)serializable2).getAscent());
                    }
                }
            }
        }
    }

    private boolean showDescription(ListStyle listStyle) {
        return listStyle == ListStyle.SINGLE_LINE_DESCRIPTION || listStyle == ListStyle.ICON_TEXT_DESCRIPTION;
    }

    private boolean drawIcon(Graphics2D graphics2D, Icon icon, int n, Dimension dimension, ListStyle listStyle) {
        boolean bl = (Boolean)this.fItem.getAttributes().getAttribute((Attribute)ListItem.HAS_CHECKBOX);
        boolean bl2 = (Boolean)this.fItem.getAttributes().getAttribute((Attribute)ListItem.CHECKVALUE_STATE);
        if (bl) {
            ImageIcon imageIcon = null;
            if (bl2) {
                imageIcon = ToolstripIcons.CHECKBOX_CHECKED_POPUPLIST.getIcon();
            } else if (this.fItem == this.fHoverItem && ((Boolean)this.fItem.getAttributes().getAttribute((Attribute)ListItem.ENABLED_STATE)).booleanValue()) {
                imageIcon = ToolstripIcons.CHECKBOX_CHECK_ROLLOVER.getIcon();
            }
            if (imageIcon != null) {
                imageIcon.paintIcon(this.fList, graphics2D, 8 + (dimension.width - imageIcon.getIconWidth()) / 2, (n - imageIcon.getIconHeight()) / 2);
            }
            return true;
        }
        if (listStyle != ListStyle.TEXT_ONLY && icon != null) {
            if (icon instanceof ResizableIcon) {
                ((ResizableIcon)icon).setDimension(dimension.width, dimension.height);
            }
            icon.paintIcon(this.fList, graphics2D, 8 + (dimension.width - icon.getIconWidth()) / 2, (n - icon.getIconHeight()) / 2);
            return true;
        }
        return false;
    }

    private static Dimension getIconSize(Icon icon, ListStyle listStyle) {
        int n;
        int n2 = n = listStyle == ListStyle.ICON_TEXT || listStyle == ListStyle.TEXT_ONLY ? 16 : 24;
        int n3 = n;
        if (icon != null) {
            if (icon instanceof ResizableIcon) {
                n2 = n3 = n;
            } else {
                n2 = icon.getIconWidth();
                n3 = icon.getIconHeight();
            }
        }
        return new Dimension(n2, n3);
    }

    @Override
    public Dimension getPreferredSize() {
        String string = (String)this.fItem.getAttributes().getAttribute((Attribute)ListItem.TITLE);
        int n = 0;
        int n2 = 0;
        if (this.fItem.isHeader()) {
            FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)ToolstripTheme.getInstance().getPopupHeaderFont());
            n = 10 + fontMetrics.stringWidth(string.toUpperCase(Locale.getDefault())) + 10;
            n2 = fontMetrics.getHeight() + 7;
        } else {
            String string2 = (String)this.fItem.getAttributes().getAttribute((Attribute)ListItem.SHORTCUT_KEY);
            ListStyle listStyle = this.getStyle();
            String string3 = (String)this.fItem.getAttributes().getAttribute((Attribute)ListItem.DESCRIPTION);
            Icon icon = (Icon)this.fItem.getAttributes().getAttribute((Attribute)ListItem.ICON);
            FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)ToolstripTheme.getInstance().getPopupTitleFont());
            FontMetrics fontMetrics2 = FontUtils.getFontMetrics((Font)ToolstripTheme.getInstance().getShortcutKeyFont());
            int n3 = string2 == null ? 0 : 20 + fontMetrics2.stringWidth(string2) + 3;
            int n4 = this.fItem.isSubList() ? 6 + ToolstripIcons.SHOW_SUB_LIST.getIcon().getIconWidth() + 3 : 0;
            boolean bl = (Boolean)this.fItem.getAttributes().getAttribute((Attribute)ListItem.HAS_SEPARATOR);
            switch (listStyle) {
                case ICON_TEXT: 
                case LARGE_ICON_TEXT: {
                    Dimension dimension = TSListCellRenderer.getIconSize(icon, listStyle);
                    n = 8 + dimension.width + 4 + fontMetrics.stringWidth(string) + 6 + 6 + n3 + n4;
                    n2 = Math.max(fontMetrics.getHeight() + 10, dimension.height + 10);
                    break;
                }
                case ICON_TEXT_DESCRIPTION: 
                case SINGLE_LINE_DESCRIPTION: {
                    Dimension dimension = TSListCellRenderer.getIconSize(icon, listStyle);
                    n = 8 + dimension.width + 4;
                    int n5 = 0;
                    if (string3 != null) {
                        FontMetrics fontMetrics3 = FontUtils.getFontMetrics((Font)ToolstripTheme.getInstance().getPopupDescriptionFont());
                        if (listStyle == ListStyle.SINGLE_LINE_DESCRIPTION) {
                            n5 = fontMetrics3.stringWidth(string3);
                            n2 = Math.max(fontMetrics.getHeight() + 16 + fontMetrics3.getHeight(), dimension.height + 5);
                        } else {
                            String[] stringArray = LAFUtil.breakText(string3);
                            n5 = Math.max(fontMetrics3.stringWidth(stringArray[0]), fontMetrics3.stringWidth(stringArray[1]));
                            n2 = Math.max(fontMetrics.getHeight() + 16 + fontMetrics3.getHeight() * 2, dimension.height + 5);
                        }
                    }
                    int n6 = fontMetrics.stringWidth(string) + n3 + n4;
                    n += Math.max(n6, n5) + 6 + 6;
                    break;
                }
                case TEXT_ONLY: {
                    n = 6 + fontMetrics.stringWidth(string) + 6 + n3 + n4;
                    if (((Boolean)this.fItem.getAttributes().getAttribute((Attribute)ListItem.HAS_CHECKBOX)).booleanValue()) {
                        n += 28;
                    }
                    n2 = fontMetrics.getHeight() + 10;
                }
            }
            if (bl) {
                n2 += 3;
            }
        }
        return new Dimension(n, n2);
    }

    private ListItem getItemAt(MouseEvent mouseEvent) {
        return this.getItemAt(mouseEvent.getPoint());
    }

    private ListItem getItemAt(Point point) {
        int n = this.fList.locationToIndex(point);
        if (n >= 0) {
            return (ListItem)this.fList.getModel().getElementAt(n);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!MJUtilities.isBasicMouseEvent((MouseEvent)mouseEvent) || MJUtilities.isShowingContextMenu()) {
            return;
        }
        ListItem listItem = this.getItemAt(mouseEvent);
        if (listItem != null && !listItem.isHeader() && !listItem.isSubList() && ((Boolean)listItem.getAttributes().getAttribute((Attribute)ListItem.ENABLED_STATE)).booleanValue()) {
            try {
                ((ListActionListener)this.fListeners.fire()).listItemSelected(new ListActionEvent((Object)this.fList, mouseEvent.getID(), null, listItem));
            }
            finally {
                TSUtil.toolstripActionProcessed(this.fList);
            }
            boolean bl = (Boolean)listItem.getAttributes().getAttribute((Attribute)ListItem.CHECKVALUE_STATE);
            boolean bl2 = (Boolean)listItem.getAttributes().getAttribute((Attribute)ListItem.HAS_CHECKBOX);
            if (bl2) {
                if (bl) {
                    listItem.getAttributes().setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)false);
                } else {
                    listItem.getAttributes().setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)true);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        ListItem listItem;
        if (MJUtilities.isShowingContextMenu()) {
            return;
        }
        int n = this.fList.locationToIndex(mouseEvent.getPoint());
        ListItem listItem2 = listItem = n >= 0 ? (ListItem)this.fList.getModel().getElementAt(n) : null;
        if (listItem != this.fHoverItem) {
            this.fHoverItem = listItem;
            if (this.fOverlay != null) {
                OverlayManagers.get((Component)this.fList).removeOverlay(this.fOverlay);
                this.fOverlay = null;
            }
            this.fList.repaint();
            if (listItem != null && listItem.isSubList()) {
                this.handleSubListSelection(listItem, n, false);
            }
        }
        if (listItem != null) {
            this.fList.setSelectedIndex(n);
        }
    }

    private void handleSubListSelection(ListItem listItem, final int n, final boolean bl) {
        ((PopupListener)listItem.getAttributes().getAttribute(ListItem.POPUP_LISTENER)).onPopupEvent(this.fList, new PopupListener.PopupCallback(){

            @Override
            public void show(JComponent jComponent) {
                PopupList popupList;
                int n2;
                TSListCellRenderer.this.fOverlay = TSListCellRenderer.this.showSubList(n, jComponent);
                if (TSListCellRenderer.this.fOverlay != null) {
                    Disposer.register((Disposable)new Disposable(){

                        public void dispose() {
                        }
                    }, (Disposable)TSListCellRenderer.this.fOverlay);
                }
                if (bl && jComponent instanceof PopupList && (n2 = (popupList = (PopupList)jComponent).getFirstValidSelectionIndex()) >= 0) {
                    popupList.setSelectedIndex(n2);
                }
            }
        });
    }

    private Overlay showSubList(int n, JComponent jComponent) {
        Object object;
        int n2;
        int n3;
        Dimension dimension = jComponent.getPreferredSize();
        Rectangle rectangle = this.fList.getCellBounds(n, n);
        rectangle = LAFUtil.convertRectangleToScreen(rectangle, this.fList);
        Window window = WindowUtils.getTopmostWindow((Component)this.fList);
        Rectangle rectangle2 = WindowUtils.getInsetScreenBounds((GraphicsConfiguration)window.getGraphicsConfiguration());
        int n4 = rectangle.x + rectangle.width;
        Rectangle rectangle3 = new Rectangle(n4, rectangle.y, dimension.width, dimension.height);
        if (n4 + dimension.width > rectangle2.x + rectangle2.width) {
            rectangle3.x = rectangle.x - dimension.width;
        }
        if (dimension.height > (n3 = 4 * rectangle2.height / 5)) {
            rectangle3.height = n3;
        }
        if (rectangle3.y + rectangle3.height > (n2 = rectangle2.y + rectangle2.height - 20)) {
            rectangle3.y = n2 - rectangle3.height;
        }
        Rectangle rectangle4 = LAFUtil.convertRectangleFromScreen(rectangle3, window);
        if (rectangle3.height < dimension.height) {
            object = new MJScrollPane((Component)jComponent, 22, 31);
            rectangle4.width += ((MJScrollPane)object).getVerticalScrollBar().getPreferredSize().width;
        } else {
            object = new JPanel(new BorderLayout());
            ((JComponent)object).setBorder(ToolstripTheme.getInstance().getPopupLineBorder());
            ((Container)object).add(jComponent);
        }
        OverlayConstraints overlayConstraints = OverlayConstraints.popup((Component)this.fList, (Component)object);
        overlayConstraints.setBounds(rectangle4);
        Overlay overlay = null;
        final OverlayManager overlayManager = OverlayManagers.get((Component)this.fList);
        if (overlayManager != null) {
            final Overlay overlay2 = overlay = overlayManager.addOverlay((Component)object, overlayConstraints);
            final boolean bl = this.fList.isFocusOwner();
            ((JComponent)object).getActionMap().put("escape", new AbstractAction("escape"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    overlayManager.removeOverlay(overlay2);
                    if (bl) {
                        TSListCellRenderer.this.fList.requestFocusInWindow();
                    }
                }
            });
            InputMap inputMap = ((JComponent)object).getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
            jComponent.putClientProperty("temporary-focus-owner", true);
            jComponent.requestFocusInWindow();
            jComponent.addKeyListener(new SubListKeyListener(overlay2, overlayManager, this.fList));
        }
        return overlay;
    }

    private class SubListKeyListener
    implements KeyListener {
        private Overlay fOverlay;
        private OverlayManager fOverlayManager;
        private PopupList fList;

        private SubListKeyListener(Overlay overlay, OverlayManager overlayManager, PopupList popupList) {
            this.fOverlay = overlay;
            this.fOverlayManager = overlayManager;
            this.fList = popupList;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 37) {
                this.fOverlayManager.removeOverlay(this.fOverlay);
                this.fList.requestFocusInWindow();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

