/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.JTextComponent;

class TextEventListener
extends MouseInputAdapter
implements FocusListener {
    private Component fComponentToRepaint;

    TextEventListener() {
    }

    void setComponentToRepaint(Component component) {
        this.fComponentToRepaint = component;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TextEventListener.updateBackground((JTextComponent)mouseEvent.getSource(), this.fComponentToRepaint);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
        jTextComponent.putClientProperty("mouse-is-over", true);
        TextEventListener.updateBackground(jTextComponent, this.fComponentToRepaint);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
        jTextComponent.putClientProperty("mouse-is-over", false);
        TextEventListener.updateBackground(jTextComponent, this.fComponentToRepaint);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        TextEventListener.updateBackground((JTextComponent)focusEvent.getComponent(), this.fComponentToRepaint);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        TextEventListener.updateBackground((JTextComponent)focusEvent.getComponent(), this.fComponentToRepaint);
    }

    static void updateBackground(JTextComponent jTextComponent) {
        TextEventListener.updateBackground(jTextComponent, jTextComponent);
    }

    static void updateBackground(JTextComponent jTextComponent, Component component) {
        Color color = jTextComponent.isEditable() ? (LAFUtil.isActive(jTextComponent) ? ToolstripTheme.getInstance().getTextActiveBackground() : ToolstripTheme.getInstance().getTextBackground()) : ToolstripTheme.getInstance().getTextDisabledBackground();
        jTextComponent.setBackground(color);
        if (component != null) {
            component.repaint();
        } else {
            jTextComponent.repaint();
        }
    }
}

