/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.TextEventListener;
import com.mathworks.toolstrip.plaf.ToolstripTextBorder;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class ToolstripSpinnerUI
extends BasicSpinnerUI {
    private CustomEventListener fEventListener;

    public static ToolstripSpinnerUI createUI(JComponent jComponent) {
        return new ToolstripSpinnerUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        this.spinner.setBorder(new ToolstripTextBorder(jFormattedTextField));
        this.spinner.setOpaque(true);
        jFormattedTextField.setFont(ToolstripTheme.getInstance().getTSTextFieldFont());
        jFormattedTextField.setSelectedTextColor(Color.BLACK);
        jFormattedTextField.setOpaque(true);
        this.fEventListener = new CustomEventListener();
        this.fEventListener.setComponentToRepaint(this.spinner);
        jFormattedTextField.addMouseListener(this.fEventListener);
        jFormattedTextField.addMouseMotionListener(this.fEventListener);
        jFormattedTextField.addFocusListener(this.fEventListener);
        jFormattedTextField.addActionListener(this.fEventListener);
        jFormattedTextField.addKeyListener(this.fEventListener);
        jFormattedTextField.addPropertyChangeListener(this.fEventListener);
        TextEventListener.updateBackground(jFormattedTextField);
        this.spinner.setBackground(jFormattedTextField.getBackground());
    }

    @Override
    protected void uninstallDefaults() {
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        jFormattedTextField.removeFocusListener(this.fEventListener);
        jFormattedTextField.removeMouseListener(this.fEventListener);
        jFormattedTextField.removeMouseMotionListener(this.fEventListener);
        jFormattedTextField.removeActionListener(this.fEventListener);
        jFormattedTextField.removeKeyListener(this.fEventListener);
        jFormattedTextField.removePropertyChangeListener(this.fEventListener);
        super.uninstallDefaults();
    }

    @Override
    protected Component createPreviousButton() {
        JButton jButton = this.createArrowButton(5);
        jButton.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(jButton);
        return jButton;
    }

    @Override
    protected Component createNextButton() {
        JButton jButton = this.createArrowButton(1);
        jButton.setName("Spinner.nextButton");
        this.installNextButtonListeners(jButton);
        return jButton;
    }

    private JButton createArrowButton(final int n) {
        JButton jButton = new JButton(){

            @Override
            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n3 = this.getWidth();
                int n2 = this.getHeight();
                Composite composite = null;
                if (!ToolstripSpinnerUI.this.spinner.isEnabled()) {
                    composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                AffineTransform affineTransform = null;
                if (n == 1) {
                    affineTransform = graphics2D.getTransform();
                    graphics2D.scale(1.0, -1.0);
                    graphics2D.translate(0, -n2);
                }
                LAFUtil.paintDarkTriangle(graphics2D, (n3 - 7) / 2, (n2 - 4) / 2);
                if (composite != null) {
                    graphics2D.setComposite(composite);
                }
                if (affineTransform != null) {
                    graphics2D.setTransform(affineTransform);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(14, 10);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        jButton.setOpaque(false);
        return jButton;
    }

    private class CustomEventListener
    extends TextEventListener
    implements KeyListener,
    ActionListener,
    PropertyChangeListener {
        private CustomEventListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                TSUtil.relinquishFocus(keyEvent.getComponent());
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                Component component = focusEvent.getComponent();
                component.dispatchEvent(new FocusEvent(component, 1004, false));
                component.dispatchEvent(new FocusEvent(component, 1005, false, focusEvent.getOppositeComponent()));
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getComponent();
            jTextField.selectAll();
            CustomEventListener.updateBackground(jTextField);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TSUtil.toolstripActionProcessed((Component)actionEvent.getSource());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("editable") || propertyChangeEvent.getPropertyName().equals("enabled") || propertyChangeEvent.getPropertyName().equals("mouse-is-over")) {
                JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)ToolstripSpinnerUI.this.spinner.getEditor()).getTextField();
                TextEventListener.updateBackground(jFormattedTextField, ToolstripSpinnerUI.this.spinner);
                ToolstripSpinnerUI.this.spinner.setBackground(jFormattedTextField.getBackground());
            }
        }
    }
}

