/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.sections;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.components.TSPriority;
import com.mathworks.toolstrip.components.VerticalAlignment;
import com.mathworks.toolstrip.plaf.LAFUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.EnumSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ColumnTSComponent
extends TSPanel {
    private final ImmutableList<TSComponent> fComponents;
    private VerticalAlignment fAlignment = VerticalAlignment.TOP;

    public ColumnTSComponent(Iterable<TSComponent> iterable) {
        this((ImmutableList<TSComponent>)ImmutableList.copyOf(iterable));
    }

    public ColumnTSComponent(TSComponent ... tSComponentArray) {
        this((ImmutableList<TSComponent>)ImmutableList.copyOf((Object[])tSComponentArray));
    }

    private ColumnTSComponent(ImmutableList<TSComponent> immutableList) {
        Preconditions.checkArgument((!immutableList.isEmpty() ? 1 : 0) != 0, (Object)"Column Component cannot take zero child components");
        Preconditions.checkArgument((immutableList.size() <= 3 ? 1 : 0) != 0, (Object)"Column Component cannot take more than three child components");
        this.fComponents = immutableList;
        this.setLayout(new MyLayoutManager2());
        TSPriority tSPriority = TSPriority.LOW;
        for (TSComponent tSComponent : immutableList) {
            TSPriority tSPriority2 = LAFUtil.getPriority(tSComponent);
            if (tSPriority2.ordinal() <= tSPriority.ordinal()) continue;
            tSPriority = tSPriority2;
        }
        LAFUtil.setPriority((JComponent)((Object)this), tSPriority);
    }

    @Override
    @NotNull
    public LayoutMode getSupportedLayoutMode() {
        EnumSet<LayoutMode.Property> enumSet = EnumSet.noneOf(LayoutMode.Property.class);
        for (TSComponent tSComponent : this.fComponents) {
            enumSet.addAll(tSComponent.getSupportedLayoutMode().getProperties());
        }
        enumSet.remove((Object)LayoutMode.Property.HORIZONTAL);
        enumSet.add(LayoutMode.Property.VERTICAL);
        return LayoutMode.of(enumSet);
    }

    @Override
    public int getPreferredWidth(@NotNull LayoutMode layoutMode, int n) {
        int n2 = 0;
        LayoutMode layoutMode2 = this.getChildrenLayoutMode(layoutMode);
        for (TSComponent tSComponent : this.fComponents) {
            n2 = Math.max(n2, tSComponent.getPreferredWidth(layoutMode2, n));
        }
        return n2;
    }

    private LayoutMode getChildrenLayoutMode(LayoutMode layoutMode) {
        return layoutMode == null ? LayoutMode.HORIZONTAL_LAYOUT : layoutMode.exclude(LayoutMode.Property.VERTICAL);
    }

    private LayoutMode getChildrenLayoutMode() {
        return this.getChildrenLayoutMode((LayoutMode)this.getClientProperty("toolstripLayoutMode"));
    }

    public ImmutableList<TSComponent> getChildren() {
        return this.fComponents;
    }

    public VerticalAlignment getAlignment() {
        return this.fAlignment;
    }

    public ColumnTSComponent setAlignment(VerticalAlignment verticalAlignment) {
        VerticalAlignment verticalAlignment2 = this.fAlignment;
        this.fAlignment = verticalAlignment;
        if (verticalAlignment2 != this.fAlignment) {
            this.revalidate();
            this.repaint();
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("TSColumn -> ").append(this.getChildrenLayoutMode()).append(" :\n");
        for (TSComponent tSComponent : this.fComponents) {
            stringBuilder.append("     ").append(tSComponent).append("\n");
        }
        return stringBuilder.toString();
    }

    private class MyLayoutManager2
    implements LayoutManager2 {
        private MyLayoutManager2() {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            this.addComponents();
            int n = 0;
            LayoutMode layoutMode = ColumnTSComponent.this.getChildrenLayoutMode();
            for (TSComponent tSComponent : ColumnTSComponent.this.fComponents) {
                n = Math.max(n, tSComponent.getPreferredWidth(layoutMode, container.getHeight()));
            }
            return new Dimension(n, container.getHeight());
        }

        private void addComponents() {
            if (ColumnTSComponent.this.getComponentCount() == 0) {
                for (TSComponent tSComponent : ColumnTSComponent.this.fComponents) {
                    ColumnTSComponent.this.add((Component)((Object)tSComponent));
                }
                int n = ColumnTSComponent.this.getComponentCount();
                Preconditions.checkState((n <= 3 ? 1 : 0) != 0, (String)"Column component cannot have more than three child components, but it has %s", (Object[])new Object[]{n});
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            this.addComponents();
            int n = container.getHeight();
            LayoutMode layoutMode = ColumnTSComponent.this.getChildrenLayoutMode();
            switch (ColumnTSComponent.this.fAlignment) {
                case BOTTOM: 
                case TOP: {
                    int n2 = n / 3;
                    for (int i = 0; i < ColumnTSComponent.this.fComponents.size(); ++i) {
                        TSComponent tSComponent = (TSComponent)ColumnTSComponent.this.fComponents.get(i);
                        LAFUtil.setLayoutMode(tSComponent, layoutMode);
                        int n3 = tSComponent.getPreferredWidth(layoutMode, container.getHeight());
                        Dimension dimension = ((Component)((Object)tSComponent)).getPreferredSize();
                        int n4 = ColumnTSComponent.this.fAlignment == VerticalAlignment.BOTTOM ? (i + (3 - ColumnTSComponent.this.fComponents.size())) * n2 + (n2 - dimension.height) / 2 : i * n2 + (n2 - dimension.height) / 2;
                        ((Component)((Object)tSComponent)).setBounds(0, n4, n3, dimension.height);
                    }
                    break;
                }
                case CENTER: {
                    int n5;
                    int n6 = 0;
                    for (TSComponent tSComponent : ColumnTSComponent.this.fComponents) {
                        LAFUtil.setLayoutMode(tSComponent, layoutMode);
                        Dimension dimension = ((Component)((Object)tSComponent)).getPreferredSize();
                        n6 += dimension.height;
                    }
                    int n7 = n5 = (n - n6) / (ColumnTSComponent.this.fComponents.size() + 1);
                    for (TSComponent tSComponent : ColumnTSComponent.this.fComponents) {
                        int n8 = tSComponent.getPreferredWidth(layoutMode, container.getHeight());
                        Dimension dimension = ((Component)((Object)tSComponent)).getPreferredSize();
                        ((Component)((Object)tSComponent)).setBounds(0, n7, n8, dimension.height);
                        n7 += n5 + dimension.height;
                    }
                    break;
                }
            }
        }
    }
}

