/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.truthtable;

import com.mathworks.toolbox.dastudio.truthtable.RowHeaderRenderer;
import com.mathworks.toolbox.dastudio.truthtable.TextAreaEditor;
import com.mathworks.toolbox.dastudio.truthtable.TextAreaRenderer;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class PredicateTableModel
extends AbstractTableModel {
    private int _numRows;
    private int _numCols;
    private Hashtable _data;
    private TableColumnModel _columnModel;
    private DefaultTableCellRenderer _defaultRenderer;
    private DefaultCellEditor _defaultEditor;

    public PredicateTableModel(String[][] stringArray) {
        this._numRows = stringArray.length;
        this._numCols = stringArray[0].length + 1;
        this._data = new Hashtable();
        for (int i = 0; i < this._numRows; ++i) {
            for (int j = 1; j < this._numCols; ++j) {
                this.setValueAt(stringArray[i][j - 1], i, j);
            }
        }
        this.initializeTableModel();
    }

    public PredicateTableModel(int n, int n2) {
        this._numRows = n >= 2 ? n : 2;
        this._numCols = n2 >= 4 ? n2 : 5;
        this._data = new Hashtable();
        this.initializeTableModel();
    }

    public PredicateTableModel() {
        this._numRows = 2;
        this._numCols = 5;
        this._data = new Hashtable();
        this.initializeTableModel();
    }

    private void initializeTableModel() {
        TextAreaRenderer textAreaRenderer = new TextAreaRenderer();
        TextAreaEditor textAreaEditor = new TextAreaEditor();
        this._columnModel = new DefaultTableColumnModel();
        this._defaultRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                return jLabel;
            }
        };
        this._defaultEditor = new DefaultCellEditor(new JTextField());
        TableColumn tableColumn = new TableColumn(0, 30, new RowHeaderRenderer(), null);
        tableColumn.setHeaderValue(" ");
        this._columnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 160, textAreaRenderer, textAreaEditor);
        tableColumn.setHeaderValue("Predicate Description");
        this._columnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 80, this._defaultRenderer, this._defaultEditor);
        tableColumn.setHeaderValue("Label");
        this._columnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 160, textAreaRenderer, textAreaEditor);
        tableColumn.setHeaderValue("Predicate Code");
        this._columnModel.addColumn(tableColumn);
        for (int i = 4; i < this._numCols; ++i) {
            tableColumn = new TableColumn(i, 50, this._defaultRenderer, this._defaultEditor);
            tableColumn.setHeaderValue("T" + (i - 3));
            this._columnModel.addColumn(tableColumn);
        }
        this.updateRowHeaderIndex(0);
        this.setValueAt(null, this._numRows - 1, 1);
        this.setValueAt(null, this._numRows - 1, 2);
        this.setValueAt("Action Labels", this._numRows - 1, 3);
    }

    public TableColumnModel getColumnModel() {
        return this._columnModel;
    }

    @Override
    public int getColumnCount() {
        return this._numCols;
    }

    @Override
    public int getRowCount() {
        return this._numRows;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= this._numCols) {
            System.out.println("Warning: getColumnName(idx), idx exceeds the max column index.");
            return null;
        }
        return (String)this._columnModel.getColumn(n).getHeaderValue();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._data.get(this.getHashKey(n, n2));
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            this._data.remove(this.getHashKey(n, n2));
            return;
        }
        String string = ((String)object).trim();
        if (string.length() > 0) {
            this._data.put(this.getHashKey(n, n2), string);
        } else {
            this._data.remove(this.getHashKey(n, n2));
        }
    }

    private Object getHashKey(int n, int n2) {
        return new String(n + "," + n2);
    }

    private void updateColumnHeaderIndex(int n) {
        for (int i = n; i < this._numCols; ++i) {
            TableColumn tableColumn = this._columnModel.getColumn(i);
            tableColumn.setModelIndex(i);
            tableColumn.setHeaderValue("T" + (i - 3));
        }
    }

    private void updateRowHeaderIndex(int n) {
        for (int i = n; i < this._numRows - 1; ++i) {
            this._data.put(this.getHashKey(i, 0), String.valueOf(i + 1));
        }
        this._data.put(this.getHashKey(this._numRows - 1, 0), "");
    }

    public void deleteColumn(int n) {
        if (n <= 3 || n >= this._numCols) {
            return;
        }
        this._columnModel.removeColumn(this._columnModel.getColumn(n));
        for (int i = 0; i < this._numRows; ++i) {
            this._data.remove(this.getHashKey(i, n));
            for (int j = n + 1; j < this._numCols; ++j) {
                Object v = this._data.remove(this.getHashKey(i, j));
                if (v == null) continue;
                this._data.put(this.getHashKey(i, j - 1), v);
            }
        }
        --this._numCols;
        this.updateColumnHeaderIndex(n);
        this.fireTableStructureChanged();
    }

    public void deleteRow(int n) {
        if (n >= this._numRows - 1 || n < 0) {
            return;
        }
        for (int i = 1; i < this._numCols; ++i) {
            this._data.remove(this.getHashKey(n, i));
            for (int j = n + 1; j < this._numRows; ++j) {
                Object v = this._data.remove(this.getHashKey(j, i));
                if (v == null) continue;
                this._data.put(this.getHashKey(j - 1, i), v);
            }
        }
        --this._numRows;
        this.updateRowHeaderIndex(n);
        this.fireTableRowsDeleted(this._numRows - 1, this._numRows - 1);
    }

    public void addColumn() {
        ++this._numCols;
        TableColumn tableColumn = new TableColumn(this._numCols - 1, 50, this._defaultRenderer, this._defaultEditor);
        tableColumn.setHeaderValue("T" + (this._numCols - 4));
        this._columnModel.addColumn(tableColumn);
        this.fireTableStructureChanged();
    }

    public void addColumn(int n) {
        if (n <= 3 || n >= this._numCols) {
            return;
        }
        for (int i = 0; i < this._numRows; ++i) {
            for (int j = this._numCols; j > n; --j) {
                Object v = this._data.remove(this.getHashKey(i, j - 1));
                if (v == null) continue;
                this._data.put(this.getHashKey(i, j), v);
            }
        }
        ++this._numCols;
        TableColumn tableColumn = new TableColumn(n, 50, this._defaultRenderer, this._defaultEditor);
        tableColumn.setHeaderValue("T" + n);
        this._columnModel.addColumn(tableColumn);
        this.updateColumnHeaderIndex(n + 1);
        this.fireTableStructureChanged();
    }

    public void addRow() {
        ++this._numRows;
        for (int i = 1; i < this._numCols; ++i) {
            Object v = this._data.remove(this.getHashKey(this._numRows - 2, i));
            if (v == null) continue;
            this._data.put(this.getHashKey(this._numRows - 1, i), v);
        }
        this.updateRowHeaderIndex(this._numRows - 2);
        this.fireTableRowsInserted(this._numRows - 2, this._numRows - 2);
    }

    public void addRow(int n) {
        if (n >= this._numRows || n < 0) {
            return;
        }
        for (int i = 1; i < this._numCols; ++i) {
            for (int j = this._numRows; j > n; --j) {
                Object v = this._data.remove(this.getHashKey(j - 1, i));
                if (v == null) continue;
                this._data.put(this.getHashKey(j, i), v);
            }
        }
        ++this._numRows;
        this.updateRowHeaderIndex(n);
        this.fireTableRowsInserted(n, n);
    }

    public void switchRow(int n, int n2) {
        if (n == n2 || n < 0 || n2 < 0 || n >= this._numRows - 1 || n2 >= this._numRows - 1) {
            return;
        }
        for (int i = 1; i < this._numCols; ++i) {
            Object object = this.getHashKey(n, i);
            Object object2 = this.getHashKey(n2, i);
            Object v = this._data.remove(object);
            Object v2 = this._data.remove(object2);
            if (v != null) {
                this._data.put(object2, v);
            }
            if (v2 == null) continue;
            this._data.put(object, v2);
        }
        this.fireTableRowsUpdated(n, n);
        this.fireTableRowsUpdated(n2, n2);
    }

    public void switchColumn(int n, int n2) {
        if (n == n2 || n <= 3 || n2 <= 3 || n >= this._numCols || n2 >= this._numCols) {
            return;
        }
        for (int i = 0; i < this._numRows; ++i) {
            Object object = this.getHashKey(i, n);
            Object object2 = this.getHashKey(i, n2);
            Object v = this._data.remove(object);
            Object v2 = this._data.remove(object2);
            if (v != null) {
                this._data.put(object2, v);
            }
            if (v2 == null) continue;
            this._data.put(object, v2);
        }
        this.fireTableDataChanged();
    }

    public Vector getRowData(int n) {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 1; i < this._numCols; ++i) {
            vector.addElement(this.getValueAt(n, i));
        }
        return vector;
    }

    public Vector getColumnData(int n) {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this._numRows; ++i) {
            vector.addElement(this.getValueAt(i, n));
        }
        return vector;
    }

    public void setRow(Vector vector, int n) {
        int n2 = vector.size();
        int n3 = n2 < this._numCols - 1 ? n2 : this._numCols - 1;
        for (int i = 0; i < n3; ++i) {
            Object e = vector.elementAt(i);
            if (e != null) {
                this.setValueAt(new String((String)e), n, i + 1);
                continue;
            }
            this.setValueAt(null, n, i + 1);
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void setColumn(Vector vector, int n) {
        Object e;
        int n2 = vector.size();
        int n3 = n2 < this._numRows ? n2 : this._numRows;
        for (int i = 0; i < n3 - 1; ++i) {
            e = vector.elementAt(i);
            if (e != null) {
                this.setValueAt(new String((String)e), i, n);
                continue;
            }
            this.setValueAt(null, i, n);
        }
        e = vector.elementAt(n2 - 1);
        if (e != null) {
            this.setValueAt(new String((String)e), this._numRows - 1, n);
        } else {
            this.setValueAt(null, this._numRows - 1, n);
        }
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0 && (n != this._numRows - 1 || n2 >= 4);
    }

    public String[][] getStringArray() {
        int n;
        int n2 = this.getValidRowCount();
        int n3 = this.getValidColumnCount();
        String[][] stringArray = new String[n2][n3];
        for (n = 0; n < n2 - 1; ++n) {
            for (int i = 0; i < n3; ++i) {
                stringArray[n][i] = (String)this.getValueAt(n, i + 1);
            }
        }
        for (n = 0; n < n3; ++n) {
            stringArray[n2 - 1][n] = (String)this.getValueAt(this._numRows - 1, n + 1);
        }
        return stringArray;
    }

    private int getValidRowCount() {
        int n = 1;
        for (int i = this._numRows - 2; i >= 0; --i) {
            boolean bl = false;
            for (int j = 1; j < this._numCols; ++j) {
                if (this.getValueAt(i, j) == null) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            n = i + 2;
            break;
        }
        return n;
    }

    private int getValidColumnCount() {
        int n = 3;
        for (int i = this._numCols - 1; i > 3; --i) {
            boolean bl = false;
            for (int j = 0; j < this._numCols; ++j) {
                if (this.getValueAt(j, i) == null) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            n = i;
            break;
        }
        return n;
    }

    public void makeCompact() {
        int n;
        int n2 = this.getValidRowCount();
        int n3 = this.getValidColumnCount();
        for (n = this._numRows - 2; n > n2 - 2; --n) {
            this.deleteRow(n);
        }
        for (n = this._numCols - 1; n > n3; --n) {
            this.deleteColumn(n);
        }
    }
}

