/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.DefaultHtmlTextWriter;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlTextWriter;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.StreamingTextUrlManager;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class AbstractStreamingTextHandler
implements StreamingTextUrlManager {
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final HtmlTextWriter fWriter;
    private final List<String> fHtmlTextList = new ArrayList<String>();
    private final List<Charset> fHtmlTextCharsets = new ArrayList<Charset>();
    private int fCurrentIndex = -1;

    protected AbstractStreamingTextHandler() {
        this(new DefaultHtmlTextWriter());
    }

    protected AbstractStreamingTextHandler(HtmlTextWriter htmlTextWriter) {
        this.fWriter = htmlTextWriter;
    }

    public void beforeSetHtmlText() {
        this.fWriter.beforeFirstWrite();
    }

    public void dispose() {
        this.fWriter.dispose();
    }

    public void setFileDir(File file) {
        this.fWriter.setHtmlTextDir(file);
    }

    protected HtmlWriteStatus writeHtmlForUrl(Url url) {
        int n = this.getIndexFromUrl(url);
        if (n < 0 || n >= this.fHtmlTextList.size() || n == this.fCurrentIndex) {
            return HtmlWriteStatus.NOT_HTML_URL;
        }
        String string = this.fHtmlTextList.get(n);
        Charset charset = this.fHtmlTextCharsets.get(n);
        try {
            this.fWriter.writeHtmlText(string, charset);
            this.fCurrentIndex = n;
            return HtmlWriteStatus.SUCCESS;
        }
        catch (IOException iOException) {
            this.fCurrentIndex = -1;
            this.handleWriteException(string);
            return HtmlWriteStatus.FAILURE;
        }
    }

    protected abstract void handleWriteException(String var1);

    public Url getHtmlTextUrl(String string) {
        String string2 = string;
        Charset charset = HtmlUtils.getCharsetFromHtml(string);
        if (charset == null) {
            string2 = HtmlUtils.addCharsetMetaTag(DEFAULT_CHARSET_NAME, string);
            charset = DEFAULT_CHARSET;
        }
        this.fHtmlTextList.add(string2);
        this.fHtmlTextCharsets.add(charset);
        return this.getUrlForIndex(this.fHtmlTextList.size() - 1);
    }

    @Override
    public FileUrl getUrlForIndex(int n) {
        UrlBuilder<FileUrl> urlBuilder = UrlBuilder.fromFile(this.getHtmlTextWriter().getHtmlTextFile());
        urlBuilder.setParameter(String.valueOf(n), new String[0]);
        return urlBuilder.toUrl();
    }

    @Override
    public int getIndexFromUrl(Url url) {
        File file;
        if (url != null && url.getType() == Url.UrlType.FILE && this.isStreamingTextFile(file = ((FileUrl)url).getFile())) {
            return AbstractStreamingTextHandler.getIndexFromStreamingTextFileUrl(url);
        }
        return -1;
    }

    public HtmlTextWriter getHtmlTextWriter() {
        return this.fWriter;
    }

    public boolean isStreamingTextFile(File file) {
        return file.equals(this.getHtmlTextWriter().getHtmlTextFile());
    }

    private static int getIndexFromStreamingTextFileUrl(Url url) {
        Set<String> set = url.getParameters().keySet();
        for (String string : set) {
            if (!string.matches("\\d+")) continue;
            return Integer.parseInt(string);
        }
        return 0;
    }

    public int getLastIndex() {
        return this.fHtmlTextList.size() - 1;
    }

    public static enum HtmlWriteStatus {
        SUCCESS,
        NOT_HTML_URL,
        FAILURE;

    }
}

