/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.Url;
import java.net.MalformedURLException;
import java.util.Collection;

public class BrowserRequest {
    private final Origin fOrigin;
    private final Url fUrl;
    private final Url fPreviousUrl;

    public BrowserRequest(Origin origin, String string, String string2) throws MalformedURLException {
        this(origin, Url.parse(string), Url.parse(string2));
    }

    public BrowserRequest(Origin origin, Url url, Url url2) {
        this.fOrigin = origin;
        this.fUrl = url;
        this.fPreviousUrl = url2;
    }

    public Origin getOrigin() {
        return this.fOrigin;
    }

    public Url getUrl() {
        return this.fUrl;
    }

    public Url getPreviousUrl() {
        return this.fPreviousUrl;
    }

    public Collection<Url.UrlPart> getChangedUrlParts() {
        return Url.diff(this.fPreviousUrl, this.fUrl);
    }

    public boolean isChangeOfUrlParts(Url.UrlPart ... urlPartArray) {
        return Url.isUrlChangeOfParts(this.fPreviousUrl, this.fUrl, urlPartArray);
    }

    public int hashCode() {
        return this.fUrl.hashCode() + this.fOrigin.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof BrowserRequest) {
            BrowserRequest browserRequest = (BrowserRequest)object;
            return browserRequest.getUrl().equals(this.getUrl()) && browserRequest.getOrigin() == this.getOrigin();
        }
        return false;
    }

    public static enum Origin {
        SET_LOCATION,
        SET_HTML_TEXT,
        GO_BACK,
        GO_FORWARD,
        REFRESH,
        USER_INTERACTION;

    }
}

