/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlVisitor;
import com.mathworks.html.WebUrl;

public abstract class UrlTransformer<T> {
    public T transformUrl(Url url) {
        TransformerVisitor transformerVisitor = new TransformerVisitor();
        url.accept(transformerVisitor);
        return (T)transformerVisitor.getTransformedValue();
    }

    protected abstract T transformWebUrl(WebUrl var1);

    protected abstract T transformFileUrl(FileUrl var1);

    protected abstract T transformCustomProtocolUrl(CustomProtocolUrl var1);

    private class TransformerVisitor
    implements UrlVisitor {
        private T iTransformedValue = null;

        private TransformerVisitor() {
        }

        @Override
        public void visitFileUrl(FileUrl fileUrl) {
            this.iTransformedValue = UrlTransformer.this.transformFileUrl(fileUrl);
        }

        @Override
        public void visitWebUrl(WebUrl webUrl) {
            this.iTransformedValue = UrlTransformer.this.transformWebUrl(webUrl);
        }

        @Override
        public void visitCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            this.iTransformedValue = UrlTransformer.this.transformCustomProtocolUrl(customProtocolUrl);
        }

        private T getTransformedValue() {
            return this.iTransformedValue;
        }
    }
}

