/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserQueue;
import com.mathworks.html.BrowserSettings;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.SystemUtils;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserFactory;
import com.teamdev.jxbrowser.BrowserType;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;

class BrowserBuilder {
    private static final BrowserType DEFAULT_BROWSER_TYPE = BrowserBuilder.determineDefaultBrowserType();
    private static final String JXBROWSER_DIR_NAME = ".JxBrowser";
    private static final String MOZILLA_EXTRACT_PROPERTY = "jxbrowser.xulrunner.dir";

    private BrowserBuilder() {
    }

    private static BrowserType determineDefaultBrowserType() {
        if (SystemUtils.is64Bit() && BrowserType.getPlatformSpecificBrowser().equals(BrowserType.IE)) {
            return BrowserType.IE;
        }
        if (SystemUtils.isLinux()) {
            return BrowserType.Mozilla;
        }
        if (BrowserType.getPlatformSpecificBrowser().equals(BrowserType.Safari)) {
            return BrowserType.Safari;
        }
        return BrowserType.Mozilla15;
    }

    static Browser createBrowser() {
        for (int i = 4; i >= 0; --i) {
            Browser browser = BrowserBuilder.createBrowser(false);
            if (browser != null) {
                return browser;
            }
            if (i <= 0) continue;
            BrowserBuilder.pause(200L);
        }
        return null;
    }

    private static Browser createBrowser(boolean bl) {
        final BrowserType browserType = BrowserBuilder.determineBrowserType();
        try {
            BrowserBuilder.prepareBrowserFactory(browserType);
            return BrowserQueue.invokeAndReturn(new Callable<Browser>(){

                @Override
                public Browser call() throws Exception {
                    return BrowserFactory.createBrowser((BrowserType)browserType);
                }
            });
        }
        catch (Throwable throwable) {
            if (bl) assert (false) : BrowserBuilder.displayFailure(throwable);
            return null;
        }
    }

    private static BrowserType determineBrowserType() {
        BrowserType browserType = BrowserBuilder.getBrowserTypeFromSetting();
        if (browserType != null) {
            if (browserType.isSupported()) {
                return browserType;
            }
            System.out.println("User-specified browser type \"" + browserType.getName() + "\" is unsupported.");
            System.out.println("Using default browser type of \"" + DEFAULT_BROWSER_TYPE.getName() + "\"");
        }
        return DEFAULT_BROWSER_TYPE;
    }

    private static BrowserType getBrowserTypeFromSetting() {
        String string = BrowserSettings.getProperty("JxBrowser.BrowserType");
        try {
            BrowserHolder.Type type = BrowserHolder.Type.valueOf(string);
            return type == null ? null : type.getBrowserType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void prepareBrowserFactory(BrowserType browserType) {
        if (browserType.equals(BrowserType.Mozilla)) {
            BrowserBuilder.prepareMozilla();
        }
    }

    private static void prepareMozilla() {
        File file = BrowserBuilder.getMozillaDirectory();
        if (file != null) {
            try {
                String string = file.getCanonicalPath();
                System.setProperty(MOZILLA_EXTRACT_PROPERTY, string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static File getMozillaDirectory() {
        File file;
        File file2 = HtmlPanel.getResourceDirectory();
        if (file2 != null && ((file = new File(file2, JXBROWSER_DIR_NAME)).exists() || file.mkdirs()) && file.canWrite()) {
            return file;
        }
        return null;
    }

    private static String displayFailure(Throwable throwable) {
        throwable.printStackTrace();
        return "Failed to create JxBrowser instance.";
    }

    private static void pause(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void cleanupTempDir() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        File file2 = new File(file, "jxbrowser.Build.Unknown");
        if (file2.exists() && file2.isDirectory()) {
            try {
                BrowserBuilder.deleteRecursively(file2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static boolean deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (BrowserBuilder.deleteRecursively(file2)) continue;
                return false;
            }
        }
        return file.delete();
    }

    static {
        BrowserBuilder.cleanupTempDir();
    }
}

