/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserNavigator;
import com.mathworks.html.BrowserQueue;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.EncodingUtils;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlPanelLoadFailureHandlerMap;
import com.mathworks.html.LoadFailure;
import com.mathworks.html.LoadFailureHandlerMap;
import com.mathworks.html.PageLoadFailureHandler;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.CommonBrowserCallable;
import com.mathworks.html.jxbrowser.CommonBrowserRunnable;
import com.mathworks.html.jxbrowser.RequestHandlerPolicyDelegate;
import com.mathworks.html.jxbrowser.StreamingTextHandler;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.events.NavigationAdapter;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import java.io.File;
import java.net.MalformedURLException;
import java.nio.charset.Charset;

public class JxBrowserNavigator
implements BrowserNavigator {
    private final BrowserHolder fBrowser;
    private final StreamingTextHandler fTextHandler;
    private final RequestHandlerPolicyDelegate fRequestHandlerDelegate;
    private final CurrentLocationListener fCurrentLocation = new CurrentLocationListener();
    private final HtmlPanelLoadFailureHandlerMap fLoadFailureHandlerMap = new HtmlPanelLoadFailureHandlerMap();

    public JxBrowserNavigator(BrowserHolder browserHolder, StreamingTextHandler streamingTextHandler, RequestHandlerPolicyDelegate requestHandlerPolicyDelegate) {
        this.fBrowser = browserHolder;
        this.fTextHandler = streamingTextHandler;
        this.fRequestHandlerDelegate = requestHandlerPolicyDelegate;
        browserHolder.invokeLater(new CommonBrowserRunnable(){

            @Override
            public void handleBrowser(Browser browser) {
                browser.addNavigationListener((NavigationListener)JxBrowserNavigator.this.fCurrentLocation);
            }
        });
    }

    public NavigationListener getCurrentLocationListener() {
        return this.fCurrentLocation;
    }

    @Override
    public void setHtmlText(String string) {
        this.fTextHandler.beforeSetHtmlText();
        Url url = this.fTextHandler.getHtmlTextUrl(string);
        this.setCurrentLocation(url.toString(), BrowserRequest.Origin.SET_HTML_TEXT);
    }

    @Override
    public void setCurrentLocation(String string) {
        this.setCurrentLocation(string, BrowserRequest.Origin.SET_LOCATION);
    }

    private void setCurrentLocation(final String string, BrowserRequest.Origin origin) {
        try {
            Url url = Url.parse(string);
            this.setCurrentLocation(url, origin);
        }
        catch (MalformedURLException malformedURLException) {
            this.fRequestHandlerDelegate.setPendingRequest(null, origin);
            this.fBrowser.invokeLater(new CommonBrowserRunnable(){

                @Override
                public void handleBrowser(Browser browser) {
                    browser.stop();
                    browser.navigate(string);
                }
            });
        }
    }

    @Override
    public void setCurrentLocation(Url url) {
        this.setCurrentLocation(url, BrowserRequest.Origin.SET_LOCATION);
    }

    private void setCurrentLocation(Url url, BrowserRequest.Origin origin) {
        FileExistsTransformer fileExistsTransformer = new FileExistsTransformer();
        if (!((Boolean)fileExistsTransformer.transformUrl(url)).booleanValue()) {
            this.doFileNotFound(url);
            return;
        }
        this.fBrowser.invokeLater(new SetLocationRunnable(url, origin));
    }

    protected boolean fileExists(File file) {
        return file.exists();
    }

    @Override
    public Url getCurrentLocation() {
        if (BrowserQueue.isBrowserThread()) {
            Url url = this.fBrowser.invokeAndReturn(new CommonBrowserCallable<Url>(){

                @Override
                public Url handleBrowser(Browser browser) {
                    return JxBrowserNavigator.getCurrentLocationFromBrowser(browser);
                }
            }, null);
            this.fCurrentLocation.setCurrentUrl(url);
            return url;
        }
        return this.fCurrentLocation.getCurrentUrl();
    }

    private static Url getCurrentLocationFromBrowser(Browser browser) {
        String string = browser.getCurrentLocation();
        if (browser.getType().equals(BrowserType.IE)) {
            string = EncodingUtils.changeUrlEncoding(string, Charset.defaultCharset().displayName(), "UTF-8");
        }
        return Url.parseSilently(string);
    }

    @Override
    public boolean canGoBack() {
        return this.fBrowser.invokeAndReturn(new CommonBrowserCallable<Boolean>(){

            @Override
            public Boolean handleBrowser(Browser browser) {
                return browser.canGoBack();
            }
        }, false);
    }

    @Override
    public void goBack() {
        this.fBrowser.invokeLater(new CommonBrowserRunnable(){

            @Override
            public void handleBrowser(Browser browser) {
                JxBrowserNavigator.this.fRequestHandlerDelegate.setPendingRequest(null, BrowserRequest.Origin.GO_BACK);
                browser.goBack();
            }
        });
    }

    @Override
    public boolean canGoForward() {
        return this.fBrowser.invokeAndReturn(new CommonBrowserCallable<Boolean>(){

            @Override
            public Boolean handleBrowser(Browser browser) {
                return browser.canGoForward();
            }
        }, false);
    }

    @Override
    public void goForward() {
        this.fBrowser.invokeLater(new CommonBrowserRunnable(){

            @Override
            public void handleBrowser(Browser browser) {
                JxBrowserNavigator.this.fRequestHandlerDelegate.setPendingRequest(null, BrowserRequest.Origin.GO_FORWARD);
                browser.goForward();
            }
        });
    }

    @Override
    public void reload() {
        this.fBrowser.invokeLater(new CommonBrowserRunnable(){

            @Override
            public void handleBrowser(Browser browser) {
                JxBrowserNavigator.this.fRequestHandlerDelegate.setPendingRequest(null, BrowserRequest.Origin.REFRESH);
                browser.refresh();
            }
        });
    }

    @Override
    public void addLoadFailureHandlers(LoadFailureHandlerMap loadFailureHandlerMap) {
        this.fLoadFailureHandlerMap.addOverrides(loadFailureHandlerMap);
    }

    protected void doFileNotFound(Url url) {
        PageLoadFailureHandler pageLoadFailureHandler = this.fLoadFailureHandlerMap.getHandler(LoadFailure.PAGE_NOT_FOUND);
        pageLoadFailureHandler.handleLoadFailure(LoadFailure.PAGE_NOT_FOUND, this, url);
    }

    private static class IEUrlCorrector
    extends UrlTransformer<String> {
        private IEUrlCorrector() {
        }

        @Override
        protected String transformWebUrl(WebUrl webUrl) {
            return webUrl.toString();
        }

        @Override
        protected String transformFileUrl(FileUrl fileUrl) {
            String string;
            StringBuilder stringBuilder = new StringBuilder(EncodingUtils.decodeUrl(fileUrl.getBaseUrl()));
            String string2 = fileUrl.getQueryString();
            if (string2 != null && !string2.isEmpty()) {
                stringBuilder.append('?').append(string2);
            }
            if ((string = fileUrl.getTarget()) != null && !string.isEmpty()) {
                stringBuilder.append('#').append(string);
            }
            return stringBuilder.toString();
        }

        @Override
        protected String transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return customProtocolUrl.toString();
        }
    }

    private class FileExistsTransformer
    extends UrlTransformer<Boolean> {
        private FileExistsTransformer() {
        }

        @Override
        protected Boolean transformWebUrl(WebUrl webUrl) {
            return true;
        }

        @Override
        protected Boolean transformFileUrl(FileUrl fileUrl) {
            File file = fileUrl.getFile();
            return JxBrowserNavigator.this.fileExists(file) || JxBrowserNavigator.this.fTextHandler.isStreamingTextFile(file);
        }

        @Override
        protected Boolean transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return true;
        }
    }

    private class SetLocationRunnable
    extends CommonBrowserRunnable {
        private final Url iUrl;
        private final BrowserRequest.Origin iOrigin;

        private SetLocationRunnable(Url url, BrowserRequest.Origin origin) {
            this.iUrl = url;
            this.iOrigin = origin;
        }

        @Override
        public void handleBrowser(Browser browser) {
            JxBrowserNavigator.this.fRequestHandlerDelegate.setPendingRequest(this.iUrl, this.iOrigin);
            if (JxBrowserNavigator.this.fBrowser.getType() != BrowserHolder.Type.Mozilla) {
                browser.stop();
            }
            browser.navigate(this.getUrlForNavigation());
        }

        private String getUrlForNavigation() {
            if (JxBrowserNavigator.this.fBrowser.getType() == BrowserHolder.Type.IE) {
                return (String)new IEUrlCorrector().transformUrl(this.iUrl);
            }
            return this.iUrl.toString();
        }
    }

    private class CurrentLocationListener
    extends NavigationAdapter {
        private Url fCurrentUrl;

        private CurrentLocationListener() {
        }

        public void navigationFinished(NavigationFinishedEvent navigationFinishedEvent) {
            this.updateCurrentUrl();
        }

        private void updateCurrentUrl() {
            JxBrowserNavigator.this.fBrowser.invokeLater(new CommonBrowserRunnable(){

                @Override
                public void handleBrowser(Browser browser) {
                    CurrentLocationListener.this.setCurrentUrl(JxBrowserNavigator.getCurrentLocationFromBrowser(browser));
                }
            });
        }

        private synchronized void setCurrentUrl(Url url) {
            this.fCurrentUrl = url;
        }

        private synchronized Url getCurrentUrl() {
            return this.fCurrentUrl;
        }
    }
}

