/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserSettings;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.MWPromptService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class JxBrowserSettings
extends BrowserSettings {
    private static final JxBrowserSettings SINGLETON = new JxBrowserSettings();
    static final String BROWSER_TYPE = "JxBrowser.BrowserType";
    static final String JAVASCRIPT_ERROR_HANDLER = "JxBrowser.JavaScriptErrors";
    private static final Map<String, Collection<String>> SUPPORTED_PROPERTIES = JxBrowserSettings.buildSupportedProperties();

    private JxBrowserSettings() {
    }

    public static JxBrowserSettings getInstance() {
        return SINGLETON;
    }

    private static Map<String, Collection<String>> buildSupportedProperties() {
        LinkedHashMap<String, Collection<String>> linkedHashMap = new LinkedHashMap<String, Collection<String>>();
        linkedHashMap.put(BROWSER_TYPE, JxBrowserSettings.getBrowserTypeValues());
        linkedHashMap.put(JAVASCRIPT_ERROR_HANDLER, JxBrowserSettings.getJavaScriptErrorValues());
        return linkedHashMap;
    }

    public static boolean setDefaultBrowserType(BrowserHolder.Type type) {
        if (type.getBrowserType().isSupported()) {
            BrowserSettings.setProperty(BROWSER_TYPE, type.toString());
            return true;
        }
        return false;
    }

    @Override
    protected Map<String, Collection<String>> getSupportedProperties() {
        return Collections.unmodifiableMap(SUPPORTED_PROPERTIES);
    }

    private static Collection<String> getBrowserTypeValues() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (BrowserHolder.Type type : BrowserHolder.Type.values()) {
            if (!type.getBrowserType().isSupported()) continue;
            linkedList.add(type.toString());
        }
        return Collections.unmodifiableList(linkedList);
    }

    private static Collection<String> getJavaScriptErrorValues() {
        ArrayList<String> arrayList = new ArrayList<String>(MWPromptService.JavaScriptHandler.values().length);
        for (MWPromptService.JavaScriptHandler javaScriptHandler : MWPromptService.JavaScriptHandler.values()) {
            arrayList.add(javaScriptHandler.name());
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

