/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.Browser;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class BrowserFocusListener
extends FocusAdapter {
    private final Browser fBrowser;
    private volatile Runnable fPendingRequest;

    BrowserFocusListener(Browser browser) {
        this.fBrowser = browser;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        boolean bl = this.doFocusRequest();
        if (!bl) {
            this.fPendingRequest = new Runnable(){

                @Override
                public void run() {
                    if (BrowserFocusListener.this.fPendingRequest != null && BrowserFocusListener.this.fPendingRequest.equals(this)) {
                        BrowserFocusListener.this.doFocusRequest();
                        BrowserFocusListener.this.fPendingRequest = null;
                    }
                }
            };
            SwingUtilities.invokeLater(this.fPendingRequest);
        }
    }

    private boolean doFocusRequest() {
        JComponent jComponent = this.fBrowser.getView().getComponent();
        Component[] componentArray = jComponent.getComponents();
        if (componentArray != null && componentArray.length > 0) {
            componentArray[0].requestFocusInWindow();
            return true;
        }
        return false;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.fPendingRequest != null) {
            this.fPendingRequest = null;
        }
    }
}

