/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.HtmlActionGroup;
import com.teamdev.jxbrowser.chromium.Browser;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

class ZoomActions {
    private final ResourceBundle fResBundle = ResourceBundle.getBundle("com.mathworks.html.resources.RES_HtmlPanel");
    private final Browser fBrowser;
    private final HtmlActionGroup fActionGroup;

    ZoomActions(Browser browser) {
        this.fBrowser = browser;
        this.fActionGroup = this.createZoomActionGroup();
    }

    HtmlActionGroup getZoomActionGroup() {
        return this.fActionGroup;
    }

    private HtmlActionGroup createZoomActionGroup() {
        Map<String, Action> map = this.createZoomActions();
        return new HtmlActionGroup("ZoomActions", map);
    }

    private Map<String, Action> createZoomActions() {
        HashMap<String, Action> hashMap = new HashMap<String, Action>();
        ZoomInAction zoomInAction = new ZoomInAction(this.getLabel("ZoomIn"));
        ZoomOutAction zoomOutAction = new ZoomOutAction(this.getLabel("ZoomOut"));
        hashMap.put("ZoomIn", zoomInAction);
        hashMap.put("ZoomOut", zoomOutAction);
        return hashMap;
    }

    private String getLabel(String string) {
        return this.fResBundle.getString("action.label." + string.toLowerCase(Locale.ENGLISH));
    }

    private class ZoomOutAction
    extends AbstractAction {
        private ZoomOutAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ZoomActions.this.fBrowser.zoomOut();
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        private ZoomInAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ZoomActions.this.fBrowser.zoomIn();
        }
    }
}

