/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium.console;

import com.mathworks.html.jxbrowser.chromium.console.ConsoleMessagePart;
import com.mathworks.html.jxbrowser.chromium.console.DialogConsoleHandler;
import com.mathworks.html.jxbrowser.chromium.console.FileConsoleHandler;
import com.mathworks.html.jxbrowser.chromium.console.JavaScriptConsoleHandler;
import com.mathworks.html.jxbrowser.chromium.console.PrintStreamConsoleHandler;
import com.teamdev.jxbrowser.chromium.events.ConsoleEvent;
import com.teamdev.jxbrowser.chromium.events.ConsoleListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum JavaScriptConsole implements ConsoleListener
{
    INSTANCE;

    private Level fLevel = Level.DEBUG;
    private MessageFormat fMessageFormat = JavaScriptConsole.convertFormatString("{TIMESTAMP} {LEVEL} - {SOURCE} (Line {LINE}) - {MESSAGE}");
    private JavaScriptConsoleHandler fHandler = null;

    public static JavaScriptConsole getInstance() {
        return INSTANCE;
    }

    public void onMessage(ConsoleEvent consoleEvent) {
        if (this.fHandler != null && this.checkLevel(consoleEvent.getLevel())) {
            String string = this.getLogString(consoleEvent);
            this.fHandler.log(string);
        }
    }

    private boolean checkLevel(ConsoleEvent.Level level) {
        Level level2 = JavaScriptConsole.adaptLevel(level);
        return this.fLevel.ordinal() <= level2.ordinal();
    }

    static Level adaptLevel(ConsoleEvent.Level level) {
        switch (level) {
            case DEBUG: {
                return Level.DEBUG;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        return Level.DEBUG;
    }

    private String getLogString(ConsoleEvent consoleEvent) {
        if (this.fMessageFormat == null) {
            return consoleEvent.toString();
        }
        Object[] objectArray = new Object[ConsoleMessagePart.values().length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = ConsoleMessagePart.values()[i].fromConsoleEvent(consoleEvent);
        }
        return this.fMessageFormat.format(objectArray);
    }

    private void setInstanceLevel(Level level) {
        if (this.fLevel != level) {
            this.fLevel = level;
            if (this.fHandler != null) {
                this.fHandler.settingsChanged();
            }
        }
    }

    private Level getInstanceLevel() {
        return this.fLevel;
    }

    private void setInstanceHandler(JavaScriptConsoleHandler javaScriptConsoleHandler) {
        if (this.fHandler != null) {
            this.fHandler.dispose();
        }
        this.fHandler = javaScriptConsoleHandler;
    }

    private void setInstanceFormat(MessageFormat messageFormat) {
        if (!this.fMessageFormat.equals(messageFormat)) {
            this.fMessageFormat = messageFormat;
            if (this.fHandler != null) {
                this.fHandler.settingsChanged();
            }
        }
    }

    private MessageFormat getInstanceFormat() {
        return this.fMessageFormat;
    }

    public static void setLevel(Level level) {
        INSTANCE.setInstanceLevel(level);
    }

    public static void setLevel(String string) {
        JavaScriptConsole.setLevel(Level.valueOf(string.toUpperCase(Locale.ENGLISH)));
    }

    static Level getLevel() {
        return INSTANCE.getInstanceLevel();
    }

    public static void setHandler(JavaScriptConsoleHandler javaScriptConsoleHandler) {
        INSTANCE.setInstanceHandler(javaScriptConsoleHandler);
    }

    public static void setFormat(String string) {
        if (string == null || string.isEmpty()) {
            INSTANCE.setInstanceFormat(null);
        } else {
            MessageFormat messageFormat = JavaScriptConsole.convertFormatString(string);
            INSTANCE.setInstanceFormat(messageFormat);
        }
    }

    public static void useDialog() {
        JavaScriptConsole.setHandler(new DialogConsoleHandler());
    }

    public static void useSystemOut() {
        JavaScriptConsole.setHandler(new PrintStreamConsoleHandler());
    }

    public static void usePrintStream(PrintStream printStream) {
        JavaScriptConsole.setHandler(new PrintStreamConsoleHandler(printStream));
    }

    public static void useFile(File file) throws IOException {
        JavaScriptConsole.setHandler(new FileConsoleHandler(file));
    }

    public static void useFile(String string) throws IOException {
        JavaScriptConsole.useFile(new File(string));
    }

    private static MessageFormat convertFormatString(String string) {
        String string2 = string;
        for (ConsoleMessagePart consoleMessagePart : ConsoleMessagePart.values()) {
            string2 = string2.replaceAll(Pattern.quote("{" + consoleMessagePart.toString() + "}"), Matcher.quoteReplacement("{" + consoleMessagePart.ordinal() + "}"));
        }
        return new MessageFormat(string2);
    }

    static String getFormat() {
        String string = INSTANCE.getInstanceFormat().toPattern();
        for (ConsoleMessagePart consoleMessagePart : ConsoleMessagePart.values()) {
            string = string.replaceAll(Pattern.quote("{" + consoleMessagePart.ordinal() + "}"), Matcher.quoteReplacement("{" + consoleMessagePart.toString() + "}"));
        }
        return string;
    }

    public static String help() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Convenience methods for setting up the console:\n");
        stringBuilder.append("\tuseSystemOut() - prints console messages to System.out\n");
        stringBuilder.append("\tuseDialog() - opens a dialog that can be used to view and control the console log\n");
        stringBuilder.append("\tuseFile(File), useFile(String) - writes console messages to the specified file\n");
        stringBuilder.append("\tusePrintStream(PrintStream) - writes console messages to the specified print stream\n");
        stringBuilder.append('\n');
        stringBuilder.append("Use setLevel(String) to set the level of messages written to the log. The levels are:\n");
        for (Level enum_ : Level.values()) {
            stringBuilder.append('\t').append(enum_.toString()).append('\n');
        }
        stringBuilder.append('\n');
        stringBuilder.append("Use setFormat(String) to set the format of the console messages.\n");
        stringBuilder.append("Placeholders in the message format are:\n");
        for (Enum enum_ : ConsoleMessagePart.values()) {
            stringBuilder.append("\t{").append(enum_.toString()).append("} - ").append(((ConsoleMessagePart)enum_).getDescription()).append('\n');
        }
        return stringBuilder.toString();
    }

    public static enum Level {
        DEBUG,
        WARNING,
        ERROR;

    }
}

