/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class Offscreen {
    public static boolean sDebug = false;
    private static int sDepth;
    private static int sWidth;
    private static int sHeight;
    private static Image sImage;
    private static Graphics sGraphics;
    private Component fComponent;
    private Dimension fComponentSize;
    private int fRender;

    private static synchronized void releaseResources() {
        if (sGraphics != null) {
            sGraphics.dispose();
            sGraphics = null;
        }
        if (sImage != null) {
            sImage.flush();
            sImage = null;
        }
    }

    public static boolean isRendering() {
        return sDepth > 0;
    }

    public Offscreen(Component component) {
        this.fComponent = component;
    }

    public synchronized Graphics startRender(Graphics graphics) {
        Rectangle rectangle;
        if (sDebug) {
            this.acquire();
        }
        if (++sDepth > 1) {
            return graphics;
        }
        this.fComponentSize = this.fComponent.getSize();
        if (sImage == null || this.fComponentSize.width > sWidth || this.fComponentSize.height > sHeight) {
            Offscreen.releaseResources();
            sWidth = Math.max(this.fComponentSize.width, sWidth);
            sHeight = Math.max(this.fComponentSize.height, sHeight);
            if (sDebug) {
                System.out.println("resizing offscreen to " + sWidth + ", " + sHeight);
            }
            if ((sImage = this.fComponent.createImage(sWidth, sHeight)) == null) {
                --sDepth;
                if (sDebug) {
                    this.release();
                }
                return null;
            }
            sGraphics = sImage.getGraphics();
        }
        if ((rectangle = graphics.getClipBounds()) != null) {
            sGraphics.setClip(rectangle);
        } else {
            sGraphics.setClip(0, 0, sWidth, sHeight);
        }
        return sGraphics;
    }

    public synchronized void finishRender(Graphics graphics) {
        if (--sDepth == 0) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, this.fComponentSize.width, this.fComponentSize.height);
            }
            graphics.drawImage(sImage, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, this.fComponent);
        }
        if (sDebug) {
            this.release();
        }
    }

    private void acquire() {
        if (this.fRender > 0) {
            System.out.println("startRender re-entered " + this.fRender);
        }
        ++this.fRender;
    }

    private void release() {
        --this.fRender;
    }
}

