/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.appdesigner;

import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.util.PlatformInfo;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;

public class AppDesignerDebugServices {
    public static void addDebugAdapter() {
        MatlabDebugServices.addDefaultObserverListener((MatlabDebugObserver)new MatlabDebugAdapter(){

            public void doDBStop(String string, int n) {
                AppDesignerDebugServices.breakPointHit(string, n);
            }

            public void doWorkspaceChange(MatlabDebugServices.StackInfo stackInfo) {
                String string = stackInfo.getFullFilenames()[stackInfo.getCurrentEntryIndex()];
                int n = stackInfo.getLineNumbers()[stackInfo.getCurrentEntryIndex()];
                AppDesignerDebugServices.breakPointHit(string, n);
            }

            public void doDBQuit() {
                HashMap hashMap = new HashMap();
                MessageServiceFactory.getMessageService().publish("/appdesigner/breakpoint/dbquit", hashMap);
            }
        });
    }

    private static boolean isMlappFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return FilenameUtils.isExtension((String)string, (String)"mlapp");
    }

    private static void breakPointHit(String string, int n) {
        if (AppDesignerDebugServices.isMlappFile(string)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("fileName", string);
            hashMap.put("lineNumber", Integer.toString(n));
            MessageServiceFactory.getMessageService().publish("/appdesigner/breakpoint/hit", hashMap);
        }
    }
}

