/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdhist.AltHistory;
import com.mathworks.mde.cmdwin.CWDragDropImpl;
import com.mathworks.mde.cmdwin.CWMWMouseDragGestureRecognizer;
import com.mathworks.mde.cmdwin.CmdWin;
import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinEditorKit;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mde.cmdwin.CmdWinPrintUtils;
import com.mathworks.mde.cmdwin.CmdWinPrinterPageSetup;
import com.mathworks.mde.cmdwin.CmdWinStatusBar;
import com.mathworks.mde.cmdwin.CmdWinSyntaxUI;
import com.mathworks.mde.cmdwin.CmdWinUndoManager;
import com.mathworks.mde.cmdwin.FunctionBrowserRowHeader;
import com.mathworks.mde.cmdwin.Prompt;
import com.mathworks.mde.cmdwin.TokenMatcher;
import com.mathworks.mde.cmdwin.XCaret;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlservices.MLExecutionEvent;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MMouseEvent;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.datatransfer.AutoScroller;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.Assert;
import com.mathworks.util.Log;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.TextPrintPanel;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.desk.DTChildAction;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindEvent;
import com.mathworks.widgets.find.FindParentListener;
import com.mathworks.widgets.incSearch.IncSearch;
import com.mathworks.widgets.incSearch.IncSearchData;
import com.mathworks.widgets.incSearch.IncSearchInterface;
import com.mathworks.widgets.text.print.PrintSettings;
import com.mathworks.widgets.text.print.PrintUtils;
import com.mathworks.widgets.text.print.TextPrintable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class XCmdWndView
extends JTextArea
implements Autoscroll,
IncSearchInterface,
MLExecutionListener {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdwin.resources.RES_CmdWin");
    private static ResourceBundle sMLRes = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop");
    private static CmdWinDocument sCWDoc;
    private CmdWinEditorKit fCWKit;
    private CmdWinStatusBar fCWStatus;
    private static Color sErrorColor;
    private static Color sFgColor;
    private static Action sCutAction;
    private static Action sCopyAction;
    private static Action sPasteAction;
    private static Action sSelectAllAction;
    private static Action sFindAction;
    private static Action sEvalSelAction;
    private static Action sOpenSelAction;
    private static Action sPrintSelAction;
    private static Action sShowFunctionBrowserButtonAction;
    private XCaret fXCaret;
    private int fHomeYPos = -1;
    private DropTargetListener fDropTargetListener = null;
    private DragGestureListener fDragGestureListener = null;
    private DragSource fDragSource = null;
    private CWMWMouseDragGestureRecognizer fDragRecognizer;
    private MyDropTarget fDropTarget;
    private AutoScroller fAutoscroller;
    private MJButton fMoreButton;
    private MJLabel fMoreLabel;
    private FindParentListener fFindListener;
    private String fFindString = "";
    private int fFindOptions = 0;
    private boolean fFirstFind = false;
    private FindDialog fFindDialog;
    private IncSearch fIncSearch;
    private IncSearchData fIncSearchData;
    private Observer fIncSearchObserver = null;
    private boolean fIsIncSearch = false;
    private int fLastFindBegin;
    private int fLastFindEnd;
    private boolean fUseFindLoc = false;
    private int fPosBeforeInc;
    static final int TOPBORDER = 4;
    static final int LEFTBORDER = 4;
    static final int BOTBORDER = 0;
    static final int RIGHTBORDER = 4;
    private static MJScrollPane sScrollPane;
    private static int sProgressTrue;
    private static CmdWinSyntaxUI sOurUI;
    private static boolean sOverwriteMode;
    private static String sTheHeader;
    static final String sPrintingTitle;
    private boolean fInputMethodsEnabled = true;
    int fRowHeight = -1;
    private int fColWidth = -1;
    private final FindClientImpl fFindClientImpl;
    private static boolean sTesting;
    private static boolean sHasLinkStatus;
    private static final XCmdWndView sXCmdWndView;
    private KeyStroke fLastKeyStrokePressed;
    private FunctionBrowserRowHeader fFunctionBrowserRowHeader;

    private XCmdWndView() {
        sOurUI = new CmdWinSyntaxUI();
        this.setUI(sOurUI);
        Border border = BorderFactory.createEmptyBorder(4, 4, 0, 4);
        this.setBorder(border);
        sCWDoc = CmdWinDocument.getInstance();
        this.setDocument(sCWDoc);
        this.fXCaret = XCaret.getInstance();
        this.setCaret(this.fXCaret);
        this.fDropTargetListener = CWDragDropImpl.getInstance(this);
        this.fDropTarget = new MyDropTarget(this, this.fDropTargetListener);
        this.fDragSource = new DragSource();
        this.fDragGestureListener = (DragGestureListener)((Object)this.fDropTargetListener);
        this.fDragRecognizer = new CWMWMouseDragGestureRecognizer(this.fDragSource, this, 3, this.fDragGestureListener, this.fXCaret, this.fXCaret);
        this.fAutoscroller = new AutoScroller(this){

            public int getAutoscrollRowHeight() {
                return XCmdWndView.this.fRowHeight;
            }

            public int getAutoscrollColumnWidth() {
                return XCmdWndView.this.fColWidth;
            }
        };
        this.fFindClientImpl = new FindClientImpl();
        this.addCaretListener(new CWCaretListener());
        try {
            sCWDoc.insertPrompt(0);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        this.initPrefs();
        TokenMatcher tokenMatcher = new TokenMatcher(this, CmdWinDocument.getInstance());
        tokenMatcher.setEnabled(true);
        this.miniInit();
        AppearanceFocusDispatcher appearanceFocusDispatcher = new AppearanceFocusDispatcher();
        appearanceFocusDispatcher.addAppearanceFocusListener((AppearanceFocusListener)new MyAppearanceFocusListener());
        this.addFocusListener((FocusListener)appearanceFocusDispatcher);
        this.setName("cw_view");
        this.getAccessibleContext().setAccessibleName(sTheHeader);
        this.requestFocus();
        this.addMouseListener(new MyMouseAdapter());
    }

    CWMWMouseDragGestureRecognizer getRecognizer() {
        return this.fDragRecognizer;
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
    }

    @Override
    public void autoscroll(Point point) {
        this.fAutoscroller.autoscroll(point);
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.fAutoscroller.getAutoscrollInsets();
    }

    private void createActionMap() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("insert-break", CmdWinEditorKit.getActionByName("insert-break"));
        actionMap.put("insert-tab", CmdWinEditorKit.getActionByName("insert-tab"));
        actionMap.put("delete-previous", CmdWinEditorKit.getActionByName("delete-previous"));
        actionMap.put("delete-next", CmdWinEditorKit.getActionByName("delete-next"));
        actionMap.put("next-history-item", CmdWinEditorKit.getActionByName("next-history-item"));
        actionMap.put("previous-history-item", CmdWinEditorKit.getActionByName("previous-history-item"));
        actionMap.put("caret-begin-line", CmdWinEditorKit.getActionByName("caret-begin-line"));
        actionMap.put("selection-begin-line", CmdWinEditorKit.getActionByName("selection-begin-line"));
        actionMap.put("caret-end-line", CmdWinEditorKit.getActionByName("caret-end-line"));
        actionMap.put("selection-end-line", CmdWinEditorKit.getActionByName("selection-end-line"));
        actionMap.put("clear-text-at-prompt", CmdWinEditorKit.getActionByName("clear-text-at-prompt"));
        actionMap.put("copy-to-clipboard", CmdWinEditorKit.getActionByName("copy-to-clipboard"));
        actionMap.put("open-selection", CmdWinEditorKit.getActionByName("open-selection"));
        actionMap.put("kill-line", CmdWinEditorKit.getActionByName("kill-line"));
        actionMap.put("help-on-selection", CmdWinEditorKit.getActionByName("help-on-selection"));
        actionMap.put("cut-to-clipboard", CmdWinEditorKit.getActionByName("cut-to-clipboard"));
        actionMap.put("paste-from-clipboard", CmdWinEditorKit.getActionByName("paste-from-clipboard"));
        actionMap.put("page-up", CmdWinEditorKit.getActionByName("page-up"));
        actionMap.put("page-down", CmdWinEditorKit.getActionByName("page-down"));
        actionMap.put("caret-begin", CmdWinEditorKit.getActionByName("caret-begin"));
        actionMap.put("caret-end", CmdWinEditorKit.getActionByName("caret-end"));
        actionMap.put("break-interrupt", CmdWinEditorKit.getActionByName("break-interrupt"));
        actionMap.put("print", CmdWinEditorKit.getActionByName("print"));
        actionMap.put("drop-line", CmdWinEditorKit.getActionByName("drop-line"));
        actionMap.put("find-and-replace", CmdWinEditorKit.getActionByName("find-and-replace"));
        actionMap.put("inc-search-forward", CmdWinEditorKit.getActionByName("inc-search-forward"));
        actionMap.put("inc-search-backward", CmdWinEditorKit.getActionByName("inc-search-backward"));
        actionMap.put("caret-up", CmdWinEditorKit.getActionByName("caret-up"));
        actionMap.put("caret-down", CmdWinEditorKit.getActionByName("caret-down"));
        actionMap.put("open-errored-file", CmdWinEditorKit.getActionByName("open-errored-file"));
        actionMap.put("select-word", CmdWinEditorKit.getActionByName("select-word"));
        actionMap.put("evaluate-selection", CmdWinEditorKit.getActionByName("evaluate-selection"));
        actionMap.put("caret-next-word", CmdWinEditorKit.getActionByName("caret-next-word"));
        actionMap.put("caret-previous-word", CmdWinEditorKit.getActionByName("caret-previous-word"));
        actionMap.put("selection-next-word", CmdWinEditorKit.getActionByName("selection-next-word"));
        actionMap.put("selection-previous-word", CmdWinEditorKit.getActionByName("selection-previous-word"));
        actionMap.put("clear-command-window", CmdWinEditorKit.getActionByName("clear-command-window"));
        actionMap.put("toggle-typing-mode", CmdWinEditorKit.getActionByName("toggle-typing-mode"));
        actionMap.put("caret-forward", CmdWinEditorKit.getActionByName("caret-forward"));
        actionMap.put("caret-backward", CmdWinEditorKit.getActionByName("caret-backward"));
        actionMap.put("adjust-window-top", CmdWinEditorKit.getActionByName("adjust-window-top"));
        actionMap.put("adjust-window-bottom", CmdWinEditorKit.getActionByName("adjust-window-bottom"));
        actionMap.put("function-browser-key", CmdWinEditorKit.getActionByName("function-browser-key"));
        actionMap.put("show-funcbrowser-btn", CmdWinEditorKit.getActionByName("show-funcbrowser-btn"));
        actionMap.put("function-hints-key", CmdWinEditorKit.getActionByName("function-hints-key"));
        actionMap.put("undo", CmdWinEditorKit.getActionByName("undo"));
        actionMap.put("redo", CmdWinEditorKit.getActionByName("redo"));
        actionMap.put("select-all", CmdWinEditorKit.getActionByName("select-all"));
        actionMap.put("show-page-setup", CmdWinEditorKit.getActionByName("show-page-setup"));
        actionMap.put("find-files", CmdWinEditorKit.getActionByName("find-files"));
        actionMap.put("print-selection", CmdWinEditorKit.getActionByName("print-selection"));
        actionMap.put("selection-up", CmdWinEditorKit.getActionByName("selection-up"));
        actionMap.put("selection-down", CmdWinEditorKit.getActionByName("selection-down"));
        actionMap.put("show-history", CmdWinEditorKit.getActionByName("show-history"));
        actionMap.put("selection-page-up", CmdWinEditorKit.getActionByName("selection-page-up"));
        actionMap.put("selection-page-down", CmdWinEditorKit.getActionByName("selection-page-down"));
    }

    static Action getCutAction() {
        if (sCutAction == null) {
            sCutAction = CmdWinEditorKit.getActionByName("cut-to-clipboard");
        }
        return sCutAction;
    }

    static Action getCopyAction() {
        if (sCopyAction == null) {
            sCopyAction = CmdWinEditorKit.getActionByName("copy-to-clipboard");
        }
        return sCopyAction;
    }

    static Action getPasteAction() {
        if (sPasteAction == null) {
            sPasteAction = CmdWinEditorKit.getActionByName("paste-from-clipboard");
        }
        return sPasteAction;
    }

    static Action getSelectAllAction() {
        if (sSelectAllAction == null) {
            sSelectAllAction = CmdWinEditorKit.getActionByName("select-all");
        }
        return sSelectAllAction;
    }

    static Action getFindAction() {
        if (sFindAction == null) {
            sFindAction = CmdWinEditorKit.getActionByName("find-and-replace");
        }
        return sFindAction;
    }

    static Action getEvalSelAction() {
        if (sEvalSelAction == null) {
            sEvalSelAction = CmdWinEditorKit.getActionByName("evaluate-selection");
        }
        return sEvalSelAction;
    }

    static Action getOpenSelAction() {
        if (sOpenSelAction == null) {
            sOpenSelAction = CmdWinEditorKit.getActionByName("open-selection");
        }
        return sOpenSelAction;
    }

    static Action getPrintSelAction() {
        if (sPrintSelAction == null) {
            sPrintSelAction = CmdWinEditorKit.getActionByName("print-selection");
        }
        return sPrintSelAction;
    }

    static Action getShowFunctionBrowserButtonAction() {
        if (sShowFunctionBrowserButtonAction == null) {
            sShowFunctionBrowserButtonAction = CmdWinEditorKit.getActionByName("show-funcbrowser-btn");
        }
        return sShowFunctionBrowserButtonAction;
    }

    public static MJPopupMenu createPopupMenu() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.setName("cw_popupMenu");
        MJMenuItem mJMenuItem = new MJMenuItem(XCmdWndView.getEvalSelAction());
        mJMenuItem.setName("cw_evalPopupItem");
        mJPopupMenu.add((JMenuItem)mJMenuItem);
        MJMenuItem mJMenuItem2 = new MJMenuItem(XCmdWndView.getOpenSelAction());
        mJMenuItem2.setName("cw_openSelPopupItem");
        mJPopupMenu.add((JMenuItem)mJMenuItem2);
        Action action = CmdWinEditorKit.getActionByName("help-on-selection");
        MJMenuItem mJMenuItem3 = new MJMenuItem(action);
        mJMenuItem3.setName("cw_helpPopupItem");
        mJPopupMenu.add((JMenuItem)mJMenuItem3);
        mJPopupMenu.addSeparator();
        Action action2 = CmdWinEditorKit.getActionByName("function-browser-key");
        MJMenuItem mJMenuItem4 = new MJMenuItem(action2);
        mJMenuItem4.setName("cw_fcnbrowseItem");
        mJPopupMenu.add((JMenuItem)mJMenuItem4);
        MJMenuItem mJMenuItem5 = new MJMenuItem(XCmdWndView.getShowFunctionBrowserButtonAction());
        mJMenuItem4.setName("cw_fcnbrowseShowBtnItem");
        mJPopupMenu.add((JMenuItem)mJMenuItem5);
        mJPopupMenu.addSeparator();
        Action action3 = CmdWinEditorKit.getActionByName("function-hints-key");
        MJMenuItem mJMenuItem6 = new MJMenuItem(action3);
        mJMenuItem6.setName("cw_fcnhintsItem");
        mJPopupMenu.add((JMenuItem)mJMenuItem6);
        mJPopupMenu.addSeparator();
        mJPopupMenu.add(XCmdWndView.getCutAction());
        mJPopupMenu.add(XCmdWndView.getCopyAction());
        mJPopupMenu.add(XCmdWndView.getPasteAction());
        mJPopupMenu.addSeparator();
        mJPopupMenu.add(XCmdWndView.getSelectAllAction());
        mJPopupMenu.add(XCmdWndView.getFindAction());
        mJPopupMenu.addSeparator();
        mJPopupMenu.add(CmdWinEditorKit.getActionByName("print"));
        mJPopupMenu.add(XCmdWndView.getPrintSelAction());
        mJPopupMenu.add(CmdWinEditorKit.getActionByName("show-page-setup"));
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((JMenuItem)new MJMenuItem(CmdWinEditorKit.getActionByName("clear-command-window")));
        return mJPopupMenu;
    }

    private void doScrollPaneLayout() {
        JViewport jViewport = sScrollPane.getViewport();
        this.invalidate();
        jViewport.doLayout();
        this.scrollToCaretLater();
    }

    @Override
    public void enableInputMethods(boolean bl) {
        this.fInputMethodsEnabled = bl;
        super.enableInputMethods(bl);
    }

    DragSource getDragSource() {
        return this.fDragSource;
    }

    static Color getErrorColor() {
        return sErrorColor;
    }

    static Color getFgColor() {
        return sFgColor;
    }

    boolean getInputMethodsEnabled() {
        return this.fInputMethodsEnabled;
    }

    static void setLinkCursor(Cursor cursor, String string) {
        sXCmdWndView.setCursor(cursor);
        if (string.length() == 0 || string.equals("")) {
            if (sHasLinkStatus) {
                string = null;
                sHasLinkStatus = false;
                XCmdWndView.setStatusText(string);
            }
            return;
        }
        if (string != null && string.startsWith("error:")) {
            string = sRes.getString("error.statusmsg");
        }
        XCmdWndView.setStatusText(string);
        sHasLinkStatus = true;
    }

    private static void setStatusText(String string) {
        if (MLDesktop.getInstance().isClientDocked((Component)((Object)CmdWin.getInstance()))) {
            MLDesktop.getInstance().setStatusText(string);
        } else {
            CmdWin.getStatusBar().setText(string);
        }
    }

    public MJScrollPane getScrollPane() {
        if (sScrollPane == null) {
            sScrollPane = new MJScrollPane((Component)this);
            sScrollPane.setName("cw_ScrollPane");
            sScrollPane.getViewport().addComponentListener(new CWComponentListener());
            sScrollPane.anchorToBottom();
            sScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (!adjustmentEvent.getValueIsAdjusting()) {
                        XCmdWndView.this.updateMoreLabel();
                    }
                }
            });
        }
        return sScrollPane;
    }

    void home() {
        Assert._assert((sScrollPane != null ? 1 : 0) != 0, (String)"No scroll pane for command win");
        Rectangle rectangle = null;
        try {
            rectangle = this.modelToView(sCWDoc.getPromptOffset());
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        if (sXCmdWndView.getPotentialRows() > 1) {
            this.setHome(rectangle.y);
        }
        JViewport jViewport = sScrollPane.getViewport();
        jViewport.setViewPosition(new Point(0, rectangle.y));
        this.doScrollPaneLayout();
    }

    private void initPrefs() {
        CWPrefsListener cWPrefsListener = new CWPrefsListener();
        Prefs.addListener((PrefListener)cWPrefsListener, (String)"CommandWindowWrapLines");
        Prefs.addListener((PrefListener)cWPrefsListener, (String)"CommandWindowSpacesPerTab");
        Prefs.addListener((PrefListener)cWPrefsListener, (String)"CommandWindowMinSessionSize");
        Prefs.addListener((PrefListener)cWPrefsListener, (String)"CommandWindowShowFunctionBrowser");
        CmdWinFontListener cmdWinFontListener = new CmdWinFontListener();
        FontPrefs.addFontListener((String)sMLRes.getString("title.CommandWindow"), (FontListener)cmdWinFontListener);
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)cWPrefsListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)cWPrefsListener);
        ColorPrefs.addColorListener((String)"Colors_M_", (PrefListener)cWPrefsListener);
        ColorPrefs.addColorListener((String)"Colors_HTML_", (PrefListener)cWPrefsListener);
        this.setCWFont(FontPrefs.getFontForComponent((String)sMLRes.getString("title.CommandWindow")));
        this.setWrapStyleWord(true);
        this.setWrap();
        this.setTabSizePref();
        this.setMaxLines();
        this.setCWBgColor();
        this.setCWFgColor();
    }

    private void miniInit() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                sCWDoc.setUserInitialized();
                XCmdWndView.this.removeKeyListener(this);
            }
        });
        sCWDoc.addDocumentListener(new DocumentListener(){

            public void testIfDispatchThread() {
                if (!EventQueue.isDispatchThread()) {
                    Toolkit.getDefaultToolkit().beep();
                    Log.log((String)"Event in command window doc NOT on Event thread\n");
                    Throwable throwable = new Throwable("Stack Trace: ");
                    throwable.fillInStackTrace();
                    throwable.printStackTrace();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.testIfDispatchThread();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.testIfDispatchThread();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.testIfDispatchThread();
            }
        });
    }

    public static XCmdWndView getInstance() {
        return sXCmdWndView;
    }

    void loadKeyBindings() {
        MInputMap mInputMap = new MInputMap(){

            public void keyBindingChanged(String string, String string2, List<KeyStrokeList> list, List<KeyStrokeList> list2) {
                KeyBindingManager keyBindingManager = MatlabKeyBindings.getManager();
                KeyBindingSet keyBindingSet = keyBindingManager.getCurrentKeyBindingSet();
                Context context = keyBindingManager.getContext("CommandWindow");
                ActionData actionData = keyBindingManager.getActionData("break-interrupt");
                List list3 = keyBindingSet.getKeyBindings(context, actionData);
                LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>(list2);
                if (!string.equals("break-interrupt")) {
                    linkedList.removeAll(list3);
                }
                super.keyBindingChanged(string, string2, list, linkedList);
            }
        };
        MatlabKeyBindings.getManager().addKeyBindingsWithTag("CommandWindow", "InputMapAction", (ExtendedInputMap)mInputMap);
        ExtendedAction extendedAction = (ExtendedAction)CmdWinEditorKit.getActionByName("show-history");
        mInputMap.put(extendedAction.getAccelerator(), extendedAction.getValue("ActionCommandKey"));
        this.setInputMap(0, (InputMap)mInputMap);
        Keymap keymap = this.getKeymap();
        this.createActionMap();
        keymap.setDefaultAction(CmdWinEditorKit.getActionByName("default-typed"));
        this.setKeymap(keymap);
    }

    int getPotentialColumns() {
        JViewport jViewport = this.getScrollPane().getViewport();
        Dimension dimension = jViewport.getExtentSize();
        return dimension.width / this.fColWidth;
    }

    int getPotentialRows() {
        JViewport jViewport = this.getScrollPane().getViewport();
        Dimension dimension = jViewport.getExtentSize();
        return dimension.height / this.fRowHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.fHomeYPos != -1) {
            JViewport jViewport = sScrollPane.getViewport();
            Dimension dimension2 = jViewport.getExtentSize();
            if (dimension.height > this.fHomeYPos + dimension2.height) {
                this.setHome(-1);
            } else {
                dimension.height += dimension2.height - (dimension.height - this.fHomeYPos);
            }
        }
        return dimension;
    }

    ResourceBundle getResources() {
        return sRes;
    }

    @Override
    public String getSelectedText() {
        try {
            return super.getSelectedText();
        }
        catch (Exception exception) {
            this.getCaret().setDot(sCWDoc.getLength());
            return null;
        }
    }

    private static DTChildAction createWrapperAction(DTMenuMergeTag dTMenuMergeTag, String string) {
        return DTUtilities.createDTChildAction((DTMenuMergeTag)dTMenuMergeTag, (String)"CommandWindow", (String)string, (KeyBindingManager)MatlabKeyBindings.getManager());
    }

    private void setClipboardContents() {
        MJClipboard.getMJClipboard().setContents(MJTransferable.getCombinedTransferable((Transferable[])new Transferable[]{new MJTransferable((Object)this.getSelectedText(), DataFlavor.stringFlavor), new MJTransferable((Object)Prompt.stripPrompts(this.getSelectedText()), MLDataFlavor.cwPromptlessStringFlavor)}), null);
    }

    @Override
    public void copy() {
        this.setClipboardContents();
    }

    @Override
    public void cut() {
        this.setClipboardContents();
        this.replaceSelection("");
    }

    @Override
    public void paste() {
        Transferable transferable = MJClipboard.getMJClipboard().getContents((Object)this);
        if (transferable != null) {
            try {
                if (transferable.isDataFlavorSupported(MLDataFlavor.simpleVariableListFlavor)) {
                    this.replaceSelection(MLDataFlavor.getSimpleVariableStringRepresentation((Transferable)transferable));
                } else if (transferable.isDataFlavorSupported(MLDataFlavor.cwPromptlessStringFlavor)) {
                    String string = (String)transferable.getTransferData(MLDataFlavor.cwPromptlessStringFlavor);
                    this.processPaste(string);
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    string = Prompt.stripPrompts(string);
                    this.processPaste(string);
                } else {
                    this.getToolkit().beep();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processPaste(String string) {
        if (CmdWinMLIF.isInBangMode() && PlatformInfo.isUnix()) {
            for (int i = 0; i < string.length(); ++i) {
                this.processKeyEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 0, KeyStroke.getKeyStroke(string.charAt(i)).getKeyCode(), string.charAt(i)));
                this.processKeyEvent(new KeyEvent(this, 400, System.currentTimeMillis(), 0, KeyStroke.getKeyStroke(string.charAt(i)).getKeyCode(), string.charAt(i)));
                this.processKeyEvent(new KeyEvent(this, 402, System.currentTimeMillis(), 0, KeyStroke.getKeyStroke(string.charAt(i)).getKeyCode(), string.charAt(i)));
            }
        } else {
            string = this.fixPastedNewLines(string);
            this.replaceSelection(string);
        }
    }

    private String fixPastedNewLines(String string) {
        if (string != null) {
            try {
                int n;
                int n2 = 0;
                int n3 = string.length();
                int n4 = n3 - n2;
                StringBuffer stringBuffer = new StringBuffer(string.length());
                StringReader stringReader = new StringReader(string);
                char[] cArray = new char[1024];
                boolean bl = false;
                while ((n = ((Reader)stringReader).read(cArray, 0, cArray.length)) != -1) {
                    int n5 = 0;
                    block7: for (int i = 0; i < n; ++i) {
                        switch (cArray[i]) {
                            case '\r': {
                                if (bl) {
                                    if (i == 0) {
                                        stringBuffer.append('\n');
                                        continue block7;
                                    }
                                    cArray[i - 1] = 10;
                                    continue block7;
                                }
                                bl = true;
                                continue block7;
                            }
                            case '\n': {
                                if (!bl) continue block7;
                                if (i > n5 + 1) {
                                    stringBuffer.append(cArray, n5, i - n5 - 1);
                                }
                                bl = false;
                                n5 = i;
                                continue block7;
                            }
                            default: {
                                if (!bl) continue block7;
                                if (i == 0) {
                                    stringBuffer.append('\n');
                                } else {
                                    cArray[i - 1] = 10;
                                }
                                bl = false;
                            }
                        }
                    }
                    if (n5 >= n) continue;
                    if (bl) {
                        if (n5 >= n - 1) continue;
                        stringBuffer.append(cArray, n5, n - n5 - 1);
                        continue;
                    }
                    stringBuffer.append(cArray, n5, n - n5);
                }
                if (bl) {
                    stringBuffer.append('\n');
                }
                return stringBuffer.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    void print(boolean bl) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = sCWDoc.getPromptLineEndOffset(false);
        if (bl) {
            n2 = this.getCaret().getDot();
            if (n2 < (n = this.getCaret().getMark())) {
                n3 = n2;
                n4 = n;
            } else {
                n3 = n;
                n4 = n2;
            }
        }
        n2 = n3;
        n = n4;
        this.getDocument().putProperty("title", sPrintingTitle);
        PrintSettings printSettings = PrintSettings.getInstance();
        printSettings.setPrintOptions(CmdWinPrefs.getPrintOptions());
        printSettings.setWrap((CmdWinPrefs.getPrintOptions() & 8) != 0);
        printSettings.setHeaderFont(CmdWinPrefs.getPrintingHeaderFont());
        final PrintRequestAttributeSet printRequestAttributeSet = printSettings.getLastPrintRequestAttributes((String)this.getDocument().getProperty("title"));
        Chromaticity chromaticity = TextPrintPanel.addChromaticityToPrintAttributeSet((int)CmdWinPrefs.getPrintOptions(), (AttributeSet)printRequestAttributeSet);
        final MJFrame mJFrame = MJFrame.getFrame((Component)sXCmdWndView);
        final PrinterJob printerJob = printSettings.showPrintDialog((DocFlavor)DocFlavor.SERVICE_FORMATTED.PRINTABLE, mJFrame, printRequestAttributeSet);
        Chromaticity chromaticity2 = (Chromaticity)printRequestAttributeSet.get(Chromaticity.class);
        TextPrintPanel.updateColorPrintOptionPrefIfNeccessary((String)"CommandWindowPrintOptions", (Chromaticity)chromaticity, (Chromaticity)chromaticity2, (int)CmdWinPrefs.getPrintOptions());
        if (printerJob != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (PrintSettings.useNativeDialogs()) {
                            TextPrintable textPrintable = new TextPrintable(XCmdWndView.this.getDocument(), n2, n, (Frame)mJFrame);
                            printerJob.setPrintable((Printable)textPrintable);
                            printerJob.print(printRequestAttributeSet);
                        } else {
                            DocPrintJob docPrintJob;
                            PrintService printService = printerJob.getPrintService();
                            if (printService != null && (docPrintJob = printService.createPrintJob()) != null) {
                                TextPrintable textPrintable = new TextPrintable(XCmdWndView.this.getDocument(), n2, n, (Frame)mJFrame, docPrintJob);
                                SimpleDoc simpleDoc = new SimpleDoc(textPrintable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, new HashDocAttributeSet());
                                docPrintJob.print(simpleDoc, printRequestAttributeSet);
                            }
                        }
                    }
                    catch (PrintException printException) {
                        PrintUtils.showPrintError((Exception)printException, (Component)sXCmdWndView);
                    }
                    catch (PrinterException printerException) {
                        PrintUtils.showPrintError((Exception)printerException, (Component)sXCmdWndView);
                    }
                }
            }, "XCmdWndView").start();
        }
    }

    private void scrollToCaretLater() {
        Assert._assert((sScrollPane != null ? 1 : 0) != 0, (String)"XCmdWndView:scrollToCaret can't scroll with no pane");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension dimension = new Dimension();
                JViewport jViewport = sScrollPane.getViewport();
                dimension = jViewport.getSize(dimension);
                if (dimension.width < XCmdWndView.this.fColWidth * 2) {
                    return;
                }
                Caret caret = XCmdWndView.this.getCaret();
                Rectangle rectangle = null;
                try {
                    rectangle = XCmdWndView.this.modelToView(caret.getDot());
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                    return;
                }
                jViewport.scrollRectToVisible(rectangle);
            }
        });
    }

    void scrollToOffset(int n) {
        Assert._assert((sScrollPane != null ? 1 : 0) != 0, (String)"XCmdWndView:scrollToCaret can't scroll with no pane");
        Rectangle rectangle = null;
        Dimension dimension = new Dimension();
        JViewport jViewport = sScrollPane.getViewport();
        dimension = jViewport.getSize(dimension);
        if (dimension.width < this.fColWidth * 2) {
            return;
        }
        try {
            rectangle = this.modelToView(n);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
            return;
        }
        this.scrollRectToVisible(rectangle);
    }

    public void scrollToBottom() {
        int n = sCWDoc.getLength();
        if (n > 0) {
            this.scrollToOffset(n - 1);
        }
    }

    @Override
    public void replaceSelection(String string) {
        Caret caret = this.getCaret();
        XCaret.adjustSelection(caret);
        if (PlatformInfo.isMacintosh()) {
            this.updateEnablement();
        }
        if (!(caret instanceof XCaret) && sCWDoc.isInOrBeforeThePrompt(caret.getDot())) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.replaceSelection(string);
        if (string != null && string.endsWith("\n") && !sTesting) {
            CmdWinEditorKit.sendCurrentCommand(sCWDoc.getPromptLineEndOffset(true));
        }
    }

    @Override
    public void setCaret(Caret caret) {
        super.setCaret(caret);
        Assert._assert((boolean)(caret instanceof DefaultCaret));
        DefaultCaret defaultCaret = (DefaultCaret)caret;
        if (this.fDragRecognizer != null) {
            this.fDragRecognizer.setForwardingListener(defaultCaret, defaultCaret, this);
        }
    }

    private void setCWBgColor() {
        this.setBackground(ColorPrefs.getBackgroundColor());
    }

    private void setCWFgColor() {
        sFgColor = ColorPrefs.getTextColor();
        this.setForeground(sFgColor);
        this.setCaretColor(sFgColor);
    }

    private void setCWFont(Font font) {
        if (font != null) {
            this.setHome(-1);
            this.setFont(font);
            this.fRowHeight = this.getFontMetrics(this.getFont()).getHeight();
            this.fColWidth = this.getFontMetrics(this.getFont()).charWidth('n');
            if (sScrollPane == null) {
                return;
            }
            Dimension dimension = this.getSize();
            this.setSize(dimension.width + 1, dimension.height);
            this.scrollToCaretLater();
            CmdWinMLIF.setCWSize(this.getPotentialRows(), this.getPotentialColumns());
        }
    }

    void setEditorKit(EditorKit editorKit) {
        this.fCWKit = (CmdWinEditorKit)editorKit;
        this.loadKeyBindings();
    }

    void setStatusBar(CmdWinStatusBar cmdWinStatusBar) {
        this.fCWStatus = cmdWinStatusBar;
    }

    private void setHome(int n) {
        this.fHomeYPos = n;
    }

    private void setMaxLines() {
        CmdWinDocument.setMaxLines(CmdWinPrefs.getSessionSize());
    }

    @Override
    public void setUI(TextUI textUI) {
        super.setUI(sOurUI);
    }

    private void setTabSizePref() {
        this.setTabSize(CmdWinPrefs.getTabSize());
    }

    private void setWrap() {
        boolean bl = CmdWinPrefs.isWrapLines();
        if (this.getLineWrap() != bl) {
            this.setLineWrap(bl);
            if (sScrollPane != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.doScrollPaneLayout();
                } else {
                    SwingUtilities.invokeLater(new LayoutScrollPaneOnEventThread());
                }
            }
        }
    }

    FunctionBrowserRowHeader getFunctionBrowserRowHeader() {
        boolean bl = CmdWinPrefs.isShowFunctionBrowser();
        if (this.fFunctionBrowserRowHeader == null) {
            this.fFunctionBrowserRowHeader = new FunctionBrowserRowHeader(this);
        }
        this.fFunctionBrowserRowHeader.setVisible(bl);
        this.updateEnablement();
        return this.fFunctionBrowserRowHeader;
    }

    static void showPageSetupDialog() {
        if (PrintSettings.useMacNativeFixes()) {
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            hashMap.put("PageAttributes", PrintUtils.PageAttributesHelper.getLastUsedPageAttributes());
            Map<String, Object> map = CmdWinPrintUtils.getPrintOptionsAsMap();
            hashMap.put("DesktopPrintOptions", map);
            hashMap.put("JavaLogicalFontMap", PrintUtils.FontHelper.getLogicalFontMap());
            String string = PrintUtils.PListSerializer.hashMapToPListString(hashMap);
            String string2 = NativeJava.showPageSetupDialog((String)string);
            if (string2 != null) {
                Map map2 = PrintUtils.PListSerializer.plistStringToHashMap((String)string2);
                PrintUtils.PageAttributesHelper.setLastUsedPageAttributes((HashMap)((HashMap)map2.get("PageAttributes")));
                CmdWinPrintUtils.setPrintOptionsFromMap((Map)map2.get("DesktopPrintOptions"));
            }
        } else {
            int n = MJOptionPane.showConfirmDialog((Component)SwingUtilities.windowForComponent(sXCmdWndView), (Object)CmdWinPrinterPageSetup.createPrefsPanel(), (String)(sRes.getString("pagesetup.previewlabel") + " " + sTheHeader), (int)2, (int)-1);
            if (n == 0) {
                CmdWinPrinterPageSetup.commitPrefsChanges(true);
            }
        }
    }

    public void updateActions() {
        this.updateEnablement();
    }

    private void updateEnablement() {
        if (sCopyAction == null) {
            return;
        }
        Caret caret = this.getCaret();
        boolean bl = XCaret.hasSelection(caret);
        sCopyAction.setEnabled(bl);
        if (sPrintSelAction != null) {
            sPrintSelAction.setEnabled(bl);
        }
        if (caret instanceof XCaret) {
            sCutAction.setEnabled(((XCaret)caret).isSelectionEditable() && !CmdWinMLIF.isInBangMode());
        } else {
            sCutAction.setEnabled(true);
        }
        if (sEvalSelAction != null) {
            sEvalSelAction.setEnabled(bl);
        }
        if (sOpenSelAction != null) {
            sOpenSelAction.setEnabled(bl);
        }
        if (bl && PlatformInfo.isXWindows()) {
            MJClipboard.getMJClipboard().setXSelectionContents(this.getSelectedText());
        }
        if (sShowFunctionBrowserButtonAction != null) {
            sShowFunctionBrowserButtonAction.setEnabled(!CmdWinPrefs.isShowFunctionBrowser());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        MLExecutionEvent mLExecutionEvent = (MLExecutionEvent)changeEvent;
        if ((mLExecutionEvent.isEnteringInputMode() || mLExecutionEvent.isEnteringKeyboardMode()) && !this.isFocusOwner()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Window window = SwingUtilities.getWindowAncestor(XCmdWndView.this);
                    if (window != null) {
                        window.toFront();
                    }
                    XCmdWndView.this.requestFocusInWindow();
                }
            });
        }
    }

    FindParentListener getFindParentListener() {
        return this.fFindListener;
    }

    private FindDialog getFindDialog() {
        return this.fFindDialog;
    }

    public FindClientInterface getFindClient() {
        return this.fFindClientImpl;
    }

    void invokeFindDialog() {
        sCWDoc.resetFindPos();
        this.fFindDialog = FindDialog.invoke((FindClientInterface)this.fFindClientImpl, (String)this.getSelectedText(), (int)this.fFindOptions);
    }

    boolean isOverwriteMode() {
        return sOverwriteMode;
    }

    static void setOverwriteMode(boolean bl) {
        sOverwriteMode = bl;
    }

    private void setDeactivatedColors() {
        this.setSelectionColor(ColorUtils.getUnfocusedSelectionBackgroundColor((Component)this));
        this.setSelectedTextColor(ColorUtils.getUnfocusedSelectionForegroundColor((Component)this));
        this.setForeground(new Color(this.getForeground().getRGB()));
        this.repaint();
    }

    private void setActiveColors() {
        this.setSelectionColor(ColorUtils.getTextSelectionBackgroundColor());
        this.setSelectedTextColor(ColorUtils.getTextSelectionForegroundColor());
        this.repaint();
    }

    public void endIncSearch() {
        this.fIsIncSearch = false;
        this.removeKeyListener((KeyListener)this.fIncSearch);
        this.removeFocusListener((FocusListener)this.fIncSearch);
        this.removeMouseListener((MouseListener)this.fIncSearch);
        sCWDoc.resetIncrementalSearch();
    }

    public void endIncSearchMoveCaret() {
        sCWDoc.resetIncrementalSearch();
    }

    public IncSearchData find(String string, boolean bl) {
        int n = 0;
        if (!string.toLowerCase().equals(string)) {
            ++n;
        }
        n += 2;
        if (!bl) {
            n += 8;
        }
        this.fUseFindLoc = sCWDoc.findString(string, n);
        JTextComponent jTextComponent = this.getLastActiveComponent();
        this.fLastFindBegin = this.getSelectionStart();
        this.fLastFindEnd = this.getSelectionEnd();
        this.scrollToOffset(this.fLastFindEnd);
        return new IncSearchData(string, this.fUseFindLoc, this.fLastFindBegin, this.fLastFindEnd - this.fLastFindBegin, bl);
    }

    public JTextComponent getLastActiveComponent() {
        return this;
    }

    public boolean getMacSupport() {
        return false;
    }

    public IncSearchData incSearch(String string, boolean bl) {
        this.fIncSearchData = sCWDoc.doIncrementalSearch(string, bl);
        this.fUseFindLoc = false;
        this.scrollToOffset(this.getSelectionEnd());
        return this.fIncSearchData;
    }

    public String incSearchEOL(String string) {
        IncSearchData incSearchData = sCWDoc.doIncrementalSearch(string, false);
        this.scrollToOffset(this.getSelectionEnd());
        return incSearchData.getSearchString();
    }

    public String incSearchNextWord(String string) {
        sCWDoc.doIncrementalSearchCtrlW();
        this.scrollToOffset(this.getSelectionEnd());
        if (this.getSelectedText() == null) {
            return string;
        }
        return this.getSelectedText();
    }

    public void clearSearch() {
        XCaret.getInstance().setDot(this.fPosBeforeInc);
    }

    public void startIncSearch(boolean bl) {
        if (this.fIncSearchObserver != null) {
            this.fIsIncSearch = true;
            if (this.fIncSearch == null) {
                this.fIncSearch = new IncSearch((IncSearchInterface)this, true);
            }
            this.fPosBeforeInc = XCaret.getInstance().getDot();
            this.fIncSearch.initIncSearch(bl);
            this.addKeyListener((KeyListener)this.fIncSearch);
            this.addFocusListener((FocusListener)this.fIncSearch);
            this.addMouseListener((MouseListener)this.fIncSearch);
        }
    }

    public void addIncSearchObserver(Observer observer) {
        this.fIncSearchObserver = observer;
        if (this.fIncSearch == null) {
            this.fIncSearch = new IncSearch((IncSearchInterface)this, true);
        }
        this.fIncSearch.addObserver(this.fIncSearchObserver);
    }

    public void removeIncSearchObserver(Observer observer) {
        if (this.fIncSearch != null) {
            this.fIncSearch.removeObserver(observer);
        }
        this.endIncSearch();
        XCaret.combineCarets();
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        EventListener[] eventListenerArray;
        this.fLastKeyStrokePressed = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
        for (EventListener eventListener : eventListenerArray = this.getListeners(KeyListener.class)) {
            if (!(eventListener instanceof IncSearch) || keyEvent.getID() != 401) continue;
            ((KeyListener)eventListener).keyPressed(keyEvent);
        }
        if (!this.fIsIncSearch) {
            super.processKeyEvent(keyEvent);
        }
    }

    public KeyStroke getLastKeyStrokePressed() {
        return this.fLastKeyStrokePressed;
    }

    private static void setTesting(boolean bl) {
        sTesting = bl;
    }

    public Point getAfterPromptPoint() {
        try {
            Rectangle rectangle = this.modelToView(sCWDoc.getAfterThePrompt());
            return rectangle.getLocation();
        }
        catch (BadLocationException badLocationException) {
            return new Point(0, 0);
        }
    }

    public void pushPrompt(int n) {
        if (n > 0) {
            this.setBorder(BorderFactory.createEmptyBorder(4 + n, 4, 0, 4));
            if (this.fFunctionBrowserRowHeader != null) {
                this.fFunctionBrowserRowHeader.revalidate();
                this.fFunctionBrowserRowHeader.repaint();
            }
        }
    }

    public void popPrompt() {
        if (this.getInsets().top != 4) {
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
            if (this.fFunctionBrowserRowHeader != null) {
                this.fFunctionBrowserRowHeader.revalidate();
                this.fFunctionBrowserRowHeader.repaint();
            }
        }
    }

    public int getSpaceBelowPrompt() {
        try {
            Rectangle rectangle = this.modelToView(sCWDoc.getAfterThePrompt());
            Rectangle rectangle2 = XCmdWndView.getInstance().getVisibleRect();
            int n = rectangle.y + rectangle.height;
            int n2 = rectangle2.y + rectangle2.height;
            return n2 - n;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private Point getPromptLineEndPoint() {
        try {
            Rectangle rectangle = this.modelToView(sCWDoc.getPromptLineEndOffset(false));
            return rectangle.getLocation();
        }
        catch (BadLocationException badLocationException) {
            return new Point(0, 0);
        }
    }

    void setMoreIndicator(Action action) {
        if (action != null) {
            if (this.fMoreButton != null) {
                this.fMoreButton.setAction(action);
            } else {
                this.fMoreButton = new MJButton(action);
                this.fMoreButton.setMargin(new Insets(1, 1, 1, 1));
                this.fMoreButton.setFlyOverAppearance(true);
                this.fMoreButton.setOpaque(false);
                this.fMoreButton.setCursor(Cursor.getDefaultCursor());
                this.fMoreButton.setFont(this.getFont());
                this.add((Component)this.fMoreButton);
            }
            this.fXCaret.setVisible(false);
            this.doLayout();
        } else if (this.fMoreButton != null) {
            this.remove((Component)this.fMoreButton);
            this.fMoreButton = null;
            this.fXCaret.setVisible(true);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.fMoreButton != null) {
            Dimension dimension = this.fMoreButton.getPreferredSize();
            if (this.fRowHeight > 0) {
                dimension.height = this.fRowHeight;
            }
            Point point = this.getPromptLineEndPoint();
            this.fMoreButton.setBounds(point.x + 8, point.y, dimension.width, dimension.height);
        }
    }

    void updateMoreLabel() {
        Serializable serializable;
        if (AltHistory.showDotDotDotForMultiSelect()) {
            return;
        }
        boolean bl = false;
        try {
            int n;
            int n2 = sCWDoc.getPromptOffset();
            int n3 = n = n2 >= 0 ? this.getLineOfOffset(n2) : 0;
            if (n < this.getLineCount() - 1) {
                serializable = this.modelToView(sCWDoc.getLength());
                Rectangle rectangle = this.getScrollPane().getViewport().getViewRect();
                bl = serializable != null && rectangle != null && ((Rectangle)serializable).y >= rectangle.y + rectangle.height;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (bl) {
            if (this.fMoreLabel == null) {
                this.fMoreLabel = new MJLabel("...");
                this.fMoreLabel.setOpaque(false);
                this.fMoreLabel.setFont(this.getFont());
                this.fMoreLabel.setCursor(Cursor.getDefaultCursor());
                this.fMoreLabel.addMouseListener((MouseListener)new MouseAdapter(){});
                this.add((Component)this.fMoreLabel);
            }
        } else if (this.fMoreLabel != null) {
            this.remove((Component)this.fMoreLabel);
            this.fMoreLabel = null;
            this.repaint();
        }
        if (this.fMoreLabel != null) {
            Dimension dimension = this.fMoreLabel.getPreferredSize();
            if (this.fRowHeight > 0) {
                dimension.height = this.fRowHeight;
            }
            try {
                Rectangle rectangle = this.getScrollPane().getViewport().getViewRect();
                serializable = this.getFontMetrics(this.getFont());
                int n = this.viewToModel(new Point(0, rectangle.y + rectangle.height - ((FontMetrics)serializable).getHeight() / 2));
                int n4 = this.getLineOfOffset(n);
                int n5 = this.getLineEndOffset(n4);
                Rectangle rectangle2 = this.modelToView(n5 - 1);
                this.fMoreLabel.setBounds(rectangle2.x + 8, rectangle2.y, dimension.width, dimension.height);
            }
            catch (BadLocationException badLocationException) {
                this.remove((Component)this.fMoreLabel);
                this.fMoreLabel = null;
            }
        }
    }

    static {
        sErrorColor = Color.red;
        sFgColor = ColorPrefs.getTextColor();
        sScrollPane = null;
        sProgressTrue = 0;
        sOverwriteMode = false;
        sTheHeader = sMLRes.getString("title.CommandWindow");
        sPrintingTitle = "MATLAB " + sMLRes.getString("title.CommandWindow");
        sTesting = false;
        sHasLinkStatus = false;
        sXCmdWndView = new XCmdWndView();
    }

    private class MyAppearanceFocusListener
    implements AppearanceFocusListener {
        private MyAppearanceFocusListener() {
        }

        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            XCmdWndView.this.setActiveColors();
        }

        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            Window window;
            FindParentListener findParentListener = XCmdWndView.this.getFindParentListener();
            Component component = appearanceFocusEvent.getFocusEvent().getOppositeComponent();
            Window window2 = window = findParentListener == null ? null : findParentListener.getWindow();
            if (findParentListener != null && window != null && (component == window || SwingUtilities.getAncestorOfClass(window.getClass(), component) != null && SwingUtilities.getAncestorOfClass(window.getClass(), component).equals(window))) {
                return;
            }
            XCmdWndView.this.setDeactivatedColors();
        }
    }

    private class FindClientImpl
    implements FindClientInterface {
        private FindClientImpl() {
        }

        public void addFindParentListener(FindParentListener findParentListener) {
            XCmdWndView.this.fFindListener = findParentListener;
            XCmdWndView.this.setActiveColors();
        }

        public void bringForward() {
            sCWDoc.resetFindPos();
            MLDesktop.getInstance().showCommandWindow();
        }

        public void findBack(FindEvent findEvent) {
            XCmdWndView.this.fFindString = findEvent.getFindString();
            XCmdWndView.this.fFindOptions = findEvent.getOptions();
            if (XCmdWndView.this.fFindString.length() > 0) {
                int n = XCmdWndView.this.getSelectionStart();
                sCWDoc.findString(XCmdWndView.this.fFindString, XCmdWndView.this.fFindOptions + 8);
                XCmdWndView.this.fFirstFind = false;
                XCmdWndView.this.scrollToOffset(XCmdWndView.this.getSelectionStart());
            }
        }

        public void findForward(FindEvent findEvent) {
            XCmdWndView.this.fFindString = findEvent.getFindString();
            XCmdWndView.this.fFindOptions = findEvent.getOptions();
            if (XCmdWndView.this.fFindString.length() > 0) {
                int n = XCmdWndView.this.getSelectionStart();
                int n2 = XCmdWndView.this.getSelectionEnd();
                if (XCmdWndView.this.fFirstFind && n != n2) {
                    XCaret.getInstance().removeSelection();
                }
                boolean bl = sCWDoc.findString(XCmdWndView.this.fFindString, XCmdWndView.this.fFindOptions);
                if (XCmdWndView.this.fFirstFind && !bl) {
                    XCmdWndView.getInstance().setSelectionStart(n);
                    XCmdWndView.getInstance().setSelectionEnd(n2);
                }
                XCmdWndView.this.fFirstFind = false;
                XCmdWndView.this.scrollToOffset(XCmdWndView.this.getSelectionStart());
            }
        }

        public Component getInvoker() {
            return XCmdWndView.this;
        }

        public void removeFindParentListener(FindParentListener findParentListener) {
            XCmdWndView.this.fFindListener = null;
            if (FindDialog.isReparenting()) {
                XCmdWndView.this.setDeactivatedColors();
            }
        }

        public void replace(FindEvent findEvent) {
        }

        public void replaceAll(FindEvent findEvent) {
        }
    }

    private class MyDropTarget
    extends DropTarget {
        public MyDropTarget(Component component, DropTargetListener dropTargetListener) {
            super(component, dropTargetListener);
        }

        @Override
        public synchronized void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (CWDragDropImpl.getDragEntered()) {
                return;
            }
            super.dragEnter(dropTargetDragEvent);
        }
    }

    private class CWComponentListener
    extends ComponentAdapter {
        private CWComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            CmdWinMLIF.setCWSize(XCmdWndView.this.getPotentialRows(), XCmdWndView.this.getPotentialColumns());
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            CmdWinMLIF.setCWSize(XCmdWndView.this.getPotentialRows(), XCmdWndView.this.getPotentialColumns());
        }
    }

    private class LayoutScrollPaneOnEventThread
    implements Runnable {
        private LayoutScrollPaneOnEventThread() {
        }

        @Override
        public void run() {
            XCmdWndView.this.doScrollPaneLayout();
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            sCWDoc.setUserInitialized();
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() && (mouseEvent.getModifiers() & 8) != 0 && PlatformInfo.isXWindows()) {
                XCmdWndView.this.setCaretPosition(XCmdWndView.this.viewToModel(mouseEvent.getPoint()));
                try {
                    Transferable transferable = MJClipboard.getMJClipboard().getXSelectionContents((Object)this);
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        CmdWinUndoManager.getInstance().startEditGroup();
                        XCmdWndView.this.processPaste(Prompt.stripPrompts(string));
                        CmdWinUndoManager.getInstance().endEditGroup();
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    Log.logException((Exception)unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    Log.logException((Exception)iOException);
                }
            }
        }

        void showPopup(MouseEvent mouseEvent) {
            Object object;
            if (mouseEvent instanceof MMouseEvent && ((MMouseEvent)mouseEvent).isKeyTriggered() && AltHistory.isPopupShowing()) {
                AltHistory.getInstance().showContextMenu();
                return;
            }
            boolean bl = sXCmdWndView.getSelectionStart() != sXCmdWndView.getSelectionEnd();
            boolean bl2 = false;
            if (mouseEvent instanceof MMouseEvent) {
                bl2 = ((MMouseEvent)mouseEvent).isKeyTriggered();
            }
            if ((MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent) || mouseEvent.isPopupTrigger()) && !bl2 && bl && !XCmdWndView.this.getRecognizer().isClickInSelection(mouseEvent)) {
                ((XCaret)XCmdWndView.this.getCaret()).removeSelection();
            }
            XCmdWndView.this.updateEnablement();
            if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
                XCmdWndView.createPopupMenu().show((Component)object, mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }
        }
    }

    private class CWPrefsListener
    implements PrefListener {
        private CWPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            String string = prefEvent.getPrefKey();
            if (string.equals("CommandWindowWrapLines")) {
                XCmdWndView.this.setWrap();
            } else if (string.equals("CommandWindowSpacesPerTab")) {
                XCmdWndView.this.setTabSizePref();
            } else if (string.equals("CommandWindowMinSessionSize")) {
                XCmdWndView.this.setMaxLines();
            } else if (prefEvent.getPrefKey().equals("ColorsText")) {
                XCmdWndView.this.setCWFgColor();
            } else if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                XCmdWndView.this.setCWBgColor();
            } else if (prefEvent.getPrefKey().equals("Colors_M_")) {
                sErrorColor = ColorPrefs.getColorPref((String)ColorPrefs.M_CATEGORIES[5]);
                XCmdWndView.this.repaint();
            } else if (prefEvent.getPrefKey().equals("Colors_HTML_")) {
                XCmdWndView.this.repaint();
            } else if (prefEvent.getPrefKey().equals("CommandWindowShowFunctionBrowser")) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        XCmdWndView.this.getFunctionBrowserRowHeader();
                    }
                });
            }
        }
    }

    private class CWCaretListener
    implements CaretListener {
        private CWCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (!(XCmdWndView.this.getCaret() instanceof XCaret) && sCWDoc.isInOrBeforeThePrompt(XCmdWndView.this.getCaret().getDot())) {
                XCmdWndView.this.getCaret().setDot(sCWDoc.getPromptLineEndOffset(false));
            }
            XCmdWndView.this.updateEnablement();
        }
    }

    private class CmdWinFontListener
    implements FontListener {
        private CmdWinFontListener() {
        }

        public void fontChanged(Font font) {
            XCmdWndView.this.setCWFont(font);
        }
    }
}

