/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.dataimport;

import com.mathworks.mde.dataimport.CancelEvent;
import com.mathworks.mde.dataimport.FilePreviewEvent;
import com.mathworks.mde.dataimport.FilePreviewListener;
import com.mathworks.mde.dataimport.FinishEvent;
import com.mathworks.mde.dataimport.IVariableContentsOwner;
import com.mathworks.mde.dataimport.ImportCompletionListener;
import com.mathworks.mde.dataimport.ImportWizardContents;
import com.mathworks.mde.dataimport.MultimediaEvent;
import com.mathworks.mde.dataimport.MultimediaListener;
import com.mathworks.mde.dataimport.ValueSpecification;
import com.mathworks.mde.dataimport.VariableListDelimiterEvent;
import com.mathworks.mde.dataimport.VariableListEvent;
import com.mathworks.mde.dataimport.VariableListListener;
import com.mathworks.mde.dataimport.VariablePreviewEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

public class ImportProxy {
    public static final int NUMERIC_PREVIEW_LIMIT = 256;
    public static final int COLON = -1;
    private final List<FilePreviewListener> fFilePreviewListeners = new ArrayList<FilePreviewListener>(2);
    private final List<VariableListListener> fVariableListListeners = new ArrayList<VariableListListener>(2);
    private final List<ImportCompletionListener> fImportCompletionListeners = new ArrayList<ImportCompletionListener>(2);
    private final List<MultimediaListener> fMultimediaListeners = new ArrayList<MultimediaListener>(2);
    private ImportWizardContents fIWC;
    private final List<FilePreviewEvent> fFilePreviewListenersQ = new ArrayList<FilePreviewEvent>();
    private final List<VariablePreviewEvent> fVariablePreviewListenersQ = new ArrayList<VariablePreviewEvent>();
    private final List<VariableListEvent> fVariableListListenersQ = new ArrayList<VariableListEvent>();
    private final List<VariableListDelimiterEvent> fVariableListDelimiterListenersQ = new ArrayList<VariableListDelimiterEvent>();
    private final List<FinishEvent> fFinishListenersQ = new ArrayList<FinishEvent>();
    private final List<CancelEvent> fCancelListenersQ = new ArrayList<CancelEvent>();
    private final List<MultimediaEvent> fMultimediaListenersQ = new ArrayList<MultimediaEvent>();
    private boolean fRegistrationCompleted;
    private boolean fCleanupInitiated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilePreviewListener(FilePreviewListener filePreviewListener) {
        List<FilePreviewListener> list = this.fFilePreviewListeners;
        synchronized (list) {
            if (this.fFilePreviewListeners.contains(filePreviewListener)) {
                this.fFilePreviewListeners.remove(filePreviewListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilePreviewListener(FilePreviewListener filePreviewListener) {
        List<FilePreviewListener> list = this.fFilePreviewListeners;
        synchronized (list) {
            if (!this.fFilePreviewListeners.contains(filePreviewListener)) {
                this.fFilePreviewListeners.add(filePreviewListener);
            }
        }
    }

    protected void fireFilePreviewEvent(FilePreviewEvent filePreviewEvent) {
        if (this.fRegistrationCompleted) {
            for (FilePreviewListener filePreviewListener : this.fFilePreviewListeners) {
                filePreviewListener.filePreviewEvent(filePreviewEvent);
            }
        } else {
            this.fFilePreviewListenersQ.add(filePreviewEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeVariableListListener(VariableListListener variableListListener) {
        List<VariableListListener> list = this.fVariableListListeners;
        synchronized (list) {
            if (this.fVariableListListeners.contains(variableListListener)) {
                this.fVariableListListeners.remove(variableListListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVariableListListener(VariableListListener variableListListener) {
        List<VariableListListener> list = this.fVariableListListeners;
        synchronized (list) {
            if (!this.fVariableListListeners.contains(variableListListener)) {
                this.fVariableListListeners.add(variableListListener);
            }
        }
    }

    protected void fireVariableListEvent(VariableListEvent variableListEvent) {
        if (this.fRegistrationCompleted) {
            for (VariableListListener variableListListener : this.fVariableListListeners) {
                variableListListener.variableListEvent(variableListEvent);
            }
        } else {
            this.fVariableListListenersQ.add(variableListEvent);
        }
    }

    protected void fireVariableListDelimiterEvent(VariableListDelimiterEvent variableListDelimiterEvent) {
        if (this.fRegistrationCompleted) {
            for (VariableListListener variableListListener : this.fVariableListListeners) {
                variableListListener.variableListDelimiterEvent(variableListDelimiterEvent);
            }
        } else {
            this.fVariableListDelimiterListenersQ.add(variableListDelimiterEvent);
        }
    }

    protected void fireVariablePreviewEvent(VariablePreviewEvent variablePreviewEvent) {
        if (this.fRegistrationCompleted) {
            for (VariableListListener variableListListener : this.fVariableListListeners) {
                variableListListener.variablePreviewEvent(variablePreviewEvent);
            }
        } else {
            this.fVariablePreviewListenersQ.add(variablePreviewEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrationCompleted() {
        this.fRegistrationCompleted = true;
        List<EventObject> list = this.fFilePreviewListenersQ;
        synchronized (list) {
            if (!this.fFilePreviewListenersQ.isEmpty()) {
                for (FilePreviewEvent eventObject : this.fFilePreviewListenersQ) {
                    this.fireFilePreviewEvent(eventObject);
                }
                this.fFilePreviewListenersQ.clear();
            }
        }
        list = this.fVariablePreviewListenersQ;
        synchronized (list) {
            if (!this.fVariablePreviewListenersQ.isEmpty()) {
                for (VariablePreviewEvent variablePreviewEvent : this.fVariablePreviewListenersQ) {
                    this.fireVariablePreviewEvent(variablePreviewEvent);
                }
                this.fVariablePreviewListenersQ.clear();
            }
        }
        list = this.fVariableListListenersQ;
        synchronized (list) {
            if (!this.fVariableListListenersQ.isEmpty()) {
                for (VariableListEvent variableListEvent : this.fVariableListListenersQ) {
                    this.fireVariableListEvent(variableListEvent);
                }
                this.fVariableListListenersQ.clear();
            }
        }
        list = this.fVariableListDelimiterListenersQ;
        synchronized (list) {
            if (!this.fVariableListDelimiterListenersQ.isEmpty()) {
                for (VariableListDelimiterEvent variableListDelimiterEvent : this.fVariableListDelimiterListenersQ) {
                    this.fireVariableListDelimiterEvent(variableListDelimiterEvent);
                }
                this.fVariableListDelimiterListenersQ.clear();
            }
        }
        list = this.fFinishListenersQ;
        synchronized (list) {
            if (!this.fFinishListenersQ.isEmpty()) {
                for (FinishEvent finishEvent : this.fFinishListenersQ) {
                    this.fireFinishEvent(finishEvent);
                }
                this.fFinishListenersQ.clear();
            }
        }
        list = this.fCancelListenersQ;
        synchronized (list) {
            if (!this.fCancelListenersQ.isEmpty()) {
                for (CancelEvent cancelEvent : this.fCancelListenersQ) {
                    this.fireCancelEvent(cancelEvent);
                }
                this.fCancelListenersQ.clear();
            }
        }
        list = this.fMultimediaListenersQ;
        synchronized (list) {
            if (!this.fMultimediaListenersQ.isEmpty()) {
                for (MultimediaEvent multimediaEvent : this.fMultimediaListenersQ) {
                    this.fireMultimediaEvent(multimediaEvent);
                }
                this.fMultimediaListenersQ.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImportCompletionListener(ImportCompletionListener importCompletionListener) {
        List<ImportCompletionListener> list = this.fImportCompletionListeners;
        synchronized (list) {
            if (this.fImportCompletionListeners.contains(importCompletionListener)) {
                this.fImportCompletionListeners.remove(importCompletionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImportCompletionListener(ImportCompletionListener importCompletionListener) {
        List<ImportCompletionListener> list = this.fImportCompletionListeners;
        synchronized (list) {
            if (!this.fImportCompletionListeners.contains(importCompletionListener)) {
                this.fImportCompletionListeners.add(importCompletionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFinishEvent(FinishEvent finishEvent) {
        if (this.fRegistrationCompleted) {
            List<ImportCompletionListener> list = this.fImportCompletionListeners;
            synchronized (list) {
                for (ImportCompletionListener importCompletionListener : this.fImportCompletionListeners) {
                    importCompletionListener.finishEvent(finishEvent);
                }
            }
        } else {
            this.fFinishListenersQ.add(finishEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCancelEvent(CancelEvent cancelEvent) {
        if (this.fRegistrationCompleted) {
            List<ImportCompletionListener> list = this.fImportCompletionListeners;
            synchronized (list) {
                for (ImportCompletionListener importCompletionListener : this.fImportCompletionListeners) {
                    importCompletionListener.cancelEvent(cancelEvent);
                }
            }
        } else {
            this.fCancelListenersQ.add(cancelEvent);
        }
    }

    ImportProxy(ImportWizardContents importWizardContents) {
        this.fIWC = importWizardContents;
        this.fRegistrationCompleted = false;
    }

    void requestFilePreview(File file) {
        this.fireFilePreviewEvent(new FilePreviewEvent(this, file));
    }

    void requestVariableList(String string) {
        this.fireVariableListEvent(new VariableListEvent(this, string));
    }

    void requestVariableListDelimiter(String string, int n) {
        this.fireVariableListDelimiterEvent(new VariableListDelimiterEvent(this, string, n));
    }

    void requestFinish(int n, String string, String[] stringArray, String[] stringArray2, String[] stringArray3, boolean bl) {
        this.fireFinishEvent(new FinishEvent(this, string, n, stringArray, stringArray2, stringArray3, bl));
    }

    void requestCancel() {
        this.fireCancelEvent(new CancelEvent(this));
    }

    public void reportFilePreview(String string, int n, String string2, String[] stringArray) {
        if (!this.fCleanupInitiated) {
            this.fIWC.setPreviewTextContents(string, n, string2, stringArray);
        }
    }

    public void reportVariableList(int n, String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, String string) {
        if (!this.fCleanupInitiated) {
            this.fIWC.setPreviewTabList(n, stringArray, stringArray2, lArray, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7, string);
        }
    }

    public void reportVariableListDelimiter(String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) {
        if (!this.fCleanupInitiated) {
            this.fIWC.setPreviewTabListDelimiter(stringArray, stringArray2, lArray, stringArray3, stringArray4, stringArray5, stringArray6, stringArray7);
        }
    }

    public void reportVariablePreview(IVariableContentsOwner iVariableContentsOwner, String string, int n, int n2, String string2, String string3, String string4) {
        if (!this.fCleanupInitiated) {
            ImportWizardContents.addVariablePreviewData(iVariableContentsOwner, new ValueSpecification(string, n, n2, string2), string3);
        }
    }

    public void reportVariablePreview(IVariableContentsOwner iVariableContentsOwner, String string, int n, int n2, String string2, double[][] dArray, double[][] dArray2) {
        if (!this.fCleanupInitiated) {
            ImportWizardContents.addVariablePreviewData(iVariableContentsOwner, new ValueSpecification(string, n, n2, string2), dArray, dArray2);
        }
    }

    public void reportVariablePreview(IVariableContentsOwner iVariableContentsOwner, String string, int n, int n2, String string2, int[][] nArray, int[][] nArray2) {
        if (!this.fCleanupInitiated) {
            ImportWizardContents.addVariablePreviewData(iVariableContentsOwner, new ValueSpecification(string, n, n2, string2), nArray, nArray2);
        }
    }

    void requestVariablePreviewData(IVariableContentsOwner iVariableContentsOwner, ValueSpecification valueSpecification) {
        this.fireVariablePreviewEvent(new VariablePreviewEvent(this, iVariableContentsOwner, valueSpecification));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMultimediaListener(MultimediaListener multimediaListener) {
        List<MultimediaListener> list = this.fMultimediaListeners;
        synchronized (list) {
            if (this.fMultimediaListeners.contains(multimediaListener)) {
                this.fMultimediaListeners.remove(multimediaListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMultimediaListener(MultimediaListener multimediaListener) {
        List<MultimediaListener> list = this.fMultimediaListeners;
        synchronized (list) {
            if (!this.fMultimediaListeners.contains(multimediaListener)) {
                this.fMultimediaListeners.add(multimediaListener);
            }
        }
    }

    protected void fireMultimediaEvent(MultimediaEvent multimediaEvent) {
        if (this.fRegistrationCompleted) {
            for (MultimediaListener multimediaListener : this.fMultimediaListeners) {
                multimediaListener.multimediaEvent(multimediaEvent);
            }
        } else {
            this.fMultimediaListenersQ.add(multimediaEvent);
        }
    }

    void requestImagePreview(File file) {
        this.fireMultimediaEvent(new MultimediaEvent(this, file, 2));
    }

    void requestMoviePreview(File file) {
        this.fireMultimediaEvent(new MultimediaEvent(this, file, 1));
    }

    void requestSoundPreview(File file) {
        this.fireMultimediaEvent(new MultimediaEvent(this, file, 3));
    }

    public void cleanup() {
        this.fCleanupInitiated = true;
        this.fFilePreviewListeners.clear();
        this.fVariableListListeners.clear();
        this.fImportCompletionListeners.clear();
        this.fMultimediaListeners.clear();
        this.fFilePreviewListenersQ.clear();
        this.fVariablePreviewListenersQ.clear();
        this.fVariableListListenersQ.clear();
        this.fVariableListDelimiterListenersQ.clear();
        this.fFinishListenersQ.clear();
        this.fCancelListenersQ.clear();
        this.fMultimediaListenersQ.clear();
        this.fIWC = null;
    }
}

