/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.dataimport;

import com.mathworks.mde.dataimport.ImportUtils;
import com.mathworks.mlwidgets.workspace.VariableRecordlistModel;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.widgets.recordlist.IEditingObserver;
import com.mathworks.widgets.recordlist.IRecordEditor;
import com.mathworks.widgets.recordlist.RecordlistModelEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ImportVariableListModel
extends VariableRecordlistModel
implements IRecordEditor {
    protected String[] fNames;
    protected String[] fSizes;
    protected Long[] fBytes;
    protected String[] fClasses;
    protected Boolean[] fChecked;
    protected Hashtable fRenamedVariables = new Hashtable();

    protected int CHECKED() {
        return 0;
    }

    public int NAME() {
        return super.NAME() + 1;
    }

    public int SIZE() {
        return super.SIZE() + 1;
    }

    public int BYTES() {
        return super.BYTES() + 1;
    }

    public int CLASS() {
        return super.CLASS() + 1;
    }

    public ImportVariableListModel() {
        this(new String[0], new String[0], new long[0], new String[0]);
    }

    public ImportVariableListModel(String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3) {
        this.setData(stringArray, stringArray2, lArray, stringArray3);
    }

    public void setData(String[] stringArray, String[] stringArray2, long[] lArray, String[] stringArray3) {
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            longArray[i] = new Long(lArray[i]);
        }
        this.setData(stringArray, stringArray2, longArray, stringArray3);
    }

    public void setData(String[] stringArray, String[] stringArray2, Long[] longArray, String[] stringArray3) {
        this.fNames = stringArray;
        this.fSizes = stringArray2;
        this.fBytes = longArray;
        this.fClasses = stringArray3;
        Boolean[] booleanArray = new Boolean[this.fNames.length];
        for (int i = 0; i < booleanArray.length; ++i) {
            booleanArray[i] = Boolean.TRUE;
            this.fRenamedVariables.put(this.fNames[i], this.fNames[i]);
        }
        this.fChecked = booleanArray;
        this.refreshUIs();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == this.CHECKED()) {
            return this.fChecked[n];
        }
        if (n2 == this.NAME()) {
            return this.fRenamedVariables.get(this.fNames[n]);
        }
        if (n2 == this.SIZE()) {
            return this.fSizes[n];
        }
        if (n2 == this.BYTES()) {
            return this.fBytes[n];
        }
        if (n2 == this.CLASS()) {
            return this.fClasses[n];
        }
        return "";
    }

    public int getRecordCount() {
        if (this.fNames != null) {
            return this.fNames.length;
        }
        return 0;
    }

    public int getFieldCount() {
        return 5;
    }

    public String getFieldName(int n) {
        if (n == 0) {
            return ImportUtils.getResource("ivlm.importField");
        }
        return super.getFieldName(n);
    }

    public Class getFieldClass(int n) {
        if (n == this.CHECKED()) {
            return Boolean.class;
        }
        return super.getFieldClass(n);
    }

    public String[] getEditingDescriptions() {
        return new String[]{ImportUtils.getResource("ivlm.importDescription"), ImportUtils.getResource("ivlm.renameDescription")};
    }

    public int[] getEditableFields() {
        int[] nArray = new int[]{this.CHECKED(), this.NAME()};
        return nArray;
    }

    public boolean areRecordsEditable(int[] nArray, int n) {
        return nArray.length == 1 && (n == this.CHECKED() || n == this.NAME());
    }

    public void setRecordValues(int[] nArray, int n, Object[] objectArray, IEditingObserver iEditingObserver) {
        if (n == this.CHECKED()) {
            for (int i = 0; i < nArray.length; ++i) {
                this.fChecked[nArray[i]] = (Boolean)objectArray[i];
            }
        }
        if (n == this.NAME() && nArray.length == 1 && objectArray.length == 1) {
            Object object = objectArray[0];
            if (object.equals(this.getValueAt(nArray[0], this.NAME()))) {
                return;
            }
            if (!WorkspaceCommands.isValidVariableName((String)((String)object))) {
                String string = WorkspaceResources.getBundle().getString("dialog.badname.pre.message");
                String string2 = WorkspaceResources.getBundle().getString("dialog.badname.message.addendum");
                Object[] objectArray2 = new Object[]{object};
                String string3 = MessageFormat.format(string, objectArray2) + string2;
                iEditingObserver.editingCompleted(2, string3);
                return;
            }
            Object object2 = this.getValueAt(nArray[0], n);
            if (this.fRenamedVariables.containsValue(object)) {
                String string = ImportUtils.getResource("ivlm.renameConflict");
                Object[] objectArray3 = new Object[]{object};
                String string4 = MessageFormat.format(string, objectArray3);
                iEditingObserver.editingCompleted(2, string4);
                return;
            }
            if (this.fRenamedVariables.containsValue(object2)) {
                Enumeration enumeration = this.fRenamedVariables.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (!this.fRenamedVariables.get(k).equals(object2)) continue;
                    this.fRenamedVariables.put(k, object);
                }
            } else {
                this.fRenamedVariables.put(object2, object);
            }
        }
        this.refreshUIs();
    }

    private void refreshUIs() {
        this.fireRecordlistModelEvent(new RecordlistModelEvent());
    }

    String[] getApprovedVariables() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.fChecked.length; ++i) {
            if (!this.fChecked[i].booleanValue()) continue;
            vector.add(this.fNames[i]);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    String[] getApprovedNewVariables() {
        String[] stringArray = this.getApprovedVariables();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)this.fRenamedVariables.get(stringArray[i]);
        }
        return stringArray2;
    }

    String getTrueName(String string) {
        String string2 = string;
        if (this.fRenamedVariables.containsValue(string)) {
            Enumeration enumeration = this.fRenamedVariables.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (!this.fRenamedVariables.get(k).equals(string)) continue;
                string2 = (String)k;
            }
        }
        return string2;
    }

    public int getPresortFieldIndex() {
        return -1;
    }

    public int getPresortFieldOrder() {
        return 0;
    }
}

