/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MLExecutionEvent;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mwswing.MJOptionPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;

class MLDesktopShutdownHelper {
    private static Component sCommandWindow;
    private static MatlabMCR sMatlabMCR;
    private boolean fExitDialogShowing;
    private static volatile boolean sExitPending;
    private static volatile boolean sExitStartingPosted;
    private static final int EXIT_GRACE_MS = 2000;
    private static final int INTERRUPT_GRACE_MS = 8000;
    private static final int EXIT_DIALOG_DURATION_SECS = 20;
    private static AtomicReference<ExitStatus> sExitStatus;
    private static volatile boolean sInterpreterReady;
    private static JDialog sExitDialog;
    private static JDialog sBigHammerDialog;
    private static Timer sBigHammerTimer;
    private static Timer sExitGraceTimer;

    protected MLDesktopShutdownHelper() {
        MLExecuteServices.addMLExecutionListener((MLExecutionListener)new MLExecutionListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                sInterpreterReady = ((MLExecutionEvent)changeEvent).isCommandOver();
            }
        });
        if (sMatlabMCR == null) {
            sMatlabMCR = new MatlabMCR();
        }
        Matlab.registerExitStartPredicate((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                MLDesktopShutdownHelper.dismissExitDialogs();
                sExitPending = false;
                if (sExitStatus.get() == ExitStatus.CANCELED) {
                    return false;
                }
                sExitStatus.set(ExitStatus.STARTED);
                return true;
            }
        });
        Matlab.registerExitCanceledPredicate((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                sExitStatus.set(ExitStatus.NONE);
                return true;
            }
        });
    }

    protected void attemptMatlabExit(Component component) {
        sCommandWindow = component;
        if (sExitPending) {
            return;
        }
        sExitStatus.compareAndSet(ExitStatus.CANCELED, ExitStatus.NONE);
        if (!sInterpreterReady) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!sInterpreterReady) {
                this.displayDelayedExitDialog();
            }
        }
        if (sInterpreterReady) {
            sExitGraceTimer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MLDesktopShutdownHelper.this.fExitDialogShowing || sExitStatus.get() == ExitStatus.STARTED) {
                        return;
                    }
                    MLDesktopShutdownHelper.this.displayDelayedExitDialog();
                }
            });
            sExitGraceTimer.setRepeats(false);
            sExitGraceTimer.start();
        }
        try {
            sExitPending = true;
            if (!sExitStartingPosted) {
                this.issueExitCommand();
                sExitStartingPosted = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void issueExitCommand() {
        sMatlabMCR.evalConsoleOutput("com.mathworks.mde.desk.MLDesktopShutdownHelper.exitStarting");
        sMatlabMCR.fevalConsoleOutput("builtin", new Object[]{"exit"});
    }

    public static void exitStarting() {
        sExitStartingPosted = false;
        MLDesktopShutdownHelper.dismissExitDialogs();
    }

    private void displayDelayedExitDialog() {
        this.fExitDialogShowing = true;
        SwingUtilities.invokeLater(new Runnable(){
            private int fSecsToDie = 20;

            @Override
            public void run() {
                if (sExitStatus.get() != ExitStatus.NONE) {
                    return;
                }
                if (!sExitPending) {
                    return;
                }
                String string = MLDesktop.sMLRes.getString("button.DontExit");
                final String string2 = MLDesktop.sMLRes.getString("button.ExitNow");
                final MJOptionPane mJOptionPane = new MJOptionPane((Object)MessageFormat.format(MLDesktop.sMLRes.getString("error.ScriptRunning"), this.fSecsToDie), 1, 0, null, (Object[])new String[]{string2, string}, (Object)string);
                sExitDialog = mJOptionPane.createDialog(sCommandWindow, MLDesktop.sMLRes.getString("title.MatlabBusy"));
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (sExitStatus.get() == ExitStatus.STARTED || !mJOptionPane.isVisible()) {
                            ((Timer)actionEvent.getSource()).stop();
                        } else {
                            if (fSecsToDie == 1) {
                                mJOptionPane.setValue((Object)string2);
                            }
                            mJOptionPane.setMessage((Object)MessageFormat.format(MLDesktop.sMLRes.getString("error.ScriptRunning"), fSecsToDie--));
                        }
                    }
                });
                timer.start();
                sExitDialog.setVisible(true);
                Object object = mJOptionPane.getValue();
                sExitDialog = null;
                MLDesktopShutdownHelper.this.fExitDialogShowing = false;
                if (!sExitPending) {
                    return;
                }
                if (object == string2) {
                    sMatlabMCR.interrupt();
                    sBigHammerTimer = new Timer(8000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (sExitStatus.get() != ExitStatus.NONE) {
                                return;
                            }
                            if (!sExitPending) {
                                return;
                            }
                            String string = MLDesktop.sMLRes.getString("button.Cancel");
                            String string2 = MLDesktop.sMLRes.getString("button.EndNow");
                            MJOptionPane mJOptionPane = new MJOptionPane((Object)MLDesktop.sMLRes.getString("error.KillMatlab"), 0, 0, null, (Object[])new String[]{string2, string}, (Object)string);
                            sBigHammerDialog = mJOptionPane.createDialog(sCommandWindow, MLDesktop.sMLRes.getString("title.NotResponding"));
                            sBigHammerDialog.setVisible(true);
                            Object object = mJOptionPane.getValue();
                            if (!sExitPending) {
                                return;
                            }
                            if (object == string2) {
                                Matlab.nativeFlDiagTerminate((String)"Killed by User Request");
                            }
                            sExitStatus.compareAndSet(ExitStatus.NONE, ExitStatus.CANCELED);
                            sExitPending = false;
                        }
                    });
                    sBigHammerTimer.setRepeats(false);
                    sBigHammerTimer.start();
                } else if (object == string || object == null) {
                    sExitStatus.compareAndSet(ExitStatus.NONE, ExitStatus.CANCELED);
                    sExitPending = false;
                }
            }
        });
    }

    private static void dismissExitDialogs() {
        sExitPending = false;
        if (sBigHammerTimer != null) {
            sBigHammerTimer.stop();
            sBigHammerTimer = null;
        }
        if (sExitGraceTimer != null) {
            sExitGraceTimer.stop();
            sExitGraceTimer = null;
        }
        if (sExitDialog != null || sBigHammerDialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (sExitDialog != null) {
                        sExitDialog.setVisible(false);
                        sExitDialog.dispose();
                        sExitDialog = null;
                    }
                    if (sBigHammerDialog != null) {
                        sBigHammerDialog.setVisible(false);
                        sBigHammerDialog.dispose();
                        sBigHammerDialog = null;
                    }
                }
            });
        }
    }

    static {
        sExitPending = false;
        sExitStartingPosted = false;
        sExitStatus = new AtomicReference<ExitStatus>(ExitStatus.NONE);
        sInterpreterReady = true;
        sExitDialog = null;
        sBigHammerDialog = null;
        sBigHammerTimer = null;
        sExitGraceTimer = null;
    }

    private static enum ExitStatus {
        NONE,
        STARTED,
        CANCELED;

    }
}

