/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.desk;

import com.google.common.collect.ImmutableList;
import com.mathworks.desktop.mnemonics.Mnemonic;
import com.mathworks.desktop.mnemonics.MnemonicPath;
import com.mathworks.desktop.mnemonics.MnemonicsManagers;
import com.mathworks.desktop.overlay.AnchorPosition;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayConstraints;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMainFrame;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.util.async.Status;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMnemonicsProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MLMnemonicsProvider
extends DTMnemonicsProvider {
    private static final String[] FILE_MNEMONIC_TEXT = new String[]{"O", "C", "S", "A", "I", "W", "F", "H", "G", "P", "T"};
    private static final String[] ACTION_NAME = new String[]{null, DTMenuMergeTag.CLOSE.toString(), DTMenuMergeTag.SAVE.toString(), DTMenuMergeTag.SAVE_AS.toString(), null, null, null, null, DTMenuMergeTag.PAGE_SETUP.toString(), DTMenuMergeTag.PRINT.toString(), DTMenuMergeTag.PRINT_SELECTION.toString()};
    private Map<String, ItemProxy> fItemProxyMap = new HashMap<String, ItemProxy>();
    private Overlay fMessageOverlay;
    private ContextTargetingManager fTargetingManager;

    MLMnemonicsProvider(DTFrame dTFrame) {
        super(dTFrame);
        ItemProxy itemProxy;
        for (int i = 0; i < FILE_MNEMONIC_TEXT.length; ++i) {
            itemProxy = new ItemProxy();
            dTFrame.getTargetingManager().register(ACTION_NAME[i], (AbstractButton)itemProxy);
            this.fItemProxyMap.put(FILE_MNEMONIC_TEXT[i], itemProxy);
        }
        MLDesktop mLDesktop = (MLDesktop)dTFrame.getDesktop();
        itemProxy = new ItemProxy(mLDesktop.getOpenAction());
        this.fTargetingManager = dTFrame.getTargetingManager();
        this.fTargetingManager.register(DTMenuMergeTag.OPEN.toString(), (AbstractButton)itemProxy);
        this.fItemProxyMap.put("O", itemProxy);
        this.fItemProxyMap.put("I", new ItemProxy(mLDesktop.getImportAction()));
        this.fItemProxyMap.put("W", new ItemProxy(mLDesktop.getSaveWorkspaceAction()));
        this.fItemProxyMap.put("F", new ItemProxy(mLDesktop.getPreferencesAction()));
        this.fItemProxyMap.put("H", new ItemProxy(mLDesktop.getSetPathAction()));
        if (dTFrame.isMainFrame()) {
            this.fItemProxyMap.put("X", new ItemProxy(mLDesktop.getQuitAction()));
        }
    }

    public void dispose() {
        this.fTargetingManager.unregister(DTMenuMergeTag.OPEN.toString(), (AbstractButton)this.fItemProxyMap.get("O"));
    }

    protected void gatherMnemonics(@NotNull MnemonicPath mnemonicPath, List<Mnemonic> list) {
        String[] stringArray;
        super.gatherMnemonics(mnemonicPath, list);
        if (mnemonicPath.isEmpty() && this.fFrame.isMainFrame() && (stringArray = ((MLMainFrame)this.fFrame).getSearchComponent()) != null) {
            list.add(new Mnemonic((JComponent)stringArray){
                final /* synthetic */ JComponent val$searchField;
                {
                    this.val$searchField = jComponent;
                }

                @NotNull
                public String getMnemonic() {
                    return "D";
                }

                @NotNull
                public Point getLocationOnComponent() {
                    return new Point(12, this.val$searchField.getHeight());
                }

                @NotNull
                public JComponent getComponent() {
                    return this.val$searchField;
                }
            });
        }
        if (mnemonicPath.isEmpty()) {
            list.add(new InvisibleMnemonic("F"));
        } else if (mnemonicPath.getPath().size() == 1) {
            for (String string : FILE_MNEMONIC_TEXT) {
                list.add(new InvisibleMnemonic(string));
            }
            if (this.fFrame.isMainFrame()) {
                list.add(new InvisibleMnemonic("X"));
            }
        }
    }

    @NotNull
    public Status<Component> select(@NotNull MnemonicPath mnemonicPath) {
        Action action;
        Mnemonic mnemonic;
        ItemProxy itemProxy;
        ImmutableList immutableList = mnemonicPath.getPath();
        if (immutableList.size() == 1) {
            Mnemonic mnemonic2 = (Mnemonic)immutableList.get(0);
            switch (mnemonic2.getMnemonic().charAt(0)) {
                case 'D': {
                    return new Status.Fail((Object)mnemonic2.getComponent());
                }
                case 'F': {
                    OverlayManager overlayManager = OverlayManagers.get((Component)this.fFrame.getRootPane());
                    if (overlayManager != null) {
                        LegacyMessagePanel legacyMessagePanel = new LegacyMessagePanel();
                        Dimension dimension = ((JComponent)((Object)legacyMessagePanel)).getPreferredSize();
                        this.fMessageOverlay = overlayManager.addOverlay((Component)((Object)legacyMessagePanel), new OverlayConstraints((Component)this.fFrame.getRootPane(), AnchorPosition.NORTHWEST, 0, 0, dimension.width, dimension.height, 1000, Overlay.Mode.AUTO));
                    }
                    return new Status.Success((Object)mnemonic2.getComponent());
                }
            }
        } else if (immutableList.size() == 2 && (itemProxy = this.fItemProxyMap.get((mnemonic = (Mnemonic)immutableList.get(1)).getMnemonic())) != null && (action = itemProxy.getAction()) != null && action.isEnabled()) {
            TSUtil.toolstripActionProcessed((Component)mnemonic.getComponent());
            this.hideMessage();
            action.actionPerformed(new ActionEvent(this.fFrame, 1001, ""));
            return new Status.Fail(null);
        }
        return super.select(mnemonicPath);
    }

    public Status<Component> cancel(@NotNull MnemonicPath mnemonicPath) {
        this.hideMessage();
        MnemonicsManagers.get().clear();
        return new Status.Success();
    }

    private void hideMessage() {
        if (this.fMessageOverlay != null) {
            OverlayManager overlayManager = OverlayManagers.get((Component)this.fFrame.getRootPane());
            if (overlayManager != null) {
                overlayManager.removeOverlay(this.fMessageOverlay);
            }
            this.fMessageOverlay = null;
        }
    }

    private class LegacyMessagePanel
    extends MJPanel {
        private LegacyMessagePanel() {
            super((LayoutManager)new BorderLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.darkGray), BorderFactory.createEmptyBorder(4, 6, 4, 6)));
            MJLabel mJLabel = new MJLabel("Alt+F:");
            mJLabel.setFont(mJLabel.getFont().deriveFont(1));
            mJLabel.setOpaque(false);
            this.add((Component)mJLabel, "North");
            MJTextArea mJTextArea = new MJTextArea();
            mJTextArea.setText(MLDesktop.sMLRes.getString("message.LegacyMnemonics"));
            mJTextArea.setEditable(false);
            mJTextArea.setOpaque(false);
            InputMap inputMap = new InputMap();
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "noop");
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "noop");
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "noop");
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "noop");
            inputMap.setParent(mJTextArea.getInputMap(0));
            mJTextArea.setInputMap(0, inputMap);
            this.add((Component)mJTextArea, "Center");
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(240, 240, 240), 0.0f, this.getHeight(), new Color(216, 216, 216)));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private class ItemProxy
    extends JMenuItem {
        private ItemProxy() {
            this((Action)new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.getAction().setEnabled(false);
        }

        private ItemProxy(Action action) {
            this.setAction(action);
        }
    }

    private class InvisibleMnemonic
    implements Mnemonic {
        private final String iMnemonicText;

        private InvisibleMnemonic(String string) {
            this.iMnemonicText = string;
        }

        @NotNull
        public String getMnemonic() {
            return this.iMnemonicText;
        }

        @Nullable
        public Point getLocationOnComponent() {
            return null;
        }

        @NotNull
        public JComponent getComponent() {
            return MLMnemonicsProvider.this.fFrame.getRootPane();
        }
    }
}

