/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.MFilePathUtil;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.FileSystemAdapter;
import com.mathworks.util.FileSystemListener;
import com.mathworks.util.FileSystemUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class EditorStartup {
    private static final FileSystemListener sFileSystemListener;
    private static volatile boolean sDBStopRegistered;
    private static volatile boolean sDebugging;
    private static boolean sDebugActivate;

    public static void addDebugObserver(MatlabDebugObserver matlabDebugObserver) {
        MatlabDebugServices.addDefaultObserverListener((MatlabDebugObserver)matlabDebugObserver);
    }

    static void removeDebugObserver(MatlabDebugObserver matlabDebugObserver) {
        MatlabDebugServices.removeDefaultObserverListener((MatlabDebugObserver)matlabDebugObserver);
    }

    private EditorStartup() {
    }

    static Desktop getParentDesktop() {
        return MLDesktop.getInstance();
    }

    public static boolean getInDebugMode() {
        return sDebugging;
    }

    private static void setInDebugMode(boolean bl) {
        sDebugging = bl;
    }

    static boolean wasDebugActivated() {
        return sDebugActivate;
    }

    private static void debugStopFromCCode(String string, int n, boolean bl) {
        sDebugActivate = bl;
        if (!sDBStopRegistered && MatlabDebugServices.isGraphicalDebuggingEnabled()) {
            Editor editor = MLEditorServices.getEditorApplication().openEditorForExistingFile(new File(string));
            editor.goToLine(n, true);
            editor.bringToFront();
        }
    }

    static String intlString(String string) {
        return EditorUtils.lookup(string);
    }

    private static void openFile(final String string, final int n) {
        if (EditorStartup.shouldBlockFileFromBeingDebuggedInMatlabEditor(string)) {
            return;
        }
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!string.trim().startsWith("<") && !string.trim().endsWith(">") && new File(string).exists()) {
                    MLEditorServices.getEditorApplication().openEditorForDebug(new File(MFilePathUtil.mapPFileToMFile(string)), n + 1);
                }
            }
        });
    }

    public static boolean shouldBlockFileFromBeingDebuggedInMatlabEditor(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return FilenameUtils.isExtension((String)string, (String)"mlapp");
    }

    public static String[] getClassNames() {
        return new String[]{"com.mathworks.mde.editor.EditorSyntaxTextPane", "com.mathworks.mde.editor.EditorViewClient", "com.mathworks.mde.editor.plugins.matlab.MatlabBreakpointMarginImpl", "com.mathworks.mde.editor.ExecutionArrowDisplay", "com.mathworks.mde.editor.EditorView", "com.mathworks.mde.editor.codepad.Codepad", "com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPluginUtils", "com.mathworks.mlwidgets.stack.StackComboBox", "com.mathworks.widgets.SyntaxTextPane", "com.mathworks.widgets.text.PrintableDocument", "com.mathworks.widgets.text.TextDragAndDrop", "com.mathworks.widgets.text.MWKit", "com.mathworks.widgets.text.MWEditorUI", "com.mathworks.widgets.text.MWStatusBar", "com.mathworks.widgets.text.MWToolTipSupport", "com.mathworks.widgets.text.mcode.MFormatter", "com.mathworks.widgets.text.mcode.CmdManager", "com.mathworks.widgets.text.matlab.MatlabSyntaxSupport", "com.mathworks.mwswing.undo.MUndoManager", "org.netbeans.editor.ActionFactory", "org.netbeans.editor.BaseKit", "org.netbeans.editor.AcceptorFactory", "org.netbeans.editor.FinderFactory", "org.netbeans.editor.Registry", "org.netbeans.editor.LineRootElement", "org.netbeans.editor.MarkChain", "org.netbeans.editor.FindSupport", "org.netbeans.editor.ext.ExtKit", "org.netbeans.editor.MultiKeymap", "org.netbeans.editor.LeafView", "org.netbeans.editor.SettingsUtil", "org.netbeans.editor.Analyzer", "org.netbeans.editor.FontMetricsCache", "org.netbeans.editor.Annotations", "org.netbeans.editor.ext.plain.PlainSyntax", "org.netbeans.editor.DrawEngine", "org.netbeans.editor.DrawEngineLineView", "org.netbeans.editor.DrawLayerList", "org.netbeans.editor.GapStart", "org.netbeans.editor.DocumentContent", "org.netbeans.editor.FixLineSyntaxState", "com.mathworks.widgets.Tokenizer", "com.mathworks.widgets.text.matlab.MatlabSyntax", "com.mathworks.widgets.text.mcode.MLexer", "com.mathworks.widgets.text.matlab.MatlabState", "com.mathworks.widgets.text.matlab.MatlabTokenInfo", "com.mathworks.mlservices.MLEditorServices", "com.mathworks.widgets.datamodel.AbstractBackingStore", "com.mathworks.widgets.datamodel.TextFileBackingStore", "com.mathworks.widgets.SyntaxTextPaneUtilities", "com.mathworks.mde.editor.TextFileUiInfoProvider", "com.mathworks.widgets.text.mcode.MFoldManagerFactory", "org.netbeans.spi.editor.fold.FoldManager", "org.netbeans.editor.JumpList", "com.mathworks.widgets.text.MWDrawLayerFactory", "com.mathworks.widgets.text.mcode.MEditorUI", "com.mathworks.widgets.LightButton", "com.mathworks.widgets.tooltip.BalloonToolTip", "com.mathworks.widgets.text.mcode.MLint", "com.mathworks.widgets.tooltip.MBalloonTip", "com.mathworks.widgets.text.matlab.MatlabCaret", "com.mathworks.mde.editor.MatlabEditor", "com.mathworks.widgets.text.mcode.MFoldInfoCollector"};
    }

    private static FileSystemListener createFileSystemListenerThatReassociatesFileWithOwningApplication() {
        return new FileSystemAdapter(){

            public void fileCreated(File file) {
                MLFileUtils.resetFileType((File)file);
            }

            public void fileChanged(File file) {
                MLFileUtils.resetFileType((File)file);
            }
        };
    }

    static {
        sDBStopRegistered = false;
        sDebugging = false;
        sDebugActivate = false;
        sFileSystemListener = EditorStartup.createFileSystemListenerThatReassociatesFileWithOwningApplication();
        FileSystemUtils.getFileSystemNotifier().addFileSystemListener(sFileSystemListener);
        if (EditorUtils.isMatlabAvailable() && !GraphicsEnvironment.isHeadless()) {
            EditorStartup.addDebugObserver((MatlabDebugObserver)new MatlabDebugAdapter(){

                public void doDBStop(String string, int n) {
                    if (!MatlabDebugServices.isMatlabKeyboardMode()) {
                        EditorStartup.openFile(string, n);
                    }
                }

                public void doDbupDbdownChange(String string, int n) {
                    EditorStartup.openFile(string, n);
                }

                public void doDebugMode(boolean bl) {
                    sDBStopRegistered = true;
                    EditorStartup.setInDebugMode(bl);
                }
            });
        }
    }
}

