/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.codepad;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorToolstripTabContributor;
import com.mathworks.mde.editor.ActionManager;
import com.mathworks.mde.editor.EditorToolSetFactory;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.codepad.CodepadActionManager;
import com.mathworks.mde.editor.codepad.PublishMenu;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Disposable;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.ToolstripInfoRegistrar;
import java.io.IOException;
import java.net.URL;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import org.apache.commons.lang.Validate;

public class CodepadToolSetFactory {
    private static final TSTabConfiguration TAB_CONFIG = CodepadToolSetFactory.readTabConfiguration();
    private static final TSToolSetContents CONTENTS = CodepadToolSetFactory.readToolSetContents();
    private final Editor fEditor;
    private final ActionManager fActionManager;
    private TSToolSet fToolSet;
    private CodepadActionManager fCodepad;
    private Disposable fSaveActionDisposable;

    public CodepadToolSetFactory(Editor editor, ActionManager actionManager) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        Validate.notNull((Object)actionManager, (String)"'actionManager' cannot be null");
        this.fEditor = editor;
        this.fActionManager = actionManager;
        this.fCodepad = CodepadActionManager.getCodepadActionManager(this.fEditor);
        this.fToolSet = new TSToolSet(CONTENTS);
        this.populateFileSection();
        this.populateSectionSection();
        this.populateInlineMarkupSection();
        this.populateBlockMarkupSection();
        this.populatePublishSection();
    }

    private void populateFileSection() {
        this.fSaveActionDisposable = EditorToolSetFactory.populateSaveAction(this.fEditor, this.fToolSet, this.fActionManager);
    }

    private void populateSectionSection() {
        this.fToolSet.configureAndAdd("insert_section", (Action)new ChildAction(this.fCodepad.getAddDividerAction()));
        this.fToolSet.configureAndAdd("section_title", (Action)new ChildAction(this.fCodepad.getSectionTitleAction()));
    }

    private void populateInlineMarkupSection() {
        this.fToolSet.configureAndAdd("bold_text", (Action)new ChildAction(this.fCodepad.getBoldTextAction()));
        this.fToolSet.configureAndAdd("italic_text", (Action)new ChildAction(this.fCodepad.getItalicTextAction()));
        this.fToolSet.configureAndAdd("monospaced_text", (Action)new ChildAction(this.fCodepad.getMonospacedTextAction()));
        this.fToolSet.configureAndAdd("hyperlink_text", (Action)new ChildAction(this.fCodepad.getHyperlinkTextAction()));
        this.fToolSet.configureAndAdd("inline_math", (Action)new ChildAction(this.fCodepad.getLatexInlineMathAction()));
    }

    private void populateBlockMarkupSection() {
        this.fToolSet.configureAndAdd("preformatted_text", (Action)new ChildAction(this.fCodepad.getPreformattedTextAction()));
        this.fToolSet.configureAndAdd("sample_code", (Action)new ChildAction(this.fCodepad.getSampleCodeAction()));
        this.fToolSet.configureAndAdd("image", (Action)new ChildAction(this.fCodepad.getImageAction()));
        this.fToolSet.configureAndAdd("bulleted_list", (Action)new ChildAction(this.fCodepad.getBulletedListAction()));
        this.fToolSet.configureAndAdd("numbered_list", (Action)new ChildAction(this.fCodepad.getNumberedListAction()));
        this.fToolSet.configureAndAdd("block_math", (Action)new ChildAction(this.fCodepad.getLatexDisplayMath()));
    }

    private void populatePublishSection() {
        new PublishMenu(this.fEditor, this.fToolSet).populate();
    }

    public TSTabConfiguration getTabConfig() {
        return TAB_CONFIG;
    }

    public TSToolSet[] getToolSets() {
        return new TSToolSet[]{this.fToolSet};
    }

    public void dispose() {
        this.fSaveActionDisposable.dispose();
    }

    private static TSTabConfiguration readTabConfiguration() {
        try {
            return new TSTabConfiguration(SimpleDOMUtils.read((URL)CodepadToolSetFactory.class.getResource("resources/CodepadTab.xml")));
        }
        catch (DataFormatException dataFormatException) {
            Log.logException((Exception)dataFormatException);
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        return null;
    }

    private static TSToolSetContents readToolSetContents() {
        try {
            return new TSToolSetContents(SimpleDOMUtils.read((URL)CodepadToolSetFactory.class.getResource("resources/CodepadToolset.xml")), MatlabKeyBindings.getManager());
        }
        catch (DataFormatException dataFormatException) {
            Log.logException((Exception)dataFormatException);
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        return null;
    }

    public static class Registrar
    implements ToolstripInfoRegistrar {
        public void registerToolstripInfo(TSRegistry tSRegistry) {
            tSRegistry.addTabConfiguration(TAB_CONFIG);
            tSRegistry.addToolSetContents(CONTENTS);
            EditorUtils.registerEditorTabContributorToolsets(tSRegistry, TAB_CONFIG, EditorToolstripTabContributor.Tab.PUBLISH);
        }
    }
}

