/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.codepad;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.plugins.matlab.EditorSaveRunAndPublishUtils;
import com.mathworks.mde.editor.plugins.matlab.MatlabMenuContributor;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.ToolTipProvider;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.util.Disposable;
import com.mathworks.widgets.datamodel.StorageLocationUtils;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.glazedlists.DisposableList;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class PublishMenu {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(ConfigurationUtils.class.getPackage().getName() + ".resources.RES_Config_Editor");
    private static final ResourceBundle CODEPAD_BUNDLE = ResourceBundle.getBundle(PublishMenu.class.getPackage().getName() + ".resources.RES_Codepad_Toolstrip");
    public static final String PUBLISH_MENU_POPUP = "PublishMenuPopup";
    private final TSToolSet fToolSet;
    private final Editor fEditor;

    public PublishMenu(@NotNull Editor editor, @NotNull TSToolSet tSToolSet) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        Validate.notNull((Object)tSToolSet, (String)"'toolSet' cannot be null");
        this.fEditor = editor;
        this.fToolSet = tSToolSet;
    }

    public void populate() {
        EditorAction.ObservableAction observableAction = MatlabMenuContributor.PUBLISH.getAction();
        observableAction.setObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                MatlabPluginUtils.executeDefaultConfiguration(PublishMenu.this.fEditor, PublishConfiguration.TYPE, null);
            }
        });
        observableAction.setEnabled(!DebuggerManager.isDebugging());
        observableAction.putValue("PopupListener", this.createPopupListener());
        observableAction.putValue("toolTipProvider", this.createToolTipProvider());
        this.fToolSet.configureAndAdd("publish", (Action)((Object)observableAction));
        this.fToolSet.addDecorator("publish", new TSToolSet.ToolDecorator(){

            public void decorateTool(final JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                ToolTipManager.sharedInstance().registerComponent(jComponent);
                jComponent.putClientProperty("disposable", new Disposable(){

                    public void dispose() {
                        ToolTipManager.sharedInstance().unregisterComponent(jComponent);
                    }
                });
            }
        });
    }

    private PopupListener createPopupListener() {
        return new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                popupCallback.show((JComponent)PublishMenu.this.createPopup());
            }
        };
    }

    private ToolTipProvider createToolTipProvider() {
        return new ToolTipProvider(){

            public String getToolTipText() {
                if (StorageLocationUtils.isBackedByFile((StorageLocation)PublishMenu.this.fEditor.getStorageLocation())) {
                    File file = MatlabPluginUtils.getBackingFile(PublishMenu.this.fEditor);
                    AbstractFileConfiguration abstractFileConfiguration = ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(file, PublishConfiguration.TYPE);
                    return PublishMenu.createLabel(abstractFileConfiguration);
                }
                return CODEPAD_BUNDLE.getString("Tool.publish.Description");
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                return this.getToolTipText();
            }
        };
    }

    private PopupList createPopup() {
        PopupList popupList = new PopupList(this.createModel());
        popupList.addListActionListener((ListActionListener)new TSFactory.ListListenerBridge());
        popupList.setName(PUBLISH_MENU_POPUP);
        return popupList;
    }

    private ListModel createModel() {
        AbstractFileConfiguration abstractFileConfiguration;
        Object object;
        DefaultListModel<AbstractFileConfiguration> defaultListModel = new DefaultListModel<AbstractFileConfiguration>();
        if (StorageLocationUtils.isBackedByFile((StorageLocation)this.fEditor.getStorageLocation())) {
            object = MatlabPluginUtils.getBackingFile(this.fEditor);
            abstractFileConfiguration = ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault((File)object, PublishConfiguration.TYPE);
            this.addConfigToModel(defaultListModel, abstractFileConfiguration);
            DisposableList disposableList = ConfigurationManager.getInstance().getConfigurationsForFile((File)object, PublishConfiguration.TYPE);
            for (PublishConfiguration publishConfiguration : disposableList) {
                if (publishConfiguration.equals((Object)abstractFileConfiguration)) continue;
                this.addConfigToModel(defaultListModel, (AbstractFileConfiguration)publishConfiguration);
            }
        }
        if (!defaultListModel.isEmpty()) {
            ((ListItem)defaultListModel.get(defaultListModel.size() - 1)).setAttribute((Attribute)ListItem.HAS_SEPARATOR, (Object)true);
        }
        object = BUNDLE.getString("edit.configurations.menuItem.publishOptions");
        abstractFileConfiguration = TSFactory.createListItemFromAction((Action)new MJAbstractAction((String)object){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorSaveRunAndPublishUtils.showConfigurationEditor(PublishMenu.this.fEditor, PublishConfiguration.TYPE);
            }
        }, (ListStyle)ListStyle.TEXT_ONLY);
        defaultListModel.addElement(abstractFileConfiguration);
        return defaultListModel;
    }

    private void addConfigToModel(DefaultListModel defaultListModel, final AbstractFileConfiguration abstractFileConfiguration) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(PublishMenu.createLabel(abstractFileConfiguration)){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorSaveRunAndPublishUtils.saveFileAndDoConfigurationAction(PublishMenu.this.fEditor, abstractFileConfiguration, PublishConfiguration.TYPE, null);
            }
        };
        mJAbstractAction.setEnabled(!DebuggerManager.isDebugging());
        defaultListModel.addElement(TSFactory.createListItemFromAction((Action)mJAbstractAction, (ListStyle)ListStyle.TEXT_ONLY));
    }

    private static String createLabel(AbstractFileConfiguration abstractFileConfiguration) {
        String string = BUNDLE.getString("edit.configurations.menuItem.publish");
        return MessageFormat.format(string, abstractFileConfiguration.getName());
    }
}

