/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.editordataservice;

import com.mathworks.services.editordataservice.Document;
import com.mathworks.services.editordataservice.EditorFeature;
import com.mathworks.services.editordataservice.EditorNode;
import com.mathworks.widgets.text.mcode.DefaultMKit;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;

public class EditorVariableHighlightingFeature
extends EditorFeature {
    public EditorVariableHighlightingFeature(EditorNode editorNode) {
        super(editorNode);
    }

    public void documentChanged(Document document) {
        final String string = document.getText();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> map = null;
                try {
                    map = EditorVariableHighlightingFeature.buildVariablesMap(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                EditorVariableHighlightingFeature.this.updateFeatureData(map);
            }
        });
    }

    public static Map<String, Object> buildVariablesMap(String string) throws BadLocationException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        BaseDocument baseDocument = new BaseDocument(new DefaultMKit().getClass(), false);
        baseDocument.insertString(0, string, null);
        MTree mTree = MDocumentUtils.getMTree((BaseDocument)baseDocument);
        Map<Integer, VariableOrFunction> map = EditorVariableHighlightingFeature.getVariablesAndFunctionsBySymbolIndex(mTree);
        for (Integer n : map.keySet()) {
            VariableOrFunction variableOrFunction = map.get(n);
            String string2 = variableOrFunction.getName();
            ArrayList<Position> arrayList = variableOrFunction.getPositions();
            if (!hashMap.containsKey(string2)) {
                hashMap.put(string2, new ArrayList());
            }
            ((ArrayList)hashMap.get(string2)).add(arrayList);
        }
        return hashMap;
    }

    private static List<String> getDocumentFunctionNames(MTree mTree) {
        List list = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FUNCTION});
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MTree.Node node : list) {
            arrayList.add(node.getFunctionName().getText());
        }
        return arrayList;
    }

    private static boolean isIdNodeVariableOrFunction(MTree.Node node, List<String> list) {
        String string;
        if (node.getAttribute() == MTree.Attribute.VARIABLE) {
            return true;
        }
        return node.getAttribute() == MTree.Attribute.FUNCTION && list.contains(string = node.getText());
    }

    private static Map<Integer, VariableOrFunction> getVariablesAndFunctionsBySymbolIndex(MTree mTree) {
        HashMap<Integer, VariableOrFunction> hashMap = new HashMap<Integer, VariableOrFunction>();
        List<String> list = EditorVariableHighlightingFeature.getDocumentFunctionNames(mTree);
        List list2 = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.ID});
        for (MTree.Node node : list2) {
            Object object;
            if (!EditorVariableHighlightingFeature.isIdNodeVariableOrFunction(node, list)) continue;
            Integer n = new Integer(node.getSymbolTableIndex());
            if (!hashMap.containsKey(n)) {
                object = new VariableOrFunction(node.getText());
                hashMap.put(n, (VariableOrFunction)object);
            }
            object = new Position(node);
            ((VariableOrFunction)hashMap.get(n)).addPosition((Position)object);
        }
        return hashMap;
    }

    public String getFeatureId() {
        return "matlab.code.variables";
    }

    private static class VariableOrFunction {
        private final String fName;
        private final ArrayList<Position> fPositions;

        public VariableOrFunction(String string) {
            this.fName = string;
            this.fPositions = new ArrayList();
        }

        public String getName() {
            return this.fName;
        }

        public ArrayList<Position> getPositions() {
            return this.fPositions;
        }

        public void addPosition(Position position) {
            this.fPositions.add(position);
        }
    }

    private static class Position {
        private final int startLine;
        private final int startColumn;
        private final int endLine;
        private final int endColumn;

        public Position(MTree.Node node) {
            this.startLine = node.getStartLine() - 1;
            this.startColumn = node.getStartColumn() - 1;
            this.endLine = this.startLine;
            this.endColumn = this.startColumn + node.getText().length();
        }
    }
}

