/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.embeddedoutputs.parser;

import com.mathworks.mde.embeddedoutputs.OutputDataType;
import com.mathworks.mde.embeddedoutputs.outputhandlers.TextOutputData;
import com.mathworks.mde.embeddedoutputs.outputhandlers.VariableOutputData;
import com.mathworks.mde.embeddedoutputs.parser.MATLABOutputPEG;
import com.mathworks.mde.embeddedoutputs.parser.ParseTree;
import com.mathworks.mde.embeddedoutputs.variables.VariableManager;
import com.mathworks.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class Parser {
    private Map<Integer, ArrayList<String>> fRegionToMatrixCache = new HashMap<Integer, ArrayList<String>>();
    private static final MATLABOutputPEG fOutputPEG = new MATLABOutputPEG();

    public List<OutputDataType> parseOutputString(String string, int n, VariableManager variableManager) {
        ArrayList<OutputDataType> arrayList = new ArrayList<OutputDataType>();
        ArrayList<ParseTree> arrayList2 = fOutputPEG.parse(string);
        ArrayList<ParseTree> arrayList3 = arrayList2.get((int)0).fChildren;
        if (arrayList3.size() == 0 && string.length() > 0) {
            arrayList.add(new OutputDataType("text", new TextOutputData(string)));
            return arrayList;
        }
        Iterator<ParseTree> iterator = arrayList3.iterator();
        OutputDataType outputDataType = null;
        while (iterator.hasNext()) {
            ParseTree parseTree = iterator.next();
            if (parseTree.fName == 2) {
                try {
                    outputDataType = this.parseVariableInfo(string, n, parseTree, variableManager);
                }
                catch (RuntimeException runtimeException) {
                    outputDataType = this.parseTextInfo(arrayList, string, parseTree);
                }
            } else if (parseTree.fName == 1) {
                outputDataType = this.parseTextInfo(arrayList, string, parseTree);
            }
            if (outputDataType == null) continue;
            arrayList.add(outputDataType);
        }
        return arrayList;
    }

    public ArrayList<String> getRegionToMatrixCache(int n) {
        return this.fRegionToMatrixCache.get(n);
    }

    public void clearVariables(int n) {
        this.fRegionToMatrixCache.remove(n);
    }

    private OutputDataType parseTextInfo(List list, String string, ParseTree parseTree) {
        OutputDataType outputDataType = null;
        String string2 = string.substring(parseTree.fStart, parseTree.fEnd).trim();
        if (list.size() > 0) {
            OutputDataType outputDataType2 = (OutputDataType)list.get(list.size() - 1);
            if (outputDataType2.getOutputData() instanceof TextOutputData) {
                TextOutputData textOutputData = (TextOutputData)outputDataType2.getOutputData();
                textOutputData.text = textOutputData.text + '\n' + string2;
            }
        } else {
            outputDataType = new OutputDataType("text", new TextOutputData(string2));
        }
        return outputDataType;
    }

    private OutputDataType parseVariableInfo(String string, int n, ParseTree parseTree, VariableManager variableManager) {
        OutputDataType outputDataType;
        String string2 = string.substring(parseTree.fChildren.get((int)0).fStart, parseTree.fChildren.get((int)0).fEnd);
        ParseTree parseTree2 = parseTree.fChildren.get(1);
        int n2 = 0;
        String string3 = null;
        if (parseTree2.fChildren.get((int)0).fName == 5) {
            n2 = 1;
            string3 = string.substring(parseTree2.fChildren.get((int)0).fStart, parseTree2.fChildren.get((int)0).fEnd);
            string3 = string3.trim();
        }
        ArrayList arrayList = this.convertMatrix(parseTree2, n2, string);
        int n3 = arrayList.size();
        int n4 = ((ArrayList)arrayList.get(0)).size();
        int[] nArray = new int[]{n3, n4};
        if (n3 > 1 || n4 > 1) {
            VariableOutputData variableOutputData = this.getVariableSummary(string2, arrayList, nArray, variableManager, string3);
            outputDataType = new OutputDataType("matrix", variableOutputData);
            this.addMatrixIdToCache(n, variableOutputData);
        } else {
            VariableOutputData variableOutputData = new VariableOutputData(string2, (String)((ArrayList)arrayList.get(0)).get(0));
            outputDataType = new OutputDataType("variable", variableOutputData);
        }
        return outputDataType;
    }

    private VariableOutputData getVariableSummary(String string, ArrayList<ArrayList> arrayList, int[] nArray, VariableManager variableManager, String string2) {
        double[][] dArray = this.convertToDoubles(arrayList, nArray);
        VariableOutputData variableOutputData = variableManager.openVariable(string, dArray, string2);
        return variableOutputData;
    }

    private double[][] convertToDoubles(ArrayList<ArrayList> arrayList, int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        double[][] dArray = new double[n][n2];
        try {
            for (int i = 0; i < n; ++i) {
                ArrayList arrayList2 = arrayList.get(i);
                int n3 = arrayList2.size();
                dArray[i] = ArrayUtils.toPrimitive((Double[])arrayList2.toArray(new Double[n3]));
            }
        }
        catch (RuntimeException runtimeException) {
            Log.logException((Exception)runtimeException);
        }
        return dArray;
    }

    private ArrayList convertMatrix(ParseTree parseTree, int n, String string) {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        int n2 = 0;
        while (n < parseTree.fChildren.size()) {
            ParseTree parseTree2 = parseTree.fChildren.get(n);
            ArrayList<ParseTree> arrayList2 = parseTree2.fChildren;
            n2 = this.extractMatrixElementsFromString(string, arrayList, n2, arrayList2);
            ++n;
        }
        return arrayList;
    }

    private int extractMatrixElementsFromString(String string, ArrayList<ArrayList> arrayList, int n, ArrayList<ParseTree> arrayList2) {
        ArrayList<ParseTree> arrayList3;
        int n2 = 0;
        if (arrayList2.get((int)0).fName == 8) {
            n2 = 1;
            ++n;
        }
        boolean bl = true;
        if (arrayList2.size() == 1) {
            arrayList3 = arrayList2.get((int)n2).fChildren;
            while (arrayList3.size() != 0) {
                if (arrayList3.size() > 1) {
                    bl = false;
                    break;
                }
                arrayList3 = arrayList3.get((int)0).fChildren;
            }
        } else {
            bl = false;
        }
        while (n2 < arrayList2.size()) {
            Object object;
            int n3;
            arrayList3 = n > 1 ? arrayList.get(n2 - 1) : new ArrayList();
            ParseTree parseTree = arrayList2.get(n2);
            ArrayList<ParseTree> arrayList4 = parseTree.fChildren;
            if (bl) {
                object = string.substring(arrayList4.get((int)n3).fStart, arrayList4.get((int)n3).fEnd).trim();
                arrayList3.add((ParseTree)object);
            } else {
                for (n3 = 0; n3 < arrayList4.size(); ++n3) {
                    object = Double.parseDouble(string.substring(arrayList4.get((int)n3).fStart, arrayList4.get((int)n3).fEnd).trim());
                    arrayList3.add((ParseTree)object);
                }
            }
            if (n < 2) {
                arrayList.add(arrayList3);
            }
            ++n2;
        }
        return n;
    }

    private void addMatrixIdToCache(int n, VariableOutputData variableOutputData) {
        ArrayList<String> arrayList = this.fRegionToMatrixCache.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.fRegionToMatrixCache.put(n, arrayList);
        }
        arrayList.add(variableOutputData.id);
    }
}

