/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.examples;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.mde.examples.ExampleGalleryAction;
import com.mathworks.mde.examples.ExampleGalleryDownloadAndOpenAction;
import com.mathworks.mde.examples.ExampleGalleryMessage;
import com.mathworks.mde.examples.ExampleGalleryMessageType;
import com.mathworks.mde.examples.ExampleGalleryOpenAction;
import com.mathworks.mde.examples.ExampleGalleryPage;
import com.mathworks.mde.examples.addons.AddonUtils;
import com.mathworks.mde.examples.login.UserLoginCredentials;
import com.mathworks.mde.examples.login.UserLoginCredentialsManager;
import com.mathworks.mde.webbrowser.WebBrowser;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.examples.ExamplePrefs;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.widgets.login.LogOut;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Map;

public enum ExampleGalleryEventType {
    SHOW_ALL{

        @Override
        ExampleGalleryAction getAction(ExampleGalleryPage exampleGalleryPage, Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                    ExamplePrefs.setExampleGalleryShowInstalledPref((Boolean)false);
                }
            };
        }
    }
    ,
    SHOW_INSTALLED{

        @Override
        ExampleGalleryAction getAction(ExampleGalleryPage exampleGalleryPage, Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                    ExamplePrefs.setExampleGalleryShowInstalledPref((Boolean)true);
                }
            };
        }
    }
    ,
    OPEN_EXAMPLE{

        @Override
        ExampleGalleryAction getAction(ExampleGalleryPage exampleGalleryPage, Map<String, String> map) {
            return new ExampleGalleryOpenAction(map);
        }
    }
    ,
    DOWNLOAD_AND_OPEN{

        @Override
        ExampleGalleryAction getAction(ExampleGalleryPage exampleGalleryPage, Map<String, String> map) {
            return new ExampleGalleryDownloadAndOpenAction(map);
        }
    }
    ,
    VIEW_IN_DOCUMENTATION{

        @Override
        ExampleGalleryAction getAction(ExampleGalleryPage exampleGalleryPage, final Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                    DocRoot docRoot = DocCenterDocConfig.getInstance().getDocRoot();
                    String string = docRoot.buildGlobalPageUrl((String)map.get("url")).toString();
                    MLHelpServices.setCurrentLocation((String)string);
                }
            };
        }
    }
    ,
    VIEW_IN_FX{

        @Override
        ExampleGalleryAction getAction(ExampleGalleryPage exampleGalleryPage, final Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                    WebBrowser webBrowser = WebBrowser.createBrowser();
                    webBrowser.setCurrentLocation((String)map.get("url"));
                }
            };
        }
    }
    ,
    COPY_CODE{

        @Override
        ExampleGalleryAction getAction(ExampleGalleryPage exampleGalleryPage, final Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection((String)map.get("code")), null);
                }
            };
        }
    }
    ,
    VIEW_ADDON{

        @Override
        ExampleGalleryAction getAction(ExampleGalleryPage exampleGalleryPage, Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                }
            };
        }
    }
    ,
    GET_INSTALLED_ADDONS{

        @Override
        ExampleGalleryAction getAction(final ExampleGalleryPage exampleGalleryPage, Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                    exampleGalleryPage.publish(new ExampleGalleryMessage(ExampleGalleryMessageType.INSTALLED_ADDONS, AddonUtils.getInstalledAddons().toArray()));
                }
            };
        }
    }
    ,
    LOGIN{

        @Override
        ExampleGalleryAction getAction(final ExampleGalleryPage exampleGalleryPage, Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                    UserLoginCredentials userLoginCredentials = UserLoginCredentialsManager.getsUserLoginCredentials();
                    if (userLoginCredentials != null) {
                        exampleGalleryPage.publish(new ExampleGalleryMessage(ExampleGalleryMessageType.LOGGED_IN, userLoginCredentials));
                    }
                }
            };
        }
    }
    ,
    LOGOUT{

        @Override
        ExampleGalleryAction getAction(final ExampleGalleryPage exampleGalleryPage, Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                    LogOut logOut = new LogOut();
                    logOut.logOutMWA();
                    exampleGalleryPage.publish(new ExampleGalleryMessage(ExampleGalleryMessageType.LOGGED_OUT, null));
                }
            };
        }
    }
    ,
    SHOW_DEMOS{

        @Override
        ExampleGalleryAction getAction(ExampleGalleryPage exampleGalleryPage, Map<String, String> map) {
            return new ExampleGalleryAction(){

                @Override
                public void execute() {
                    MLHelpServices.showDemos();
                }
            };
        }
    };


    abstract ExampleGalleryAction getAction(ExampleGalleryPage var1, Map<String, String> var2);
}

