/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.explorer.ActionComponentProvider;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.mde.autosave.AutoSaveUtils;
import com.mathworks.mde.difftool.FileDiffToolInfo;
import com.mathworks.mde.difftool.FileDiffToolMenu;
import com.mathworks.mde.difftool.SelectedFilesDiffToolAction;
import com.mathworks.mde.difftool.SelectedFilesDiffToolInfo;
import com.mathworks.mde.difftool.UnsavedChangesDiffToolAction;
import com.mathworks.mde.difftool.UnsavedChangesDiffToolInfo;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.mlwidgets.explorer.model.editorfs.EditorFileSystem;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.Log;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;

public class DiffActionProvider
implements ActionProvider {
    private static final ActionDefinition sDiffSelectedActionPlaceholder = new ActionDefinition("diffSelectedFiles", CoreMenuSection.DIFF_SCM.getSection(), "diffSelectedFiles");
    private static final ActionDefinition sDiffMenuPlaceholder = new ActionDefinition("diffMenu", CoreMenuSection.DIFF_SCM.getSection(), "diffMenu");
    private static final ActionDefinition sDiffEditorActionPlaceholder = new ActionDefinition("diffAgainstEditor", CoreMenuSection.DIFF_SCM.getSection(), "diffAgainstEditor");
    private final DocumentDiffToolInfo fDiffToolInfo = new DocumentDiffToolInfo();
    private final SelectedFilesDiffToolAction fDiffSelectedAction = new SelectedFilesDiffToolAction(this.fDiffToolInfo);
    private final UnsavedChangesDiffToolAction fDiffEditorAction = new UnsavedChangesDiffToolAction(this.fDiffToolInfo);
    private final FileDiffToolMenu fFileDiffToolMenu = new FileDiffToolMenu(this.fDiffToolInfo);

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void installKeyBindings(JComponent jComponent, int n) {
        this.fFileDiffToolMenu.installKeyBindings(jComponent, n);
        MatlabKeyBindings.getManager().addKeyBindings(jComponent, 0, (ExtendedAction)this.fDiffSelectedAction.getAction());
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.defineAction(sDiffSelectedActionPlaceholder).setMenuComponentProvider(SelectionMode.MULTIPLE_SELECTION_OR_CURRENT_LOCATION, new ActionComponentProvider(){

            public JComponent getComponent(ActionInput actionInput) {
                DiffActionProvider.this.fDiffToolInfo.setInput(actionInput);
                DiffActionProvider.this.fDiffSelectedAction.updateActionStatus();
                return new MJMenuItem((Action)DiffActionProvider.this.fDiffSelectedAction.getAction());
            }
        });
        ActionConfiguration actionConfiguration = actionRegistry.defineAction(sDiffEditorActionPlaceholder);
        actionConfiguration.setVisibleOnContextMenu((Predicate)new Predicate<ActionInput>(){

            public boolean accept(ActionInput actionInput) {
                return actionInput.getSelection().size() == 1 && DiffActionProvider.isDirty(actionInput.getSelection());
            }
        });
        actionConfiguration.setMenuComponentProvider(SelectionMode.MULTIPLE_SELECTION_OR_CURRENT_LOCATION, new ActionComponentProvider(){

            public JComponent getComponent(ActionInput actionInput) {
                DiffActionProvider.this.fDiffToolInfo.setInput(actionInput);
                DiffActionProvider.this.fDiffEditorAction.updateActionStatus();
                DiffActionProvider.this.fDiffEditorAction.getAction().setName(ExplorerResources.getString((String)"context.diffEditor"));
                return new MJMenuItem((Action)DiffActionProvider.this.fDiffEditorAction.getAction());
            }
        });
        actionRegistry.defineAction(sDiffMenuPlaceholder).setMenuComponentProvider(SelectionMode.MULTIPLE_SELECTION_OR_CURRENT_LOCATION, new ActionComponentProvider(){

            public JComponent getComponent(ActionInput actionInput) {
                DiffActionProvider.this.fDiffToolInfo.setInput(actionInput);
                DiffActionProvider.this.fFileDiffToolMenu.updateActionStatus();
                MJMenu mJMenu = DiffActionProvider.this.fFileDiffToolMenu.getMenu();
                mJMenu.setText(ExplorerResources.getString((String)"context.compareAgainst"));
                return mJMenu;
            }
        });
    }

    private static boolean isDirty(List<FileSystemEntry> list) {
        return list.size() == 1 && list.get(0).isReal() && !list.get(0).isFolder() && EditorFileSystem.getInstance().isDirty(list.get(0).getLocation());
    }

    private static class DocumentDiffToolInfo
    implements FileDiffToolInfo,
    SelectedFilesDiffToolInfo,
    UnsavedChangesDiffToolInfo {
        private List<FileSystemEntry> fSelection = new ArrayList<FileSystemEntry>();
        private Component fComponent;

        DocumentDiffToolInfo() {
        }

        synchronized void setInput(ActionInput actionInput) {
            for (FileSystemEntry fileSystemEntry : this.fSelection) {
                try {
                    MLFileSystemUtils.releaseMatlabAccessibleStub((FileSystemEntry)fileSystemEntry);
                }
                catch (IOException iOException) {
                    Log.logException((Exception)iOException);
                }
            }
            this.fSelection = new ArrayList<FileSystemEntry>();
            for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                this.fSelection.add(VirtualFileSystem.getUnderlyingEntryIfMountPoint((FileSystemEntry)fileSystemEntry));
            }
            this.fComponent = actionInput.getComponent();
        }

        @Override
        public String getText() {
            if (!this.isDirty()) {
                return null;
            }
            FileStorageLocation fileStorageLocation = new FileStorageLocation(this.fSelection.get(0).getLocation().toFile());
            return MLEditorServices.getEditorApplication().getEditor((StorageLocation)fileStorageLocation).getTextWithSystemLineEndings();
        }

        @Override
        public synchronized File getFile() {
            if (this.fSelection.isEmpty()) {
                return null;
            }
            try {
                FileSystemEntry fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleStub((FileSystemEntry)this.fSelection.get(0));
                return fileSystemEntry.getLocation().toFile();
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
                return this.fSelection.get(0).getLocation().toFile();
            }
        }

        @Override
        public synchronized File[] getFiles() {
            if (!this.fSelection.isEmpty()) {
                ArrayList<File> arrayList = new ArrayList<File>();
                for (FileSystemEntry fileSystemEntry : this.fSelection) {
                    try {
                        arrayList.add(MLFileSystemUtils.getMatlabAccessibleStub((FileSystemEntry)fileSystemEntry).getLocation().toFile());
                    }
                    catch (IOException iOException) {
                        Log.logException((Exception)iOException);
                    }
                }
                if (arrayList.isEmpty()) {
                    return null;
                }
                return arrayList.toArray(new File[arrayList.size()]);
            }
            return null;
        }

        @Override
        public synchronized File getAutoSaveFile() {
            File file;
            File file2 = this.getFile();
            if (file2 != null && (file = AutoSaveUtils.translateToAutoSaveFile(file2.getName(), file2.getParent())) != null && file.exists()) {
                return file;
            }
            return null;
        }

        @Override
        public synchronized Component getComponentForDialog() {
            return this.fComponent;
        }

        @Override
        public boolean isSingleFileActive() {
            return this.fSelection.size() == 1;
        }

        @Override
        public void executeDiffRunnable(Runnable runnable) {
            for (FileSystemEntry fileSystemEntry : this.fSelection) {
                try {
                    MLFileSystemUtils.fillMatlabAccessibleStub((FileSystemEntry)fileSystemEntry);
                }
                catch (IOException iOException) {
                    Log.logException((Exception)iOException);
                }
            }
            new Thread(runnable, "DiffActionProvider").start();
        }

        @Override
        public boolean isDirty() {
            return DiffActionProvider.isDirty(this.fSelection);
        }

        @Override
        public boolean isBuffer() {
            return false;
        }
    }
}

