/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.TreeTableModel;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.html.Url;
import com.mathworks.mde.functionbrowser.DocCategoryXMLParser;
import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mde.functionbrowser.ProductScopePanel;
import com.mathworks.mlwidgets.actionbrowser.FunctionReferenceUtils;
import com.mathworks.mlwidgets.help.FunctionCategoryXMLParser;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.SearchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;

class FunctionTableModel
extends TreeTableModel<Row>
implements SpanModel {
    private boolean fSearchResultsAdded = false;
    private static final Map<String, CategoryRow> sCategoryRowTable = new HashMap<String, CategoryRow>();
    private static CategoryRow sMatlabRow;
    private static CategoryIndex sCategoryIndex;
    private static final String RES_STR = "com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser";
    private static final String KEY = "FunctionTableModel.";
    private static ResourceBundle resources;
    private static DocCategoryXMLParser sCategoryParser;
    private Row fPendingSearchRow;

    public FunctionTableModel(String string) {
        this.buildAllCategories(string);
        this.resetNodeExpansionState();
    }

    <T extends FunctionSearchResult> void addResults(Iterable<T> iterable) {
        if (!this.fSearchResultsAdded && iterable.iterator().hasNext()) {
            this.fSearchResultsAdded = true;
            this.addRow((Row)new HeaderRow("<html><FONT color=#616D7E><b>" + resources.getString("FunctionTableModel.Functions") + "</b></FONT></html>", ""));
        }
        LinkedList<ResultFunctionRow<FunctionSearchResult>> linkedList = new LinkedList<ResultFunctionRow<FunctionSearchResult>>();
        for (FunctionSearchResult functionSearchResult : iterable) {
            linkedList.add(new ResultFunctionRow<FunctionSearchResult>(functionSearchResult));
        }
        this.addRows(linkedList);
    }

    private void resetNodeExpansionState() {
        this.collapseAll();
        if (sMatlabRow != null) {
            this.expandRow((ExpandableRow)sMatlabRow, true);
        }
    }

    void reset(String string) {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
        this.fSearchResultsAdded = false;
        this.buildAllCategories(string);
    }

    public boolean isCellSpanOn() {
        return true;
    }

    public CellSpan getCellSpanAt(int n, int n2) {
        if (this.getRowAt(n) instanceof FunctionRow || n2 == 1) {
            return null;
        }
        return new CellSpan(n, n2, 1, 2);
    }

    boolean isSearchComplete() {
        return this.fPendingSearchRow == null;
    }

    static void resetCategories() {
        sCategoryIndex = null;
        sMatlabRow = null;
    }

    private void buildAllCategories(String string) {
        block13: {
            Object object;
            List list;
            HeaderRow headerRow;
            block12: {
                CategoryRow categoryRow;
                Object object2;
                Object object32;
                if (!FunctionBrowser.isDocAvailable() && HelpUtils.isEnglish()) {
                    HeaderRow headerRow2 = new HeaderRow("<html><FONT color=#616D7E><b>" + resources.getString("FunctionTableModel.Categories") + ": <font color='red'>No Documentation Found</font></b></FONT></html>", "");
                    this.addRow(0, (Row)headerRow2);
                    return;
                }
                headerRow = new HeaderRow("<html><FONT color=#616D7E><b>" + resources.getString("FunctionTableModel.Categories") + "</b></FONT></html>", "");
                if (sCategoryIndex == null) {
                    sCategoryIndex = new CategoryIndex();
                    if (sCategoryRowTable != null) {
                        sCategoryRowTable.clear();
                    }
                    if ((list = FunctionReferenceUtils.getInstalledFunctionData((boolean)false)) != null && !list.isEmpty()) {
                        for (Object object32 : list) {
                            if (sMatlabRow == null && object32.getShortName().equals("matlab")) {
                                sMatlabRow = new CategoryRow(object32.getProductName(), "matlab");
                                object = sCategoryParser.parse("matlab");
                                this.createRows((DefaultMutableTreeNode)object, (Row)sMatlabRow, "matlab");
                                sCategoryIndex.addIndexRow(sMatlabRow);
                                sMatlabRow.setExpanded(true);
                                continue;
                            }
                            if (sCategoryRowTable == null || sCategoryRowTable.containsKey(object32.getShortName())) continue;
                            object2 = new CategoryRow(object32.getProductName(), object32.getShortName());
                            object = sCategoryParser.parse(object32.getShortName());
                            if (object == null || ((DefaultMutableTreeNode)object).getChildCount() <= 0) continue;
                            this.createRows((DefaultMutableTreeNode)object, (Row)object2, object32.getShortName());
                            if (object2.getChildrenCount() <= 0) continue;
                            object2.setExpanded(false);
                            sCategoryRowTable.put(object32.getShortName(), (CategoryRow)((Object)object2));
                            sCategoryIndex.addIndexRow((CategoryRow)((Object)object2));
                        }
                    }
                }
                if (string != null) {
                    string = string.toLowerCase();
                }
                list = FunctionReferenceUtils.getInstalledFunctionData((boolean)true);
                if (string == null || string.length() < 2) break block12;
                CategoryRow[] categoryRowArray = sCategoryIndex.findMatchingRows(string, list);
                if (categoryRowArray == null || categoryRowArray.length <= 0) break block13;
                this.addRow(0, (Row)headerRow, true);
                object32 = new ArrayList();
                ((ArrayList)object32).addAll(Arrays.asList(categoryRowArray));
                object = new ArrayList();
                ((ArrayList)object).addAll(Arrays.asList(categoryRowArray));
                object2 = ((ArrayList)object).iterator();
                while (object2.hasNext()) {
                    categoryRow = (CategoryRow)((Object)object2.next());
                    if (!FunctionTableModel.isChildOf(categoryRow, (List<CategoryRow>)object32)) continue;
                    ((ArrayList)object32).remove((Object)categoryRow);
                }
                object2 = ((ArrayList)object32).iterator();
                while (object2.hasNext()) {
                    CategoryRow categoryRow2;
                    categoryRow = (CategoryRow)((Object)object2.next());
                    categoryRow2.setShowProductSuffix(!"matlab".equals((categoryRow2 = categoryRow.deepCopy()).getProductName()));
                    this.addRow((Row)categoryRow2);
                }
                break block13;
            }
            this.addRow(0, (Row)headerRow, true);
            if (FunctionTableModel.isSelectedProduct("matlab", list)) {
                this.addRow((Row)sMatlabRow);
            }
            for (Object object32 : list) {
                object = sCategoryRowTable != null ? sCategoryRowTable.get(object32.getShortName()) : null;
                if (object == null) continue;
                int n = this.getRowIndex((Row)object);
                if (n >= 0) {
                    CategoryRow categoryRow = object.deepCopy();
                    categoryRow.fCategory = object32.getProductName();
                    this.addRow((Row)categoryRow);
                    continue;
                }
                this.addRow((Row)object);
            }
        }
    }

    private void createRows(DefaultMutableTreeNode defaultMutableTreeNode, Row row, String string) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            String string2;
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.getAllowsChildren() && defaultMutableTreeNode2.getChildCount() > 0) {
                object = new CategoryRow((String)defaultMutableTreeNode2.getUserObject(), string);
                this.addRow(row, (Row)object);
                sCategoryIndex.addIndexRow((CategoryRow)((Object)object));
                this.createRows(defaultMutableTreeNode2, (Row)object, string);
                continue;
            }
            if (defaultMutableTreeNode2.getAllowsChildren() || (string2 = (object = (FunctionCategoryXMLParser.FunctionItem)defaultMutableTreeNode2).toString()) == null) continue;
            this.addRow(row, (Row)new BrowseFunctionRow(new BrowseSearchResult(string2, string, object.getRefPagePath(), object.getH1Line())));
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        return "";
    }

    void maybeSetEmptyMessage() {
        if (this.getRowCount() > 0) {
            return;
        }
        boolean bl = HelpPrefs.isDocCenterProductFilterEnabled();
        ProductScopePanel.ProductFilterStatus productFilterStatus = ProductScopePanel.isLocalDocProductAllSelected();
        if (!bl || productFilterStatus == ProductScopePanel.ProductFilterStatus.ALL_SELECTED) {
            this.addRow((Row)new HeaderRow(resources.getString("FunctionTableModel.NoResults"), ""));
            this.fSearchResultsAdded = true;
            return;
        }
        this.addRow((Row)new HeaderRow(resources.getString("FunctionTableModel.NoResultsCheckFilter"), ""));
        this.fSearchResultsAdded = true;
    }

    void maybeSetEmptyNoWildcardMessage() {
        if (this.getRowCount() > 0) {
            return;
        }
        this.setEmptyNoWildcardMessage();
    }

    void setEmptyNoWildcardMessage() {
        if (this.fSearchResultsAdded) {
            return;
        }
        this.addRow((Row)new HeaderRow("<html><FONT color=#616D7E><b>" + resources.getString("FunctionTableModel.NoWildcard") + "</b></FONT></html>", ""));
        this.fSearchResultsAdded = true;
    }

    void setPendingMessage() {
        if (this.fPendingSearchRow == null) {
            this.fPendingSearchRow = new HeaderRow("<html><FONT color=#616D7E><b>" + resources.getString("FunctionTableModel.Searching") + "</b></FONT></html>", "");
        } else {
            this.removeRow(this.fPendingSearchRow);
        }
        this.addRow(this.fPendingSearchRow);
    }

    void clearPendingMessage() {
        if (this.fPendingSearchRow != null) {
            this.removeRow(this.fPendingSearchRow);
        }
        this.fPendingSearchRow = null;
    }

    private static boolean isSelectedProduct(String string, List<FunctionReferenceUtils.FunctionProductData> list) {
        for (FunctionReferenceUtils.FunctionProductData functionProductData : list) {
            if (!functionProductData.getShortName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChildOf(CategoryRow categoryRow, List<CategoryRow> list) {
        for (CategoryRow categoryRow2 : list) {
            if (!FunctionTableModel.isChildOf(categoryRow, categoryRow2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChildOf(CategoryRow categoryRow, CategoryRow categoryRow2) {
        CategoryRow categoryRow3 = categoryRow;
        while (categoryRow3.getParent() != null && categoryRow3.getParent() instanceof CategoryRow) {
            if ((categoryRow3 = (CategoryRow)categoryRow3.getParent()) != categoryRow2) continue;
            return true;
        }
        return false;
    }

    static {
        resources = ResourceBundle.getBundle(RES_STR);
        sCategoryParser = new DocCategoryXMLParser();
    }

    static class CategoryIndex
    extends TreeMap<String, CategoryRow[]> {
        void addIndexRow(CategoryRow categoryRow) {
            String[] stringArray;
            String string = categoryRow.getCategoryName().toLowerCase();
            for (String string2 : stringArray = string.split(" ")) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                CategoryRow[] categoryRowArray = (CategoryRow[])this.get(string2.trim());
                if (categoryRowArray == null) {
                    this.put(string2.trim(), new CategoryRow[]{categoryRow});
                    continue;
                }
                CategoryRow[] categoryRowArray2 = new CategoryRow[categoryRowArray.length + 1];
                System.arraycopy(categoryRowArray, 0, categoryRowArray2, 0, categoryRowArray.length);
                categoryRowArray2[categoryRowArray2.length - 1] = categoryRow;
                this.put(string2.trim(), categoryRowArray2);
            }
        }

        private static ArrayList<CategoryRow> intersect(ArrayList<CategoryRow> arrayList, ArrayList<CategoryRow> arrayList2) {
            ArrayList<CategoryRow> arrayList3 = new ArrayList<CategoryRow>();
            if (arrayList2 == null || arrayList == null) {
                return arrayList3;
            }
            for (CategoryRow categoryRow : arrayList2) {
                if (!arrayList.contains((Object)categoryRow)) continue;
                arrayList3.add(categoryRow);
            }
            return arrayList3;
        }

        private static ArrayList<CategoryRow> selectMatchingRows(Collection<CategoryRow[]> collection, List<FunctionReferenceUtils.FunctionProductData> list) {
            if (collection == null) {
                return null;
            }
            ArrayList<CategoryRow> arrayList = new ArrayList<CategoryRow>();
            HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
            for (CategoryRow[] categoryRowArray : collection) {
                if (categoryRowArray == null) continue;
                for (CategoryRow categoryRow : categoryRowArray) {
                    ArrayList arrayList2;
                    if (!FunctionTableModel.isSelectedProduct(categoryRow.fProduct, list)) continue;
                    if (hashMap.containsKey(categoryRow.fProduct)) {
                        arrayList2 = (ArrayList)hashMap.get(categoryRow.fProduct);
                        if (arrayList2.contains(categoryRow.getCategoryName())) continue;
                        ((ArrayList)hashMap.get(categoryRow.fProduct)).add(categoryRow.getCategoryName());
                        arrayList.add(categoryRow);
                        continue;
                    }
                    arrayList2 = new ArrayList();
                    arrayList2.add(categoryRow.getCategoryName());
                    hashMap.put(categoryRow.fProduct, arrayList2);
                    arrayList.add(categoryRow);
                }
            }
            return arrayList;
        }

        private static ArrayList<CategoryRow> selectMatchingRows(CategoryRow[] categoryRowArray, List<FunctionReferenceUtils.FunctionProductData> list) {
            if (categoryRowArray == null) {
                return null;
            }
            ArrayList<CategoryRow> arrayList = new ArrayList<CategoryRow>();
            for (CategoryRow categoryRow : categoryRowArray) {
                if (!FunctionTableModel.isSelectedProduct(categoryRow.fProduct, list)) continue;
                arrayList.add(categoryRow);
            }
            return arrayList;
        }

        CategoryRow[] findMatchingRows(String string, List<FunctionReferenceUtils.FunctionProductData> list) {
            String[] stringArray = (string = string.toLowerCase().trim()).split(" ");
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            ArrayList<CategoryRow> arrayList = null;
            if (stringArray.length == 1) {
                if (stringArray[0].length() >= 2) {
                    SortedMap sortedMap = this.subMap(stringArray[0], stringArray[0] + "z");
                    if (sortedMap != null && sortedMap.size() > 0) {
                        arrayList = CategoryIndex.selectMatchingRows(sortedMap.values(), list);
                    }
                    if (arrayList == null) {
                        return null;
                    }
                    return arrayList.toArray(new CategoryRow[0]);
                }
                return null;
            }
            for (String string2 : stringArray) {
                if (string2.length() < 2 || (arrayList = arrayList == null ? CategoryIndex.selectMatchingRows((CategoryRow[])this.get(string2), list) : CategoryIndex.intersect(arrayList, CategoryIndex.selectMatchingRows((CategoryRow[])this.get(string2), list))) != null) continue;
                return null;
            }
            if (arrayList != null) {
                return arrayList.toArray(new CategoryRow[0]);
            }
            return null;
        }

        @Override
        public Comparator<String> comparator() {
            return String.CASE_INSENSITIVE_ORDER;
        }
    }

    static interface FunctionSearchResult
    extends SearchResult {
        public String getProduct();

        public String getTitle();

        public String getRefPageFunction();

        public Url getFullUrl(boolean var1);

        public String getH1Line();
    }

    private static class BrowseSearchResult
    implements FunctionSearchResult {
        private String iName;
        private String iPath;
        private String iProduct = "matlab";
        private final String iH1Line;

        public BrowseSearchResult(String string, String string2, String string3, String string4) {
            this.iName = string;
            this.iPath = string3;
            this.iProduct = string2;
            this.iH1Line = string4;
        }

        @Override
        public String getProduct() {
            return this.iProduct;
        }

        @Override
        public String getTitle() {
            return this.iName;
        }

        @Override
        public String getRefPageFunction() {
            return this.iName;
        }

        @Override
        public Url getFullUrl(boolean bl) {
            Url url = FunctionReferenceUtils.getFullUrlForProduct((String)this.iProduct, (String)this.iPath, (boolean)bl);
            if (url != null) {
                return HelpUtils.getLocalizedUrl((Url)url);
            }
            return null;
        }

        @Override
        public String getH1Line() {
            return this.iH1Line;
        }

        public BrowseSearchResult deepCopy() {
            return new BrowseSearchResult(this.iName, this.iProduct, this.iPath, this.iH1Line);
        }

        public String toString() {
            return this.iName;
        }
    }

    static class HeaderRow
    extends DefaultExpandableRow {
        public String fHeading = null;
        public String fAction;

        public HeaderRow(String string, String string2) {
            this.fHeading = string;
            this.fAction = string2;
        }

        public Class getCellClassAt(int n) {
            return String.class;
        }

        public Object getValueAt(int n) {
            if (n == 0) {
                return this.fHeading;
            }
            return this.fAction;
        }
    }

    static class CategoryRow
    extends DefaultExpandableRow {
        public String fCategory = null;
        private String fProduct = "";
        private boolean fShowProductSuffix = false;

        public CategoryRow(String string) {
            this.fCategory = string;
        }

        public CategoryRow(String string, String string2) {
            this.fCategory = string;
            this.fProduct = string2;
        }

        void setShowProductSuffix(boolean bl) {
            this.fShowProductSuffix = bl;
        }

        String getCategoryName() {
            return this.fCategory;
        }

        String getProductName() {
            return this.fProduct;
        }

        public Class getCellClassAt(int n) {
            return String.class;
        }

        public Object getValueAt(int n) {
            if (n == 0) {
                if (this.fShowProductSuffix && this.fProduct != null && this.fProduct.length() > 0) {
                    return this.fCategory + " (" + this.fProduct + ")";
                }
                return this.fCategory;
            }
            return "";
        }

        public CategoryRow deepCopy() {
            CategoryRow categoryRow = new CategoryRow(this.fCategory, this.fProduct);
            categoryRow.fShowProductSuffix = this.fShowProductSuffix;
            if (!this.hasChildren()) {
                return categoryRow;
            }
            for (Object e : this.getChildren()) {
                if (e instanceof CategoryRow) {
                    CategoryRow categoryRow2 = (CategoryRow)((Object)e);
                    if (categoryRow2.getChildren() == null) continue;
                    categoryRow.addChild((Object)((CategoryRow)((Object)e)).deepCopy());
                    continue;
                }
                if (!(e instanceof BrowseFunctionRow)) continue;
                categoryRow.addChild((Object)((BrowseFunctionRow)((Object)e)).deepCopy());
            }
            return categoryRow;
        }
    }

    static class ReferenceDataResult
    implements FunctionSearchResult {
        private final ReferenceData iData;

        ReferenceDataResult(ReferenceData referenceData) {
            this.iData = referenceData;
        }

        @Override
        public String getProduct() {
            return this.iData.getDocSetItem().getShortName();
        }

        @Override
        public String getTitle() {
            return this.iData.getTopic();
        }

        @Override
        public String getRefPageFunction() {
            return this.iData.getTopic();
        }

        @Override
        public Url getFullUrl(boolean bl) {
            return FunctionReferenceUtils.getPageLocation((ReferenceData)this.iData, (boolean)bl);
        }

        @Override
        public String getH1Line() {
            return this.iData.getPurposeLine();
        }
    }

    static class ReferenceDataRow
    extends ResultFunctionRow<ReferenceDataResult> {
        protected ReferenceDataRow(ReferenceDataResult referenceDataResult) {
            super(referenceDataResult);
        }
    }

    private static class BrowseFunctionRow
    extends ResultFunctionRow<BrowseSearchResult> {
        protected BrowseFunctionRow(BrowseSearchResult browseSearchResult) {
            super(browseSearchResult);
        }

        public BrowseFunctionRow deepCopy() {
            BrowseSearchResult browseSearchResult = ((BrowseSearchResult)this.getSearchResult()).deepCopy();
            return new BrowseFunctionRow(browseSearchResult);
        }
    }

    static class ResultFunctionRow<T extends FunctionSearchResult>
    extends FunctionRow<T> {
        private final T iResult;

        protected ResultFunctionRow(T t) {
            this.iResult = t;
        }

        @Override
        protected T getSearchResult() {
            return this.iResult;
        }
    }

    static abstract class FunctionRow<T extends FunctionSearchResult>
    extends DefaultExpandableRow {
        protected FunctionRow() {
            this.setExpandable(false);
        }

        protected abstract T getSearchResult();

        public Class getCellClassAt(int n) {
            return n == 0 ? FunctionSearchResult.class : String.class;
        }

        public Object getValueAt(int n) {
            if (n == 0) {
                return this.getSearchResult();
            }
            return this.getSearchResult().getH1Line();
        }

        public boolean hasChildren() {
            return false;
        }
    }
}

