/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.FigurePeerWindowEvent;
import com.mathworks.hg.peer.FigurePeerWindowListener;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.Url;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.HelpDisplayType;
import com.mathworks.mlwidgets.help.HelpPanel;
import com.mathworks.mlwidgets.help.HelpPanelLinkClickedHandler;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.OpenBrowserStrategies;
import com.mathworks.mlwidgets.html.OpenBrowserStrategy;
import com.mathworks.mlwidgets.html.OpenBrowserStrategyId;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJDialogParent;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.SwingUtilities;

public class CSHelpViewer {
    private static CSHelpViewer sSingleton = null;
    private static CSHelpDisplay sTestDisplay = null;
    private static ExternalDisplayHandler sTestDisplayHandler = null;
    private CSHelpDisplay fCSHelpDisplay;
    private ExternalDisplayHandler fDisplayHandler;
    private MJDialog fDialog;
    private MJDialogParent fDialogParent = null;
    private Component fParentComponent = null;
    private boolean fIsParentModal = false;
    private Dimension fSize = null;
    private Point fLocation = null;
    private String fDefaultTitle = null;
    private CSHPageChangedListener fPageChangedListener;
    private final PrefListener fPrefListener = new DocCenterPrefsListener();
    private Window fParentWindow;
    private WindowListener fParentWindowListener;

    private CSHelpViewer() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.fCSHelpDisplay = CSHelpViewer.getCSHelpDisplay();
                CSHelpViewer.this.fDisplayHandler = CSHelpViewer.this.getDisplayHandler();
                CSHelpViewer.this.fDefaultTitle = HelpUtils.getLocalizedString((String)"cshelpviewer.title");
                HelpPrefs.addPrefsListeners((PrefListener)CSHelpViewer.this.fPrefListener, (String[])new String[]{"HelpDocCenterLocation"});
            }
        });
    }

    static synchronized CSHelpViewer getInstance() {
        if (sSingleton == null) {
            sSingleton = new CSHelpViewer();
        }
        return sSingleton;
    }

    private static CSHelpDisplay getCSHelpDisplay() {
        if (sTestDisplay == null) {
            return new CSHelpPanelDisplay();
        }
        return sTestDisplay;
    }

    private ExternalDisplayHandler getDisplayHandler() {
        if (sTestDisplayHandler == null) {
            return new HelpBrowserDisplayHandler();
        }
        return sTestDisplayHandler;
    }

    static String getHtmlText() {
        return CSHelpViewer.getCSHelpDisplay().getHtmlText();
    }

    void displayTopic(final Object object, final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.showViewer(object);
                CSHelpViewer.this.fCSHelpDisplay.displayTopic(string, string2);
            }
        });
    }

    void displayFile(final Object object, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.showViewer(object);
                CSHelpViewer.this.fCSHelpDisplay.setCurrentLocation(string);
            }
        });
    }

    void displayTopic(String string, String string2) {
        this.displayTopic(null, string, string2);
    }

    void displayFile(String string) {
        this.displayFile(null, string);
    }

    void setLocation(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.fLocation = new Point(n, n2);
                if (CSHelpViewer.this.fDialog != null) {
                    CSHelpViewer.this.fDialog.setLocation(CSHelpViewer.this.fLocation);
                }
            }
        });
    }

    void setSize(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSHelpViewer.this.fSize = new Dimension(n, n2);
                if (CSHelpViewer.this.fDialog != null) {
                    CSHelpViewer.this.fDialog.setSize(CSHelpViewer.this.fSize);
                }
            }
        });
    }

    void close() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CSHelpViewer.this.fDialog != null) {
                    CSHelpViewer.this.handleWindowClosing();
                    CSHelpViewer.this.fDialog.setVisible(false);
                }
            }
        });
    }

    private void disposeDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CSHelpViewer.this.fDialog != null) {
                    CSHelpViewer.this.fDialog.dispose();
                }
            }
        });
    }

    private synchronized void dispose() {
        sSingleton = null;
    }

    private static Component getOwnerComponent(Object object) {
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        } else if (object instanceof FigurePeer) {
            FigurePeer figurePeer = (FigurePeer)object;
            component = figurePeer.getAxisComponent();
        }
        return component;
    }

    private void showViewer(Object object) {
        assert (SwingUtilities.isEventDispatchThread()) : "showViewer must be called on the EDT";
        Component component = CSHelpViewer.getOwnerComponent(object);
        if (this.fDialog != null && this.isOwnerUnchanged(component)) {
            this.fDialog.setVisible(true);
            this.fDialog.toFront();
        } else if (component == null) {
            this.parentViewerToNull();
        } else {
            this.parentViewerToOwner(component);
            if (object instanceof FigurePeer) {
                FigurePeer figurePeer = (FigurePeer)object;
                figurePeer.addFigurePeerWindowListener((FigurePeerWindowListener)new CshFigurePeerWindowListener());
            }
        }
        this.handleListeners();
        this.fParentComponent = component;
    }

    private boolean isOwnerUnchanged(Component component) {
        if (this.fParentComponent != null && component != null) {
            return this.fParentComponent.equals(component);
        }
        return this.fParentComponent == null && component == null;
    }

    private void removeParent() {
        if (this.fDialog != null) {
            this.saveDialogInfo();
            this.fDialog.remove(this.fCSHelpDisplay.getComponent());
            this.fDialog.dispose();
            this.fDialog = null;
            if (this.fDialogParent != null) {
                this.fDialogParent.dispose();
                this.fDialogParent = null;
            }
        }
        if (this.fParentWindow != null && this.fParentWindowListener != null) {
            this.fParentWindow.removeWindowListener(this.fParentWindowListener);
            this.fParentWindow = null;
            this.fParentWindowListener = null;
        }
    }

    private void parentViewerToNull() {
        assert (SwingUtilities.isEventDispatchThread()) : "The context-sensitive help viewer must be reparented on the event dispatch thread.";
        this.removeParent();
        this.fDialog = new MJDialog();
        this.fIsParentModal = false;
        this.finishDialogSetup();
    }

    private void parentViewerToOwner(Component component) {
        assert (SwingUtilities.isEventDispatchThread()) : "The context-sensitive help viewer must be parented on the event dispatch thread.";
        assert (component != null) : "The context-sensitive help viewer must be parented with non-null Component.";
        this.removeParent();
        Window window = !(component instanceof Dialog) && !(component instanceof Frame) ? SwingUtilities.windowForComponent(component) : (Window)component;
        if (window == null) {
            this.parentViewerToNull();
            return;
        }
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            this.fIsParentModal = dialog.isModal();
            this.fDialog = new MJDialog(dialog);
        } else {
            this.fIsParentModal = false;
            this.fDialog = new MJDialog((Frame)window);
        }
        this.fParentWindow = window;
        this.fParentWindowListener = new ParentWindowAdapter();
        this.fParentWindow.addWindowListener(this.fParentWindowListener);
        this.finishDialogSetup();
    }

    private void finishDialogSetup() {
        assert (SwingUtilities.isEventDispatchThread()) : "The context-sensitive help viewer must be set up on the event dispatch thread.";
        if (this.fSize == null) {
            this.fSize = new Dimension(400, 400);
        }
        if (this.fLocation == null) {
            this.fLocation = new Point(20, 40);
        }
        this.fDialog.setName("CSH Dialog");
        this.fDialog.getContentPane().setLayout(new BorderLayout());
        this.fDialog.getContentPane().add(this.fCSHelpDisplay.getComponent(), "Center");
        this.fDialog.setSize(this.fSize);
        this.fDialog.setLocation(this.fLocation);
        this.fDialog.setVisible(true);
        this.fDialog.setTitle(this.fDefaultTitle);
        this.fDialog.addWindowListener((WindowListener)new CSHWindowAdapter());
        if (PlatformInfo.isWindows()) {
            this.fDialogParent = new MJDialogParent(this.fDefaultTitle);
            this.fDialogParent.setVisible(true);
            this.fDialogParent.attachDialog((Dialog)this.fDialog);
        }
    }

    private void handleListeners() {
        if (this.fPageChangedListener == null) {
            this.fPageChangedListener = new CSHPageChangedListener();
            this.fCSHelpDisplay.addPageChangedListener(this.fPageChangedListener);
        }
    }

    private void removeListeners() {
        if (this.fPageChangedListener != null) {
            this.fCSHelpDisplay.removePageChangedListener(this.fPageChangedListener);
            this.fPageChangedListener = null;
        }
    }

    private void saveDialogInfo() {
        this.fSize = this.fDialog.getSize();
        this.fLocation = this.fDialog.getLocation();
    }

    private void handleWindowClosing() {
        this.removeListeners();
        this.fCSHelpDisplay.setCurrentLocation("about:blank");
        this.fParentComponent = null;
    }

    private static OpenBrowserStrategies getOpenBrowserStrategies() {
        OpenBrowserStrategies openBrowserStrategies = new OpenBrowserStrategies();
        openBrowserStrategies.addOpenBrowserStrategy(OpenBrowserStrategyId.CURRENT_BROWSER, (OpenBrowserStrategy)new OpenCurrentBrowserStrategy());
        return openBrowserStrategies;
    }

    private String getCurrentLocation() {
        if (this.fCSHelpDisplay != null) {
            return this.fCSHelpDisplay.getCurrentLocation();
        }
        return null;
    }

    private Component getParentComponent() {
        return this.fParentComponent;
    }

    private static void setTestHelpViewer(CSHelpDisplay cSHelpDisplay) {
        sTestDisplay = cSHelpDisplay;
    }

    private static void setTestDisplayHandler(ExternalDisplayHandler externalDisplayHandler) {
        sTestDisplayHandler = externalDisplayHandler;
    }

    static /* synthetic */ OpenBrowserStrategies access$2100() {
        return CSHelpViewer.getOpenBrowserStrategies();
    }

    private class DocCenterPrefsListener
    implements PrefListener {
        private DocCenterPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CSHelpViewer.this.close();
                    CSHelpViewer.this.disposeDialog();
                    CSHelpViewer.this.dispose();
                }
            });
        }
    }

    private static class OpenCurrentBrowserStrategy
    implements OpenBrowserStrategy {
        private OpenCurrentBrowserStrategy() {
        }

        public void openUrl(Url url) {
            CSHelpViewer.getInstance().fCSHelpDisplay.setCurrentLocation(url);
        }
    }

    private class HelpBrowserDisplayHandler
    implements ExternalDisplayHandler {
        private HelpBrowserDisplayHandler() {
        }

        @Override
        public void displayPage(String string) {
            if (string.startsWith("docsuggestion:")) {
                return;
            }
            if (string.contains("?qdoc=")) {
                MLHelpServices.docSearch((String)string.substring(string.indexOf("qdoc=") + 5));
                return;
            }
            if (!HTMLUtils.isTargetOnPage((String)CSHelpViewer.this.fCSHelpDisplay.getCurrentLocation(), (String)string)) {
                MLHelpServices.setCurrentLocation((String)string);
            }
        }
    }

    public static interface ExternalDisplayHandler {
        public void displayPage(String var1);
    }

    private static class CSHelpPanelDisplay
    implements CSHelpDisplay {
        private final HelpPanel fHelpPanel = new HelpPanel((DocConfig)DocCenterDocConfig.getInstance(), CSHelpViewer.access$2100(), null, HelpDisplayType.CONTEXT_SENSITIVE_HELP);

        private CSHelpPanelDisplay() {
            this.fHelpPanel.addLinkClickedHandler((HelpPanelLinkClickedHandler)new CSHLinkClickedHandler());
            this.fHelpPanel.getHtmlComponent().getComponent().setName("CSH HTML Renderer");
            this.fHelpPanel.getHtmlComponent().disableNavigation();
        }

        @Override
        public void setCurrentLocation(String string) {
            this.fHelpPanel.setCurrentLocation(string);
        }

        @Override
        public void setCurrentLocation(Url url) {
            this.fHelpPanel.setCurrentLocation(url);
        }

        @Override
        public void displayTopic(String string, String string2) {
            CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(string);
            if (cSHelpTopicMap.exists()) {
                String string3 = cSHelpTopicMap.mapID(string2);
                if (string3 != null) {
                    this.setCurrentLocation(string3);
                } else {
                    this.fHelpPanel.setHtmlText("<html><body>Topic " + string2 + " in " + cSHelpTopicMap.getFilePath() + " not found.</body></html>");
                }
            } else {
                this.fHelpPanel.setHtmlText("<html><body>Mapfile not found: " + cSHelpTopicMap.getFilePath() + "</body></html>");
            }
        }

        @Override
        public String getCurrentLocation() {
            return this.fHelpPanel.getCurrentLocation();
        }

        @Override
        public Component getComponent() {
            return this.fHelpPanel.getHtmlComponent().getComponent();
        }

        @Override
        public void addPageChangedListener(PageChangedListener pageChangedListener) {
            this.fHelpPanel.getHtmlComponent().addPageChangedListener(pageChangedListener);
        }

        @Override
        public void removePageChangedListener(PageChangedListener pageChangedListener) {
            this.fHelpPanel.getHtmlComponent().removePageChangedListener(pageChangedListener);
        }

        @Override
        public String getHtmlText() {
            return this.fHelpPanel.getHtmlText();
        }
    }

    public static interface CSHelpDisplay {
        public void setCurrentLocation(String var1);

        public void setCurrentLocation(Url var1);

        public void displayTopic(String var1, String var2);

        public String getCurrentLocation();

        public Component getComponent();

        public void addPageChangedListener(PageChangedListener var1);

        public void removePageChangedListener(PageChangedListener var1);

        public String getHtmlText();
    }

    private class ParentWindowAdapter
    extends WindowAdapter {
        private ParentWindowAdapter() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            super.windowClosed(windowEvent);
            CSHelpViewer.this.saveDialogInfo();
            CSHelpViewer.this.handleWindowClosing();
        }
    }

    private class CSHWindowAdapter
    extends WindowAdapter {
        private CSHWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            CSHelpViewer.this.saveDialogInfo();
            CSHelpViewer.this.handleWindowClosing();
        }
    }

    private static class CSHLinkClickedHandler
    extends HelpPanelLinkClickedHandler {
        private CSHLinkClickedHandler() {
        }

        public void linkClicked(Url url) {
            CSHLinkClickedHandler.handleLinkClicked(url);
        }

        protected boolean handleLinkClickRequest(BrowserRequest browserRequest) {
            return CSHLinkClickedHandler.handleLinkClicked(browserRequest.getUrl());
        }

        private static boolean handleLinkClicked(final Url url) {
            if (CSHelpViewer.getInstance().fIsParentModal) {
                return false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CSHelpViewer.getInstance().fDisplayHandler.displayPage(url.toString());
                }
            });
            return true;
        }
    }

    private class CSHPageChangedListener
    implements PageChangedListener {
        private CSHPageChangedListener() {
        }

        public void pageChanged(PageChangedEvent pageChangedEvent) {
            String string = pageChangedEvent.getTitle();
            Url url = pageChangedEvent.getNewUrl();
            if (CSHelpViewer.this.fDialog != null) {
                if (string == null || string.trim().isEmpty() || url != null && url.getBaseUrl().equals(HTMLUtils.getFilenameFromURL((String)string))) {
                    CSHelpViewer.this.fDialog.setTitle(CSHelpViewer.this.fDefaultTitle);
                } else {
                    CSHelpViewer.this.fDialog.setTitle(string);
                }
                if (PlatformInfo.isWindows() && CSHelpViewer.this.fDialogParent != null) {
                    CSHelpViewer.this.fDialogParent.setTitle(string);
                }
            }
        }
    }

    private class CshFigurePeerWindowListener
    implements FigurePeerWindowListener {
        private CshFigurePeerWindowListener() {
        }

        public void figurePeerWindowEvent(FigurePeerWindowEvent figurePeerWindowEvent) {
            if (figurePeerWindowEvent.getID() == 201) {
                CSHelpViewer.this.close();
            }
        }
    }
}

