/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.mde.help.DocCenterLocationPanel;
import com.mathworks.mde.help.DocCenterProductsPanel;
import com.mathworks.mde.help.DocCenterSettingChangedEventDispatcher;
import com.mathworks.mde.help.DocCenterSettingListener;
import com.mathworks.mde.help.HelpOnSelectionPanel;
import com.mathworks.mde.help.HelpPrefsComponentPanel;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.LanguagePrefsPanel;
import com.mathworks.mlwidgets.help.DocCenterProductPrefs;
import com.mathworks.mlwidgets.help.DocLocaleValidator;
import com.mathworks.mlwidgets.help.HelpPopup;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.ProductFilterModel;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Locale;
import javax.swing.JComponent;

class DocCenterPrefsPanel
implements HelpPrefsComponentPanel {
    private final MJPanel fPanel = new MJPanel();
    private final DocCenterLocationPanel fDocCenterLocationPanel;
    private final DocCenterProductsPanel fDocCenterProductsPanel;
    private final HelpOnSelectionPanel fHelpOnSelectionPanel;
    private final LanguagePrefsPanel fLanguagePrefsPanel;

    DocCenterPrefsPanel() {
        this.fPanel.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
        this.fPanel.setName("DocCenterPrefsPanel");
        this.fPanel.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 131072));
        this.fDocCenterLocationPanel = new DocCenterLocationPanel();
        this.fDocCenterProductsPanel = new DocCenterProductsPanel();
        this.fLanguagePrefsPanel = new LanguagePrefsPanel();
        this.fHelpOnSelectionPanel = new HelpOnSelectionPanel();
        this.layoutPanel();
        DocCenterSettingListener docCenterSettingListener = new DocCenterSettingListener(){

            @Override
            public void docCenterSettingChanged(DocCenterSettingChangedEventDispatcher.DocCenterSettingChangedEvent docCenterSettingChangedEvent) {
                switch (docCenterSettingChangedEvent) {
                    case LOCATION_WEB: {
                        DocCenterPrefsPanel.this.layoutPanel(DocLocation.WEB);
                        break;
                    }
                    case LOCATION_INSTALLED: {
                        DocCenterPrefsPanel.this.layoutPanel(DocLocation.INSTALLED);
                        break;
                    }
                }
            }
        };
        DocCenterSettingChangedEventDispatcher.getInstance().addDocCenterSettingListener(docCenterSettingListener);
    }

    private void layoutPanel() {
        this.layoutPanel(HelpPrefs.getDocCenterLocation());
    }

    private void layoutPanel(DocLocation docLocation) {
        DocLocaleValidator docLocaleValidator = new DocLocaleValidator(docLocation);
        this.layoutPanel(docLocaleValidator.getAllowedLanguageLocales());
    }

    private void layoutPanel(Collection<LanguageLocale> collection) {
        this.fPanel.removeAll();
        if (HelpPrefs.isDocLocationOnWebSupported()) {
            this.fPanel.add((Component)this.fDocCenterLocationPanel.getComponent());
        }
        this.fPanel.add((Component)this.fDocCenterProductsPanel.getComponent());
        if (collection.size() > 1) {
            this.fPanel.add((Component)this.fLanguagePrefsPanel.getComponent());
        }
        this.fPanel.add((Component)this.fHelpOnSelectionPanel.getComponent());
        this.fPanel.validate();
        this.fPanel.repaint();
    }

    @Override
    public void savePrefs() {
        HelpPrefs.setDocCenterLocation((String)this.fDocCenterLocationPanel.getSelectedLocation());
        ProductFilterModel productFilterModel = this.createProductFilterModel();
        DocCenterProductPrefs.setSelectedProductPreferences((ProductFilterModel)productFilterModel);
        Locale locale = DocCenterPrefsPanel.getDocLocaleToSet(this.fDocCenterLocationPanel.getSelectedLocation(), this.fLanguagePrefsPanel.getSelectedLocale());
        HelpPrefs.setDocLocale((Locale)locale);
        HelpPopup.setShowHelpBrowserPreference((boolean)this.fHelpOnSelectionPanel.usingHelpBrowser());
    }

    private ProductFilterModel createProductFilterModel() {
        boolean bl = this.fDocCenterProductsPanel.getShowUninstalledProducts();
        return new ProductFilterModel(this.fDocCenterProductsPanel.getSelectedProducts(), bl);
    }

    private static Locale getDocLocaleToSet(String string, Locale locale) {
        DocLocaleValidator docLocaleValidator = new DocLocaleValidator(string);
        LanguageLocale languageLocale = LanguageLocale.fromLocale((Locale)locale);
        if (docLocaleValidator.isAllowed(languageLocale)) {
            return languageLocale.getLocale();
        }
        return LanguageLocale.ENGLISH.getLocale();
    }

    @Override
    public void resetPrefs() {
        this.fDocCenterProductsPanel.resetSelectedProducts();
    }

    @Override
    public boolean validateOptions() {
        boolean bl = true;
        if (this.fDocCenterProductsPanel.isProductFilterEnabled() && this.fDocCenterProductsPanel.getSelectedProducts().isEmpty()) {
            MJOptionPane.showMessageDialog((Component)this.fPanel, (Object)HelpUtils.getLocalizedString((String)"filter.selection_error"));
            bl = false;
        }
        return bl;
    }

    @Override
    public void dispose() {
        DocCenterProductsPanel.removeListeners();
        DocCenterLocationPanel.removeListeners();
    }

    public JComponent getComponent() {
        return this.fPanel;
    }
}

