/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.Url;
import com.mathworks.html.WebUrl;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.help.AddressLocator;
import com.mathworks.mde.help.DocCenterBrowserHandler;
import com.mathworks.mde.help.HelpBrowserHandler;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.MLHelpBrowserActiveTab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HelpLocator
extends MJDialog {
    private static HelpLocator sHelpLocator = null;
    private final AddressLocator fAddressLocator;
    private final HelpLocatorHelper fHelpLocatorHelper;
    private final HelpLocatorInfoProvider fHelpInfoProvider;
    private final MyDTClientAdapterListener fMyDTClientAdapterListener;
    private final MJTextField fWebTextField;
    private final MJTextField fInstalledTextField;
    private final MJButton fWebGoButton;

    public static synchronized void invoke(MJFrame mJFrame) {
        HelpLocator.invoke(mJFrame, new AddressLocator());
    }

    private static synchronized void invoke(MJFrame mJFrame, AddressLocator addressLocator) {
        HelpLocator.invoke(mJFrame, addressLocator, new DocCenterInfoProvider());
    }

    private static synchronized void invoke(MJFrame mJFrame, AddressLocator addressLocator, HelpLocatorInfoProvider helpLocatorInfoProvider) {
        HelpLocator.invoke(mJFrame, addressLocator, helpLocatorInfoProvider, new DocCenterHelper());
    }

    private static synchronized void invoke(MJFrame mJFrame, AddressLocator addressLocator, HelpLocatorInfoProvider helpLocatorInfoProvider, HelpLocatorHelper helpLocatorHelper) {
        if (sHelpLocator == null) {
            sHelpLocator = new HelpLocator(mJFrame, addressLocator, helpLocatorInfoProvider, helpLocatorHelper);
        } else {
            sHelpLocator.toFront();
        }
    }

    public static synchronized HelpLocator getInstance() {
        return sHelpLocator;
    }

    private HelpLocator(MJFrame mJFrame, AddressLocator addressLocator, HelpLocatorInfoProvider helpLocatorInfoProvider, HelpLocatorHelper helpLocatorHelper) {
        super((Frame)mJFrame);
        this.fHelpInfoProvider = helpLocatorInfoProvider;
        this.fHelpLocatorHelper = helpLocatorHelper;
        this.setTitle(com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.title"));
        this.setName("HelpLocator");
        this.setResizable(false);
        this.fAddressLocator = addressLocator;
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new FormLayout("p, 3dlu, p:grow, 3dlu, p", "p, 3dlu, p, 8dlu, p, 3dlu, p, 8dlu, pref:grow, 8dlu, p"));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)mJPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        String string = com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.install.description");
        ImageIcon imageIcon = CommonIcon.HELP.getIcon();
        mJPanel.add((Component)new MJLabel((Icon)imageIcon), (Object)cellConstraints.xy(1, 1));
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.getAccessibleContext().setAccessibleName(string);
        mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(3, 1));
        this.fInstalledTextField = new MJTextField();
        this.fInstalledTextField.setName("InstalledTextField");
        this.fInstalledTextField.setEditable(false);
        this.fInstalledTextField.setCursor(Cursor.getPredefinedCursor(2));
        mJPanel.add((Component)this.fInstalledTextField, (Object)cellConstraints.xyw(1, 3, 3));
        String string2 = com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.web.description");
        ImageIcon imageIcon2 = CommonIcon.WEB.getIcon();
        mJPanel.add((Component)new MJLabel((Icon)imageIcon2), (Object)cellConstraints.xy(1, 5));
        MJLabel mJLabel2 = new MJLabel(string2);
        mJLabel2.getAccessibleContext().setAccessibleName(string2);
        mJPanel.add((Component)mJLabel2, (Object)cellConstraints.xy(3, 5));
        this.fWebTextField = new MJTextField();
        this.fWebTextField.setName("WebTextField");
        this.fWebTextField.setEditable(false);
        this.fWebTextField.setCursor(Cursor.getPredefinedCursor(2));
        mJPanel.add((Component)this.fWebTextField, (Object)cellConstraints.xyw(1, 7, 3));
        this.fWebGoButton = new MJButton(com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.go"));
        this.fWebGoButton.setName("WebGoButton");
        this.fWebGoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpLocator.this.executeCommand("web('" + HelpLocator.this.getWebAddress() + "','-browser')");
            }
        });
        mJPanel.add((Component)this.fWebGoButton, (Object)cellConstraints.xy(5, 7));
        this.updateComponents();
        mJPanel.add((Component)new MJLabel((Icon)DialogIcon.INFO.getIcon(), 2), (Object)cellConstraints.xy(1, 9, CellConstraints.LEFT, CellConstraints.TOP));
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(com.mathworks.mlwidgets.help.HelpUtils.getLocalizedString((String)"helplocator.release.warning"), true);
        mJMultilineLabel.setSize(new Dimension(this.fWebTextField.getPreferredSize().width, 1));
        mJPanel.add((Component)mJMultilineLabel, (Object)cellConstraints.xy(3, 9));
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        MJButton mJButton = new MJButton(HelpUtils.getLocalizedString((String)"helplocator.close"));
        mJButton.setName("Close");
        mJButton.setActionCommand("Close");
        mJButton.addActionListener((ActionListener)buttonActionListener);
        MJButton mJButton2 = new MJButton(HelpUtils.getLocalizedString((String)"helplocator.help"));
        mJButton2.setName("Help");
        mJButton2.setActionCommand("Help");
        mJButton2.addActionListener((ActionListener)buttonActionListener);
        mJPanel.add((Component)ButtonBarFactory.buildCloseHelpBar((JButton)mJButton, (JButton)mJButton2), (Object)cellConstraints.xyw(1, 11, 5));
        this.fHelpInfoProvider.registerPageChangedListener(this.fHelpLocatorHelper.getPageChangedListener());
        this.fHelpLocatorHelper.registerActiveTabListener(this.fHelpLocatorHelper.getActiveTabListener());
        this.fMyDTClientAdapterListener = new MyDTClientAdapterListener();
        MLDesktop.getInstance().addClientListener(this.fHelpLocatorHelper.getClientTitle(), (DTClientListener)this.fMyDTClientAdapterListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpLocator.this.closeHelpLocator();
            }
        });
        this.pack();
        this.setLocationRelativeTo((Component)mJFrame);
        this.setVisible(true);
    }

    private String getInstalledWebCommand() {
        return this.fAddressLocator.getInstalledWebCommand();
    }

    private String getWebAddress() {
        WebUrl webUrl = this.fAddressLocator.getWebAddress();
        return webUrl != null ? webUrl.toString() : "";
    }

    private void resetAddresses(final Url url) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpLocator.this.fAddressLocator.setAddresses(url);
                HelpLocator.getInstance().updateComponents();
            }
        });
    }

    private void updateComponents() {
        String string = this.getWebAddress();
        String string2 = this.getInstalledWebCommand();
        this.fWebTextField.setText(string);
        this.fInstalledTextField.setText(string2);
        this.fWebGoButton.setEnabled(!string.isEmpty());
    }

    private void executeCommand(final String string) {
        Matlab.whenMatlabReady((Runnable)new Runnable(){

            @Override
            public void run() {
                HelpLocator.this.doMatlabEval(string);
            }
        });
    }

    private synchronized void doMatlabEval(String string) {
        new Matlab().evalConsoleOutput(string);
    }

    private synchronized void closeHelpLocator() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MLDesktop.getInstance().removeClientListener(HelpLocator.this.fHelpLocatorHelper.getClientTitle(), (DTClientListener)HelpLocator.this.fMyDTClientAdapterListener);
                HelpLocator.this.fHelpInfoProvider.removePageChangedListener(HelpLocator.this.fHelpLocatorHelper.getPageChangedListener());
                HelpLocator.this.fHelpLocatorHelper.removeActiveTabListener(HelpLocator.this.fHelpLocatorHelper.getActiveTabListener());
                HelpLocator.this.dispose();
                sHelpLocator = null;
            }
        });
    }

    private static class DocCenterInfoProvider
    implements HelpLocatorInfoProvider {
        private MLHelpBrowser iHelpBrowser;
        private final HelpBrowserHandler fDocCenterHandler = new DocCenterBrowserHandler();

        private DocCenterInfoProvider() {
        }

        @Override
        public void registerPageChangedListener(Object object) {
            assert (object instanceof PageChangedListener);
            this.iHelpBrowser = MLHelpBrowserActiveTab.getActiveHelpBrowserTab();
            if (this.iHelpBrowser != null) {
                this.iHelpBrowser.addPageChangedListener((PageChangedListener)object);
            }
        }

        @Override
        public void removePageChangedListener(Object object) {
            assert (object instanceof PageChangedListener);
            if (this.iHelpBrowser != null) {
                this.iHelpBrowser.removePageChangedListener((PageChangedListener)object);
            }
            this.iHelpBrowser = null;
        }

        @Override
        public String getCurrentLocation() {
            return this.fDocCenterHandler.getCurrentLocation();
        }
    }

    public static interface HelpLocatorInfoProvider {
        public String getCurrentLocation();

        public void registerPageChangedListener(Object var1);

        public void removePageChangedListener(Object var1);
    }

    private static class DocCenterHelper
    implements HelpLocatorHelper {
        private PageChangedListener iPageChangedListener = new DocCenterPageChangedListener();
        private ChangeListener iActiveTabListener = new DoccenterActiveTabListener();

        private DocCenterHelper() {
        }

        @Override
        public String getClientTitle() {
            return "Doc Center";
        }

        @Override
        public Object getPageChangedListener() {
            return this.iPageChangedListener;
        }

        @Override
        public Object getActiveTabListener() {
            return this.iActiveTabListener;
        }

        @Override
        public void registerActiveTabListener(Object object) {
            if (object instanceof ChangeListener) {
                MLHelpBrowserActiveTab.addListener((ChangeListener)object);
            }
        }

        @Override
        public void removeActiveTabListener(Object object) {
            if (object instanceof ChangeListener) {
                MLHelpBrowserActiveTab.removeListener((ChangeListener)object);
            }
        }

        private static class DoccenterActiveTabListener
        implements ChangeListener {
            private DoccenterActiveTabListener() {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HelpLocator.getInstance().closeHelpLocator();
            }
        }

        private static class DocCenterPageChangedListener
        implements PageChangedListener {
            private DocCenterPageChangedListener() {
            }

            public void pageChanged(PageChangedEvent pageChangedEvent) {
                HelpLocator.getInstance().resetAddresses(pageChangedEvent.getNewUrl());
            }
        }
    }

    private static interface HelpLocatorHelper {
        public String getClientTitle();

        public Object getPageChangedListener();

        public Object getActiveTabListener();

        public void registerActiveTabListener(Object var1);

        public void removeActiveTabListener(Object var1);
    }

    private class MyDTClientAdapterListener
    extends DTClientAdapter {
        private MyDTClientAdapterListener() {
        }

        public void clientClosing(DTClientEvent dTClientEvent) {
            HelpLocator.this.closeHelpLocator();
        }

        public void clientDocking(DTClientEvent dTClientEvent) {
            HelpLocator.this.closeHelpLocator();
        }

        public void clientUndocking(DTClientEvent dTClientEvent) {
            HelpLocator.this.closeHelpLocator();
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Close")) {
                HelpLocator.this.closeHelpLocator();
            } else if (string.equals("Help")) {
                String string2 = com.mathworks.mlwidgets.help.HelpUtils.getMapfileName((String)"matlab", (String)"matlab_env");
                MLHelpServices.cshDisplayTopic((Object)((Object)HelpLocator.this), (String)string2, (String)"matlab_env_help_page_location");
            }
        }
    }
}

